/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.client.entity.model;

import dtnpaletteofpaws.client.backward_imitate.DTNWolfRenderState_21_3;
import dtnpaletteofpaws.common.entity.DTNWolf;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class DTNWolfModel
extends EntityModel<DTNWolfRenderState_21_3> {
    public ModelPart head;
    public ModelPart realHead;
    public ModelPart body;
    public ModelPart mane;
    public ModelPart legBackRight;
    public ModelPart legBackLeft;
    public ModelPart legFrontRight;
    public ModelPart legFrontLeft;
    public ModelPart tail;
    public ModelPart realTail;
    public boolean young;

    public DTNWolfModel(ModelPart box) {
        super(box);
        this.head = box.getChild("head");
        this.realHead = this.head.getChild("real_head");
        this.body = box.getChild("body");
        this.mane = box.getChild("upper_body");
        this.legBackRight = box.getChild("right_hind_leg");
        this.legBackLeft = box.getChild("left_hind_leg");
        this.legFrontRight = box.getChild("right_front_leg");
        this.legFrontLeft = box.getChild("left_front_leg");
        this.tail = box.getChild("tail");
        this.realTail = this.tail.getChild("real_tail");
    }

    public void prepareMobModel(DTNWolf dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.resetAllPose();
        if (dog.isInSittingPose()) {
            this.setUpSitPose(dog, limbSwing, limbSwingAmount, partialTickTime);
        } else {
            this.setUpStandPose(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
        this.translateBeggingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
        this.translateShakingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
    }

    public void resetAllPose() {
        this.body.resetPose();
        this.head.resetPose();
        this.legBackLeft.resetPose();
        this.legBackRight.resetPose();
        this.legFrontLeft.resetPose();
        this.legFrontRight.resetPose();
        this.mane.resetPose();
        this.realHead.resetPose();
        this.realTail.resetPose();
        this.tail.resetPose();
    }

    public void setupAnim(DTNWolf dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot += headPitch * ((float)Math.PI / 180);
        this.head.yRot += netHeadYaw * ((float)Math.PI / 180);
        this.tail.xRot = dog.getTailRotation();
        this.tail.yRot = dog.getWagAngle(limbSwing, limbSwingAmount, ageInTicks);
    }

    public void setUpStandPose(DTNWolf dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.animateStandWalking(dog, limbSwing, limbSwingAmount, partialTickTime);
    }

    public void animateStandWalking(DTNWolf dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        float w = Mth.cos((float)(limbSwing * 0.6662f));
        float w1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI));
        this.legBackRight.xRot += w * 1.4f * limbSwingAmount;
        this.legBackLeft.xRot += w1 * 1.4f * limbSwingAmount;
        this.legFrontRight.xRot += w1 * 1.4f * limbSwingAmount;
        this.legFrontLeft.xRot += w * 1.4f * limbSwingAmount;
    }

    public void setUpSitPose(DTNWolf dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.tail.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-9.0f, (float)-2.0f));
        this.legFrontLeft.offsetRotation(KeyframeAnimations.degreeVec((float)-27.0f, (float)0.0f, (float)0.0f));
        this.legFrontLeft.offsetPos(KeyframeAnimations.posVec((float)0.01f, (float)-1.0f, (float)0.0f));
        this.legFrontRight.offsetRotation(KeyframeAnimations.degreeVec((float)-27.0f, (float)0.0f, (float)0.0f));
        this.legFrontRight.offsetPos(KeyframeAnimations.posVec((float)0.01f, (float)-1.0f, (float)0.0f));
        this.legBackLeft.offsetRotation(KeyframeAnimations.degreeVec((float)-90.0f, (float)0.0f, (float)0.0f));
        this.legBackLeft.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.0f, (float)-5.0f));
        this.legBackRight.offsetRotation(KeyframeAnimations.degreeVec((float)-90.0f, (float)0.0f, (float)0.0f));
        this.legBackRight.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.0f, (float)-5.0f));
        this.mane.offsetRotation(KeyframeAnimations.degreeVec((float)-18.0f, (float)0.0f, (float)0.0f));
        this.mane.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-2.0f, (float)0.0f));
        this.body.offsetRotation(KeyframeAnimations.degreeVec((float)-45.0f, (float)0.0f, (float)0.0f));
        this.body.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-4.0f, (float)-2.0f));
        this.head.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f));
        this.head.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f));
    }

    public void translateShakingDog(DTNWolf dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.mane.zRot = dog.getShakeAngle(partialTickTime, -0.08f);
        this.body.zRot = dog.getShakeAngle(partialTickTime, -0.16f);
        this.realTail.zRot = dog.getShakeAngle(partialTickTime, -0.2f);
    }

    public void translateBeggingDog(DTNWolf dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.realHead.zRot = dog.getBegAngle(partialTickTime) + dog.getShakeAngle(partialTickTime, 0.0f);
    }

    public static LayerDefinition createBodyLayer() {
        return DTNWolfModel.createBodyLayerInternal(CubeDeformation.NONE);
    }

    private static LayerDefinition createBodyLayerInternal(CubeDeformation scale) {
        MeshDefinition var0 = new MeshDefinition();
        PartDefinition var1 = var0.getRoot();
        float var2 = 13.5f;
        PartDefinition var3 = var1.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.5f, (float)-7.0f));
        PartDefinition real_head = var3.addOrReplaceChild("real_head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, scale).texOffs(0, 10).addBox(-1.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, scale), PartPose.ZERO);
        real_head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(16, 14).addBox(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-3.0f, (float)0.5f));
        real_head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(16, 14).addBox(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-3.0f, (float)0.5f));
        var1.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 14).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, scale), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        var1.addOrReplaceChild("upper_body", CubeListBuilder.create().texOffs(21, 0).addBox(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, scale), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder var4 = CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale);
        var1.addOrReplaceChild("right_hind_leg", var4, PartPose.offset((float)-1.5f, (float)16.0f, (float)7.0f));
        var1.addOrReplaceChild("left_hind_leg", var4, PartPose.offset((float)1.5f, (float)16.0f, (float)7.0f));
        var1.addOrReplaceChild("right_front_leg", var4, PartPose.offset((float)-1.5f, (float)16.0f, (float)-4.0f));
        var1.addOrReplaceChild("left_front_leg", var4, PartPose.offset((float)1.5f, (float)16.0f, (float)-4.0f));
        PartDefinition var5 = var1.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        var5.addOrReplaceChild("real_tail", CubeListBuilder.create().texOffs(9, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)var0, (int)64, (int)32);
    }

    public void setupAnim(DTNWolfRenderState_21_3 render_state) {
        DTNWolf dog = render_state.wolf;
        float walk_anim_time = render_state.walkAnimationPos;
        float walk_anim_speed = render_state.walkAnimationSpeed;
        float yrot = render_state.yRot;
        float xrot = render_state.xRot;
        float ticks_with_partial = render_state.ageInTicks;
        this.young = dog.isBaby();
        this.prepareMobModel(dog, walk_anim_time, walk_anim_speed, render_state.partialTick);
        this.setupAnim(dog, walk_anim_time, walk_anim_speed, ticks_with_partial, yrot, xrot);
    }
}

