/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.client.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dtnpaletteofpaws.client.backward_imitate.DTNWolfRenderLayer_21_3;
import dtnpaletteofpaws.client.backward_imitate.DTNWolfRenderState_21_3;
import dtnpaletteofpaws.client.entity.model.DTNWolfModel;
import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.util.Util;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.equipment.Equippable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class DTNWolfArmorRenderer
extends DTNWolfRenderLayer_21_3 {
    private static final Map<Crackiness.Level, ResourceLocation> ARMOR_CRACK_LOCATIONS = Map.of(Crackiness.Level.LOW, Util.getVanillaResource("textures/entity/wolf/wolf_armor_crackiness_low.png"), Crackiness.Level.MEDIUM, Util.getVanillaResource("textures/entity/wolf/wolf_armor_crackiness_medium.png"), Crackiness.Level.HIGH, Util.getVanillaResource("textures/entity/wolf/wolf_armor_crackiness_high.png"));
    private static final ResourceLocation WOLF_ARMOR_MAIN_21_3 = Util.getVanillaResource("textures/entity/equipment/wolf_body/armadillo_scute.png");
    private static final ResourceLocation WOLF_ARMOR_DYE_21_3 = Util.getVanillaResource("textures/entity/equipment/wolf_body/armadillo_scute_overlay.png");

    public DTNWolfArmorRenderer(RenderLayerParent parentRenderer, EntityRendererProvider.Context ctx) {
        super((RenderLayerParent<DTNWolfRenderState_21_3, DTNWolfModel>)parentRenderer);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, DTNWolf dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!dog.isTame() || dog.isInvisible()) {
            return;
        }
        if (!dog.hasWolfArmor()) {
            return;
        }
        Optional<Pair<ItemStack, Item>> wolfArmorOptional = this.getWolfArmorItem(dog);
        if (!wolfArmorOptional.isPresent()) {
            return;
        }
        Pair<ItemStack, Item> wolfArmorPair = wolfArmorOptional.get();
        DTNWolfModel dogModel = this.getParentModel();
        dogModel.prepareMobModel(dog, limbSwing, limbSwingAmount, partialTicks);
        dogModel.setupAnim(dog, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.renderWolfArmorLayerMain(dogModel, poseStack, buffer, packedLight, (Item)wolfArmorPair.getRight());
        this.renderWolfArmorLayerDyed(dogModel, poseStack, buffer, packedLight, (ItemStack)wolfArmorPair.getLeft(), (Item)wolfArmorPair.getRight());
        this.renderWolfArmorLayerCracks(dogModel, poseStack, buffer, packedLight, (ItemStack)wolfArmorPair.getLeft());
    }

    private Optional<Pair<ItemStack, Item>> getWolfArmorItem(DTNWolf dog) {
        ItemStack wolf_armor_stack = dog.getBodyArmorItem();
        if (!DTNWolfArmorRenderer.isWolfArmor_1_21_5(wolf_armor_stack)) {
            return Optional.empty();
        }
        return Optional.of(Pair.of((Object)wolf_armor_stack, (Object)wolf_armor_stack.getItem()));
    }

    private void renderWolfArmorLayerMain(DTNWolfModel model, PoseStack poseStack, MultiBufferSource buffer, int light, Item item) {
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)WOLF_ARMOR_MAIN_21_3));
        model.renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
    }

    private void renderWolfArmorLayerDyed(DTNWolfModel model, PoseStack stack, MultiBufferSource buffer, int light, ItemStack itemStack, Item item) {
        if (item != Items.WOLF_ARMOR) {
            return;
        }
        int i = DyedItemColor.getOrDefault((ItemStack)itemStack, (int)0);
        if (ARGB.alpha((int)i) == 0) {
            return;
        }
        ResourceLocation armor_overlay = WOLF_ARMOR_DYE_21_3;
        if (armor_overlay == null) {
            return;
        }
        float r = (float)ARGB.red((int)i) / 255.0f;
        float g = (float)ARGB.green((int)i) / 255.0f;
        float b = (float)ARGB.blue((int)i) / 255.0f;
        model.renderToBuffer(stack, buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)armor_overlay)), light, OverlayTexture.NO_OVERLAY, ARGB.colorFromFloat((float)1.0f, (float)r, (float)g, (float)b));
    }

    private void renderWolfArmorLayerCracks(DTNWolfModel model, PoseStack stack, MultiBufferSource buffer, int light, ItemStack itemStack) {
        Crackiness.Level crack_level = Crackiness.WOLF_ARMOR.byDamage(itemStack);
        if (crack_level == Crackiness.Level.NONE) {
            return;
        }
        ResourceLocation crack_rl = ARMOR_CRACK_LOCATIONS.get(crack_level);
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)crack_rl));
        model.renderToBuffer(stack, vertexconsumer, light, OverlayTexture.NO_OVERLAY, -1);
    }

    public static boolean isWolfArmor_1_21_5(ItemStack stack) {
        EquipmentSlot slot = Optional.ofNullable((Equippable)stack.get(DataComponents.EQUIPPABLE)).map(x -> x.slot()).orElse(null);
        if (slot == null) {
            return false;
        }
        return slot.getType() == EquipmentSlot.Type.ANIMAL_ARMOR;
    }
}

