/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.data;

import dtnpaletteofpaws.DTNRegistries;
import dtnpaletteofpaws.VanillaWolfVariants;
import dtnpaletteofpaws.WolfVariants;
import dtnpaletteofpaws.common.util.Util;
import dtnpaletteofpaws.common.variant.WolfVariant;
import dtnpaletteofpaws.common.variant.biome_config.WolfBiomeConfig;
import dtnpaletteofpaws.common.variant.biome_config.WolfBiomeConfigs;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DTNWolfBiomeConfigPackProvider {
    public static void start(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        CompletableFuture prov = event.getLookupProvider();
        DataGenerator.PackGenerator pack_gen = gen.getBuiltinDatapack(true, "dtnpaletteofpaws", "dtnp_wolf_spawn_rate_inc");
        pack_gen.addProvider(pack_output -> PackMetadataGenerator.forFeaturePack((PackOutput)pack_output, (Component)Component.literal((String)"Increase DTNP Wolf Spawn Rate")));
        pack_gen.addProvider(DTNWolfBiomeConfigPackProvider.wolfBiomeConfigDataProvFactory(prov, (RegistrySetBuilder.RegistryBootstrap<WolfBiomeConfig>)((RegistrySetBuilder.RegistryBootstrap)DTNWolfBiomeConfigPackProvider::createWolfSpawnRateIncContent)));
        pack_gen = gen.getBuiltinDatapack(true, "dtnpaletteofpaws", "dtnp_vanilla_variants_spawn");
        pack_gen.addProvider(pack_output -> PackMetadataGenerator.forFeaturePack((PackOutput)pack_output, (Component)Component.literal((String)"Add vanilla's Armored Paws variants as DTNP Wolf Spawn.")));
        pack_gen.addProvider(DTNWolfBiomeConfigPackProvider.wolfBiomeConfigDataProvFactory(prov, (RegistrySetBuilder.RegistryBootstrap<WolfBiomeConfig>)((RegistrySetBuilder.RegistryBootstrap)DTNWolfBiomeConfigPackProvider::createVanillaVariantSpawnContent)));
    }

    public static void createWolfSpawnRateIncContent(BootstrapContext<WolfBiomeConfig> ctx) {
        WolfBiomeConfig.builder(ctx, WolfVariants.CHERRY).biome(Biomes.CHERRY_GROVE).spawnChance(0.3f).packSize(1, 3).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.LEMONY_LIME).biome(Biomes.BEACH).extraSpawnableBlock(Blocks.SAND).spawnChance(0.05f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.HIMALAYAN_SALT).biome(Biomes.JAGGED_PEAKS).spawnChance(0.25f).packSize(1, 3).buildAndRegister();
        WolfBiomeConfig.builder(ctx, Util.getResource("wolf_bamboo_bamboo")).variant(WolfVariants.BAMBOO).biome(Biomes.BAMBOO_JUNGLE).packSize(1, 3).spawnChance(0.4f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, Util.getResource("wolf_bamboo_jungle")).variant(WolfVariants.BAMBOO).biome(Biomes.JUNGLE).packSize(1, 3).spawnChance(0.05f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.CRIMSON).biome(Biomes.CRIMSON_FOREST).extraSpawnableBlock(Blocks.CRIMSON_NYLIUM).canSpawnInDark().spawnChance(0.4f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.WARPED).biome(Biomes.WARPED_FOREST).extraSpawnableBlock(Blocks.WARPED_NYLIUM).canSpawnInDark().spawnChance(0.4f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.MOLTEN).biome(Biomes.BASALT_DELTAS).extraSpawnableBlock(Blocks.BASALT, Blocks.BLACKSTONE, Blocks.LAVA, Blocks.MAGMA_BLOCK).canSpawnInDark().spawnChance(0.4f).packSize(1, 3).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.BIRCH).biome(Biomes.BIRCH_FOREST).spawnChance(0.1f).packSize(1, 3).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.PISTACHIO).biome(Biomes.MANGROVE_SWAMP).extraSpawnableBlock(Blocks.MUD).canSpawnInDark().spawnChance(0.25f).packSize(1, 3).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.GUACAMOLE).biome(Biomes.MEADOW).spawnChance(0.2f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, Util.getResource("caffeine_pack_config")).variant(WolfVariants.CAPPUCCINO, WolfVariants.LATTE, WolfVariants.MOCHA, WolfVariants.ESPRESSO).biome(Biomes.DARK_FOREST).canSpawnInDark().packSize(1, 4).spawnChance(0.15f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.WITHERED_SOUL).biome(Biomes.SOUL_SAND_VALLEY).extraSpawnableBlock(Blocks.SOUL_SAND, Blocks.SOUL_SOIL).canSpawnInDark().packSize(1, 3).spawnChance(0.4f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.BONITO_FLAKES).biome(Biomes.WOODED_BADLANDS).extraSpawnableBlock(Blocks.RED_SAND).spawnChance(0.2f).packSize(1, 3).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.KOMBU).biome(Biomes.DESERT).extraSpawnableBlock(Blocks.SAND).spawnChance(0.1f).packSize(1, 3).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.SHITAKE).biome(Biomes.DARK_FOREST).canSpawnInDark().packSize(1, 2).spawnChance(0.15f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.ENOKI).biome(Biomes.DESERT).extraSpawnableBlock(Blocks.SAND).spawnChance(0.1f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, Util.getResource("gelato_suite")).variant(WolfVariants.CHOCOLATE, WolfVariants.STRAWBERRY, WolfVariants.VANILLA, WolfVariants.CAKE).biome(Biomes.SNOWY_PLAINS).canSpawnInDark().packSize(1, 3).spawnChance(0.25f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.WALNUT).biome(Biomes.OLD_GROWTH_SPRUCE_TAIGA).packSize(1, 3).spawnChance(0.3f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, WolfVariants.WANDERING_SOUL).biome(Biomes.SOUL_SAND_VALLEY).extraSpawnableBlock(Blocks.SOUL_SAND, Blocks.SOUL_SOIL).canSpawnInDark().spawnChance(0.1f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, Util.getResource("nether_waste_suite")).variant(WolfVariants.SANGUINE, WolfVariants.DESICCATED).biome(Biomes.NETHER_WASTES).extraSpawnableBlock(Blocks.NETHERRACK).canSpawnInDark().spawnChance(0.1f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, Util.getResource("ice_spike_spawn")).variant(WolfVariants.ICY, WolfVariants.FROSTY).biome(Biomes.ICE_SPIKES).extraSpawnableBlock(Blocks.ICE, Blocks.PACKED_ICE).packSize(1, 2).spawnChance(0.15f).buildAndRegister();
        WolfBiomeConfig.builder(ctx, Util.getResource("savanna_suite")).variant(WolfVariants.SOOTY, WolfVariants.BRINDLE, WolfVariants.MUDDY, WolfVariants.ROOT_BEER).biome(Biomes.SAVANNA).canSpawnInDark().packSize(1, 4).spawnChance(0.2f).buildAndRegister();
    }

    public static void createVanillaVariantSpawnContent(BootstrapContext<WolfBiomeConfig> ctx) {
        DTNWolfBiomeConfigPackProvider.getVanillaBuilder(ctx, VanillaWolfVariants.WOOD).biome(Biomes.FOREST).spawnChance(0.11f).packSize(4, 4).buildAndRegister();
        DTNWolfBiomeConfigPackProvider.getVanillaBuilder(ctx, VanillaWolfVariants.ASHEN).biome(Biomes.SNOWY_TAIGA).spawnChance(0.13f).packSize(4, 4).buildAndRegister();
        DTNWolfBiomeConfigPackProvider.getVanillaBuilder(ctx, VanillaWolfVariants.RUSTY).biome(Biomes.SPARSE_JUNGLE).spawnChance(0.14f).packSize(2, 4).buildAndRegister();
        DTNWolfBiomeConfigPackProvider.getVanillaBuilder(ctx, VanillaWolfVariants.SNOWY).biome(Biomes.GROVE).spawnChance(0.08f).packSize(1, 1).buildAndRegister();
        DTNWolfBiomeConfigPackProvider.getVanillaBuilder(ctx, VanillaWolfVariants.SPOTTED).biome(Biomes.SAVANNA_PLATEAU).spawnChance(0.12f).packSize(4, 8).buildAndRegister();
        DTNWolfBiomeConfigPackProvider.getVanillaBuilder(ctx, VanillaWolfVariants.BLACK).biome(Biomes.OLD_GROWTH_PINE_TAIGA).spawnChance(0.13f).packSize(4, 4).buildAndRegister();
        DTNWolfBiomeConfigPackProvider.getVanillaBuilder(ctx, VanillaWolfVariants.PALE).biome(Biomes.TAIGA).spawnChance(0.13f).packSize(4, 4).buildAndRegister();
        DTNWolfBiomeConfigPackProvider.getVanillaBuilder(ctx, VanillaWolfVariants.CHESTNUT).biome(Biomes.OLD_GROWTH_SPRUCE_TAIGA).spawnChance(0.13f).packSize(4, 4).buildAndRegister();
        DTNWolfBiomeConfigPackProvider.getVanillaBuilder(ctx, VanillaWolfVariants.STRIPED).biome(Biomes.WOODED_BADLANDS).spawnChance(0.25f).packSize(4, 8).buildAndRegister();
    }

    private static WolfBiomeConfig.Builder getVanillaBuilder(BootstrapContext<WolfBiomeConfig> ctx, Supplier<WolfVariant> variant_sup) {
        WolfVariant variant = variant_sup.get();
        Registry<WolfVariant> variant_reg = DTNRegistries.DTN_WOLF_VARIANT.get();
        ResourceLocation wolf_variant_id = variant_reg.getKey((Object)variant);
        if (wolf_variant_id == null) {
            throw new IllegalStateException("unregistered wolf variant");
        }
        ResourceLocation register_id = Util.getResource("vanilla_" + wolf_variant_id.getPath());
        return WolfBiomeConfig.builder(ctx, register_id).variant(variant);
    }

    public static DataProvider.Factory<DatapackBuiltinEntriesProvider> wolfBiomeConfigDataProvFactory(CompletableFuture<HolderLookup.Provider> prov, RegistrySetBuilder.RegistryBootstrap<WolfBiomeConfig> bootstrap) {
        RegistrySetBuilder wolf_biome_set = new RegistrySetBuilder().add(WolfBiomeConfigs.regKey(), bootstrap);
        return pack_output -> new DatapackBuiltinEntriesProvider(pack_output, prov, wolf_biome_set, Set.of("dtnpaletteofpaws"));
    }
}

