/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.entity;

import dtnpaletteofpaws.DTNEntityTypes;
import dtnpaletteofpaws.DTNSerializers;
import dtnpaletteofpaws.common.backward_imitate.WolfInteractionResult;
import dtnpaletteofpaws.common.backward_imitate.WolfSound_1_21_5;
import dtnpaletteofpaws.common.entity.DTNWolfSwimmingManager;
import dtnpaletteofpaws.common.entity.WetSource;
import dtnpaletteofpaws.common.entity.ai.DTNWolfBegGoal;
import dtnpaletteofpaws.common.entity.ai.DTNWolfFloatGoal;
import dtnpaletteofpaws.common.entity.ai.DTNWolfFollwOwnerGoal;
import dtnpaletteofpaws.common.entity.ai.DTNWolfHurtByTargetGoal;
import dtnpaletteofpaws.common.entity.ai.DTNWolfRandomStrollGoal;
import dtnpaletteofpaws.common.entity.ai.DTNWolfSkeletonGoal;
import dtnpaletteofpaws.common.entity.ai.nav.DTNWolfPathNavigation;
import dtnpaletteofpaws.common.network.WolfShakingPacket;
import dtnpaletteofpaws.common.network.data.WolfShakingData;
import dtnpaletteofpaws.common.spawn.DTNWolfStaticSpawnManager;
import dtnpaletteofpaws.common.spawn.WolfSpawnPlacementType;
import dtnpaletteofpaws.common.util.WolfVariantUtil;
import dtnpaletteofpaws.common.variant.WolfVariant;
import dtnpaletteofpaws.common.variant.biome_config.WolfBiomeConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.fluids.FluidType;

public class DTNWolf
extends TamableAnimal {
    private static final EntityDataAccessor<Boolean> BEGGING = SynchedEntityData.defineId(DTNWolf.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> COLLAR_COLOR = SynchedEntityData.defineId(DTNWolf.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<WolfVariant> VARIANT = SynchedEntityData.defineId(DTNWolf.class, DTNSerializers.DTN_WOLF_VARIANT);
    private float percentDecreasePerHealthLost;
    private float maxHealth0;
    @Nonnull
    private WetSource wetSource = WetSource.NONE;
    private float headRotationCourse;
    private float headRotationCourseOld;
    private boolean isShaking;
    private boolean shakeFire = false;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private final MoveControl defaultMoveControl;
    private final PathNavigation defaultPathNavigation;
    private final DTNWolfSwimmingManager swimmingManager = new DTNWolfSwimmingManager(this);
    private boolean isDogSwimming = false;
    private boolean isDogFollowingSomeone;

    public DTNWolf(EntityType<? extends DTNWolf> p_30369_, Level p_30370_) {
        super(p_30369_, p_30370_);
        this.setTame(false, true);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.defaultMoveControl = this.moveControl;
        this.defaultPathNavigation = this.navigation;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)WolfVariantUtil.getDefault());
        builder.define(BEGGING, (Object)false);
        builder.define(COLLAR_COLOR, (Object)DyeColor.RED.getId());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new DTNWolfFloatGoal(this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new DTNWolfFollwOwnerGoal(this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new DTNWolfRandomStrollGoal(this));
        this.goalSelector.addGoal(9, (Goal)new DTNWolfBegGoal(this, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new DTNWolfHurtByTargetGoal(this).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(7, (Goal)new DTNWolfSkeletonGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    public boolean isBegging() {
        return (Boolean)this.entityData.get(BEGGING);
    }

    public void setBegging(boolean val) {
        this.entityData.set(BEGGING, (Object)val);
    }

    public WolfVariant getVariant() {
        return (WolfVariant)this.entityData.get(VARIANT);
    }

    public void setVariant(WolfVariant variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public DyeColor getCollarColor() {
        return DyeColor.byId((int)((Integer)this.entityData.get(COLLAR_COLOR)));
    }

    private void setCollarColor(DyeColor color) {
        this.entityData.set(COLLAR_COLOR, (Object)color.getId());
    }

    public ResourceLocation getTexture() {
        WolfVariant wolfvariant = this.getVariant();
        if (this.isTame()) {
            return wolfvariant.texture();
        }
        return wolfvariant.wildTexture();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 1.0f);
    }

    protected SoundEvent getAmbientSound() {
        if (this.random.nextInt(3) == 0) {
            return this.isTame() && this.getHealth() < 20.0f ? WolfSound_1_21_5.getWhineSound(this.level()) : WolfSound_1_21_5.getPantSound(this.level());
        }
        return WolfSound_1_21_5.getAmbientSound(this.level());
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return this.canWolfArmorAbsorb(source) ? SoundEvents.WOLF_ARMOR_DAMAGE : WolfSound_1_21_5.getHurtSound(this.level());
    }

    protected SoundEvent getDeathSound() {
        return WolfSound_1_21_5.getDeathSound(this.level());
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public void tick() {
        super.tick();
        this.updateClassicalAnim();
        if (this.isAlive() && this.getMaxHealth() != this.maxHealth0) {
            this.maxHealth0 = this.getMaxHealth();
            this.percentDecreasePerHealthLost = 1.0f / this.maxHealth0;
        }
        this.getVariant().tickWolf(this);
    }

    public void aiStep() {
        super.aiStep();
        this.updateDogBeginShake();
        if (this.fireImmune()) {
            this.floatHellhound(this);
        }
        if (!this.level().isClientSide && this.getVariant().swimUnderwater()) {
            this.swimmingManager.tickServer();
        }
    }

    protected PathNavigation createNavigation(Level level) {
        return new DTNWolfPathNavigation(this, level);
    }

    public float getPathfindingMalus(PathType type) {
        switch (type) {
            default: {
                break;
            }
            case WATER: 
            case WATER_BORDER: {
                if (!this.shouldDogOmitWaterPathWeight()) break;
                return 0.0f;
            }
            case LAVA: 
            case DAMAGE_FIRE: 
            case DANGER_FIRE: {
                if (!this.fireImmune()) break;
                return 0.0f;
            }
            case DANGER_POWDER_SNOW: 
            case POWDER_SNOW: {
                return -1.0f;
            }
        }
        return super.getPathfindingMalus(type);
    }

    public PathType inferType(PathType type) {
        if (this.fireImmune()) {
            if (type == PathType.DANGER_FIRE) {
                return PathType.WALKABLE;
            }
            if (type == PathType.LAVA) {
                return PathType.BLOCKED;
            }
        }
        if (this.getVariant().swimUnderwater() && type == PathType.WATER) {
            return PathType.WALKABLE;
        }
        return type;
    }

    private boolean shouldDogOmitWaterPathWeight() {
        if (this.isDogFollowingSomeone()) {
            return true;
        }
        if (!this.isInWater()) {
            return false;
        }
        return this.getVariant().swimUnderwater();
    }

    public boolean canStandOnFluid(FluidState state) {
        if (this.fireImmune() && state.is(FluidTags.LAVA)) {
            return true;
        }
        return super.canStandOnFluid(state);
    }

    private void floatHellhound(DTNWolf dog) {
        if (this.level().isClientSide) {
            return;
        }
        if (!dog.isInLava()) {
            return;
        }
        CollisionContext collisioncontext = CollisionContext.of((Entity)dog);
        if (collisioncontext.isAbove(LiquidBlock.SHAPE_STABLE, dog.blockPosition(), true) && !dog.level().getFluidState(dog.blockPosition().above()).is(FluidTags.LAVA)) {
            dog.setOnGround(true);
        } else {
            dog.setDeltaMovement(dog.getDeltaMovement().add(0.0, 0.085, 0.0));
        }
    }

    public boolean shouldDogBlockFloat() {
        if (this.fireImmune() && this.isInLava()) {
            return true;
        }
        return this.isDogSwimming();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return !this.getVariant().swimUnderwater();
    }

    private void updateDogBeginShake() {
        if (this.level().isClientSide) {
            return;
        }
        if (this.isShaking) {
            return;
        }
        if (this.isPathFinding()) {
            return;
        }
        if (!this.onGround()) {
            return;
        }
        if (this.wetSource.isNone()) {
            return;
        }
        if (this.checkDogInWetSourceAndWetTheDog()) {
            return;
        }
        if (this.wetSource.flame() && this.isOnFire()) {
            return;
        }
        this.startShakingAndBroadcast(this.wetSource.flame());
    }

    private void updateClassicalAnim() {
        if (!this.isAlive()) {
            return;
        }
        this.updateClassicalBegAnim();
        boolean val = this.checkDogInWetSourceAndWetTheDog();
        this.updateClassicalShakeAnim(val);
    }

    private void updateClassicalBegAnim() {
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
    }

    private boolean checkDogInWetSourceAndWetTheDog() {
        if (this.isInLava()) {
            this.wetSource = WetSource.LAVA;
            return true;
        }
        if (this.isInWater()) {
            this.wetSource = WetSource.WATER;
            return true;
        }
        if (this.isInWaterOrRain()) {
            this.wetSource = WetSource.RAIN;
            return true;
        }
        if (this.isInWater()) {
            this.wetSource = WetSource.BUBBLE_COLUMN;
            return true;
        }
        return false;
    }

    private void updateClassicalShakeAnim(boolean currentlyInWater) {
        if (!this.level().isClientSide && this.isShaking && currentlyInWater) {
            this.finishShaking();
            WolfShakingPacket.sendDogShakingPacket(this, WolfShakingData.State.STOP);
            return;
        }
        if (!this.isShaking) {
            return;
        }
        if (this.timeWolfIsShaking == 0.0f && !this.shakeFire) {
            this.playSound(SoundEvents.WOLF_SHAKE, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
        this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
        this.timeWolfIsShaking += 0.05f;
        if (this.prevTimeWolfIsShaking >= 2.0f) {
            this.wetSource = WetSource.NONE;
            this.finishShaking();
        }
        if (this.timeWolfIsShaking > 0.4f) {
            float f = (float)this.getY();
            int i = (int)(Mth.sin((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
            Vec3 vec3d = this.getDeltaMovement();
            for (int j = 0; j < i; ++j) {
                float f1 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                float f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                if (this.shakeFire) {
                    float r = this.getRandom().nextFloat();
                    SimpleParticleType type = ParticleTypes.SMOKE;
                    if (r <= 0.15f) {
                        type = ParticleTypes.LANDING_LAVA;
                    } else if (r <= 0.6f) {
                        type = ParticleTypes.LAVA;
                    }
                    this.level().addParticle((ParticleOptions)type, this.getX() + (double)f1, (double)(f + 0.8f), this.getZ() + (double)f2, vec3d.x, vec3d.y, vec3d.z);
                    continue;
                }
                this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() + (double)f1, (double)(f + 0.8f), this.getZ() + (double)f2, vec3d.x, vec3d.y, vec3d.z);
            }
        }
        if ((double)this.timeWolfIsShaking > 0.5 && this.shakeFire && this.random.nextInt(6) == 0) {
            this.playSound(SoundEvents.FIRE_EXTINGUISH, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    private void startShaking() {
        if (this.isShaking) {
            return;
        }
        this.isShaking = true;
        this.shakeFire = false;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public void startShakingAndBroadcast(boolean shakeFire) {
        if (this.isShaking) {
            return;
        }
        if (this.level().isClientSide) {
            return;
        }
        if (shakeFire) {
            this.startShakingLava();
            WolfShakingPacket.sendDogShakingPacket(this, WolfShakingData.State.SHAKE_LAVA);
            return;
        }
        this.startShaking();
        WolfShakingPacket.sendDogShakingPacket(this, WolfShakingData.State.SHAKE_WATER);
    }

    private void finishShaking() {
        this.isShaking = false;
        this.shakeFire = false;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public void startShakingLava() {
        if (this.isShaking) {
            return;
        }
        this.isShaking = true;
        this.shakeFire = true;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public boolean isShakingLava() {
        return this.isShaking && this.shakeFire;
    }

    public void handleDogShakingUpdate(WolfShakingData.State state) {
        switch (state) {
            case SHAKE_WATER: {
                this.startShaking();
                break;
            }
            case SHAKE_LAVA: {
                this.startShakingLava();
                break;
            }
            case STOP: {
                this.finishShaking();
                break;
            }
            default: {
                this.finishShaking();
            }
        }
    }

    public void resetBeggingRotation() {
        this.headRotationCourse = 0.0f;
        this.headRotationCourseOld = 0.0f;
    }

    public float getTailRotation() {
        if (!this.isTame()) {
            return 0.62831855f;
        }
        float full_health_angle = 1.73f;
        float lost_health = this.getMaxHealth() - this.getHealth();
        float lost_health_percent = lost_health * this.percentDecreasePerHealthLost;
        float lost_rad_percent = lost_health_percent * lost_health_percent;
        float lost_rad = 1.5707964f * lost_rad_percent;
        lost_rad = Mth.clamp((float)lost_rad, (float)0.0f, (float)1.5707964f);
        return 1.73f - lost_rad;
    }

    public float getWagAngle(float limbSwing, float limbSwingAmount, float partialTickTime) {
        return Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    public boolean isDogSoaked() {
        return this.wetSource.soaked();
    }

    public float getShadingWhileWet(float partialTicks) {
        if (this.getVariant().swimUnderwater()) {
            return 1.0f;
        }
        return Math.min(0.5f + Mth.lerp((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) / 2.0f * 0.5f, 1.0f);
    }

    public float getShakeAngle(float partialTicks, float offset) {
        float f = (Mth.lerp((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) + offset) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.sin((float)(f * (float)Math.PI)) * Mth.sin((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public float getBegAngle(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.headRotationCourseOld, (float)this.headRotationCourse) * 0.15f * (float)Math.PI;
    }

    public int getMaxHeadXRot() {
        return this.isInSittingPose() ? 20 : super.getMaxHeadXRot();
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.6f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(40.0);
            this.setHealth(40.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(20.0);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.handleWolfHeal(player, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleChangeDye(player, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleSetWolfArmor(player, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleRepairWolfArmor(player, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleUnsetWolfArmor(player, stack, hand).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleTameWolf(player, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        InteractionResult handle_super = super.mobInteract(player, hand);
        if (handle_super.consumesAction()) {
            return handle_super;
        }
        if (this.handleWolfSitStand(player, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        return handle_super;
    }

    private WolfInteractionResult handleWolfHeal(Player player, ItemStack stack) {
        if (!this.isTame()) {
            return WolfInteractionResult.PASS;
        }
        if (!this.isFood(stack)) {
            return WolfInteractionResult.PASS;
        }
        if (this.getHealth() >= this.getMaxHealth()) {
            return WolfInteractionResult.PASS;
        }
        if (this.level().isClientSide) {
            return WolfInteractionResult.SUCCESS;
        }
        FoodProperties food_props = (FoodProperties)stack.get(DataComponents.FOOD);
        float nutrition = food_props != null ? (float)food_props.nutrition() : 1.0f;
        this.heal(2.0f * nutrition);
        stack.shrink(1);
        return WolfInteractionResult.SUCCESS;
    }

    private WolfInteractionResult handleChangeDye(Player player, ItemStack stack) {
        Item item = stack.getItem();
        if (!this.isTame()) {
            return WolfInteractionResult.PASS;
        }
        if (!(item instanceof DyeItem)) {
            return WolfInteractionResult.PASS;
        }
        DyeItem dye = (DyeItem)item;
        if (!this.isOwnedBy((LivingEntity)player)) {
            return WolfInteractionResult.PASS;
        }
        DyeColor color = dye.getDyeColor();
        if (color == this.getCollarColor()) {
            return WolfInteractionResult.PASS;
        }
        if (this.level().isClientSide) {
            return WolfInteractionResult.SUCCESS;
        }
        this.setCollarColor(color);
        stack.shrink(1);
        return WolfInteractionResult.SUCCESS;
    }

    private WolfInteractionResult handleSetWolfArmor(Player player, ItemStack stack) {
        if (!stack.is(Items.WOLF_ARMOR)) {
            return WolfInteractionResult.PASS;
        }
        if (this.hasWolfArmor()) {
            return WolfInteractionResult.PASS;
        }
        if (!this.isTame()) {
            return WolfInteractionResult.PASS;
        }
        if (!this.isOwnedBy((LivingEntity)player)) {
            return WolfInteractionResult.PASS;
        }
        if (this.level().isClientSide) {
            return WolfInteractionResult.SUCCESS;
        }
        this.setBodyArmorItem(stack.copyWithCount(1));
        stack.consume(1, (LivingEntity)player);
        return WolfInteractionResult.SUCCESS;
    }

    private WolfInteractionResult handleRepairWolfArmor(Player player, ItemStack stack) {
        if (stack.getItem() != Items.ARMADILLO_SCUTE) {
            return WolfInteractionResult.PASS;
        }
        if (!this.hasWolfArmor()) {
            return WolfInteractionResult.PASS;
        }
        if (!this.isTame()) {
            return WolfInteractionResult.PASS;
        }
        if (!this.isOwnedBy((LivingEntity)player)) {
            return WolfInteractionResult.PASS;
        }
        ItemStack wolf_armor = this.getBodyArmorItem();
        if (!wolf_armor.isDamaged()) {
            return WolfInteractionResult.PASS;
        }
        if (this.level().isClientSide) {
            return WolfInteractionResult.SUCCESS;
        }
        stack.shrink(1);
        this.playSound(SoundEvents.WOLF_ARMOR_REPAIR);
        int repair_val = (int)((float)stack.getMaxDamage() * 0.125f);
        int new_damage_val = wolf_armor.getDamageValue() - repair_val;
        if (new_damage_val < 0) {
            new_damage_val = 0;
        }
        wolf_armor.setDamageValue(new_damage_val);
        return WolfInteractionResult.SUCCESS;
    }

    private WolfInteractionResult handleUnsetWolfArmor(Player player, ItemStack stack, InteractionHand hand) {
        if (!stack.is(Items.SHEARS)) {
            return WolfInteractionResult.PASS;
        }
        if (!this.hasWolfArmor()) {
            return WolfInteractionResult.PASS;
        }
        if (!this.isTame()) {
            return WolfInteractionResult.PASS;
        }
        if (!this.isOwnedBy((LivingEntity)player)) {
            return WolfInteractionResult.PASS;
        }
        if (this.level().isClientSide) {
            return WolfInteractionResult.SUCCESS;
        }
        stack.hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
        this.playSound(SoundEvents.ARMOR_UNEQUIP_WOLF);
        ItemStack wolf_armor0 = this.getBodyArmorItem();
        this.setBodyArmorItem(ItemStack.EMPTY);
        this.spawnAtLocation((ServerLevel)this.level(), wolf_armor0);
        return WolfInteractionResult.SUCCESS;
    }

    private WolfInteractionResult handleTameWolf(Player player, ItemStack stack) {
        if (!stack.is(Items.BONE)) {
            return WolfInteractionResult.PASS;
        }
        if (this.isTame()) {
            return WolfInteractionResult.PASS;
        }
        if (this.level().isClientSide) {
            return WolfInteractionResult.SUCCESS;
        }
        stack.shrink(1);
        if (this.random.nextInt(3) == 0) {
            this.tame(player);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
        return WolfInteractionResult.SUCCESS;
    }

    private WolfInteractionResult handleWolfSitStand(Player player, ItemStack stack) {
        if (!this.isOwnedBy((LivingEntity)player)) {
            return WolfInteractionResult.PASS;
        }
        this.setOrderedToSit(!this.isOrderedToSit());
        this.jumping = false;
        this.navigation.stop();
        this.setTarget(null);
        return WolfInteractionResult.SUCCESS;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.WOLF_FOOD);
    }

    private boolean canWolfArmorAbsorb(DamageSource p_331524_) {
        return this.hasWolfArmor() && !p_331524_.is(DamageTypeTags.BYPASSES_WOLF_ARMOR);
    }

    public boolean hasWolfArmor() {
        return !this.getBodyArmorItem().isEmpty();
    }

    protected void hurtArmor(DamageSource source, float amount) {
        this.doHurtEquipment(source, amount, new EquipmentSlot[]{EquipmentSlot.BODY});
    }

    public boolean hurtServer(ServerLevel level, DamageSource p_30386_, float p_30387_) {
        if (this.isInvulnerableTo(level, p_30386_)) {
            return false;
        }
        if (!this.level().isClientSide) {
            this.setOrderedToSit(false);
        }
        return super.hurtServer(level, p_30386_, p_30387_);
    }

    protected void actuallyHurt(ServerLevel level, DamageSource source, float amount) {
        if (this.mayWolfArmorAbsorb(source, amount)) {
            return;
        }
        super.actuallyHurt(level, source, amount);
    }

    private boolean mayWolfArmorAbsorb(DamageSource source, float amount) {
        if (!this.canWolfArmorAbsorb(source)) {
            return false;
        }
        ItemStack wolf_armor_stack = this.getBodyArmorItem();
        int damage_val0 = wolf_armor_stack.getDamageValue();
        int damage_max0 = wolf_armor_stack.getMaxDamage();
        wolf_armor_stack.hurtAndBreak(Mth.ceil((float)amount), (LivingEntity)this, EquipmentSlot.BODY);
        this.playWolfArmorCrackSound(this.useItem, damage_val0, damage_max0);
        return true;
    }

    private void playWolfArmorCrackSound(ItemStack wolf_armor_stack, int damage_val0, int damage_max0) {
        Crackiness.Level crackiness0 = Crackiness.WOLF_ARMOR.byDamage(damage_val0, damage_max0);
        Crackiness.Level crackiness = Crackiness.WOLF_ARMOR.byDamage(wolf_armor_stack);
        if (crackiness == crackiness0) {
            return;
        }
        this.playSound(SoundEvents.WOLF_ARMOR_CRACK);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            sLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, Items.ARMADILLO_SCUTE.getDefaultInstance()), this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.2, 0.1, 0.2, 0.1);
        }
    }

    public void die(DamageSource p_30384_) {
        this.wetSource = WetSource.NONE;
        this.finishShaking();
        super.die(p_30384_);
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("CollarColor", (byte)this.getCollarColor().getId());
        compound.putString("variant", WolfVariantUtil.variantToString(this.getVariant()));
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        String variant_str = compound.getString("variant").orElse("");
        this.setVariant(WolfVariantUtil.variantFromString(variant_str));
        if (compound.getInt("CollarColor").isPresent()) {
            this.setCollarColor(DyeColor.byId((int)compound.getInt("CollarColor").orElse(-1)));
        }
    }

    @Nullable
    public DTNWolf getBreedOffspring(ServerLevel p_149088_, AgeableMob p_149089_) {
        DTNWolf wolf = (DTNWolf)DTNEntityTypes.DTNWOLF.get().create((Level)p_149088_, EntitySpawnReason.BREEDING);
        if (wolf != null && p_149089_ instanceof DTNWolf) {
            DTNWolf wolf1 = (DTNWolf)p_149089_;
            if (this.random.nextBoolean()) {
                wolf.setVariant(this.getVariant());
            } else {
                wolf.setVariant(wolf1.getVariant());
            }
            if (this.isTame()) {
                wolf.setOwnerReference(this.getOwnerReference());
                wolf.setTame(true, true);
                if (this.random.nextBoolean()) {
                    wolf.setCollarColor(this.getCollarColor());
                } else {
                    wolf.setCollarColor(wolf1.getCollarColor());
                }
            }
        }
        return wolf;
    }

    public boolean canMate(Animal p_30392_) {
        if (p_30392_ == this) {
            return false;
        }
        if (!this.isTame()) {
            return false;
        }
        if (!(p_30392_ instanceof DTNWolf)) {
            return false;
        }
        DTNWolf wolf = (DTNWolf)p_30392_;
        if (!wolf.isTame()) {
            return false;
        }
        return wolf.isInSittingPose() ? false : this.isInLove() && wolf.isInLove();
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        if (target instanceof Creeper || target instanceof Ghast || target instanceof ArmorStand) {
            return false;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal otherWolf = (TamableAnimal)target;
            return !otherWolf.isTame() || otherWolf.getOwner() != owner;
        }
        if (target instanceof Player) {
            Player player1;
            Player player = (Player)target;
            if (owner instanceof Player && !(player1 = (Player)owner).canHarmPlayer(player)) {
                return false;
            }
        }
        return true;
    }

    public boolean fireImmune() {
        return this.getVariant().fireImmune() || super.fireImmune();
    }

    public boolean causeFallDamage(double distance, float modifier, DamageSource source) {
        if (this.getVariant().fallImmune()) {
            return false;
        }
        return super.causeFallDamage(distance, modifier, source);
    }

    public boolean dampensVibrations() {
        if (this.getVariant().dampensVibrations()) {
            return true;
        }
        return super.dampensVibrations();
    }

    public void setNavigation(PathNavigation p) {
        if (this.navigation == p) {
            return;
        }
        this.navigation.stop();
        this.navigation = p;
    }

    public void setMoveControl(MoveControl m) {
        this.breakMoveControl();
        this.moveControl = m;
    }

    public void breakMoveControl() {
        this.moveControl.setWantedPosition(this.getX(), this.getY(), this.getZ(), 1.0);
        this.moveControl.tick();
        this.setJumping(false);
        this.setSpeed(0.0f);
        this.setXxa(0.0f);
        this.setYya(0.0f);
        this.setZza(0.0f);
    }

    public void resetNavigation() {
        this.setNavigation(this.defaultPathNavigation);
    }

    public void resetMoveControl() {
        this.setMoveControl(this.defaultMoveControl);
    }

    public void setDogSwimming(boolean val) {
        this.isDogSwimming = val;
    }

    public boolean isDogSwimming() {
        return this.isDogSwimming;
    }

    public boolean isDogFollowingSomeone() {
        return this.isDogFollowingSomeone;
    }

    public void setDogFollowingSomeone(boolean val) {
        this.isDogFollowingSomeone = val;
    }

    public void setAttributeModifier(Holder<Attribute> attribute, ResourceLocation modifierLoc, BiFunction<DTNWolf, ResourceLocation, AttributeModifier> modifierGenerator) {
        AttributeModifier newModifier;
        AttributeInstance attributeInst = this.getAttribute(attribute);
        AttributeModifier currentModifier = attributeInst.getModifier(modifierLoc);
        if (currentModifier != null) {
            attributeInst.removeModifier(modifierLoc);
        }
        if ((newModifier = modifierGenerator.apply(this, modifierLoc)) != null) {
            attributeInst.addTransientModifier(newModifier);
        }
    }

    public void removeAttributeModifier(Holder<Attribute> attribute, ResourceLocation modifierLoc) {
        AttributeInstance attrib = this.getAttribute(attribute);
        if (attrib == null) {
            return;
        }
        attrib.removeModifier(modifierLoc);
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean removeWhenFarAway(double distance) {
        return false;
    }

    public void checkDespawn() {
        this.noActionTime = 0;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficulty, EntitySpawnReason spawnType, @Nullable SpawnGroupData spawnGroup) {
        WolfPackData wolf_group;
        WolfPackData wolf_spawn_group = null;
        wolf_spawn_group = spawnGroup instanceof WolfPackData ? (wolf_group = (WolfPackData)spawnGroup) : this.initializeGroupData(levelAccessor, (Holder<Biome>)((Holder)DTNWolfStaticSpawnManager.get().currentSpawnBiome().orElse(null)));
        WolfVariant variant = wolf_spawn_group == null ? WolfVariantUtil.getDefaultForSpawn(this, levelAccessor) : wolf_spawn_group.getWolfVariant(this.getRandom());
        this.setVariant(variant);
        return super.finalizeSpawn(levelAccessor, difficulty, spawnType, (SpawnGroupData)wolf_spawn_group);
    }

    public WolfPackData initializeGroupData(ServerLevelAccessor levelAccessor, @Nullable Holder<Biome> biome) {
        List<WolfVariant> possible_variant;
        boolean underground_check;
        boolean bl = underground_check = this.getY() <= -12.0;
        if (biome == null) {
            biome = levelAccessor.getBiome(this.blockPosition());
        }
        if ((possible_variant = WolfVariantUtil.getPossibleSpawnVariants(this.getRandom(), levelAccessor.registryAccess(), (Holder<Biome>)biome, filter_config -> {
            if (underground_check) {
                return filter_config.placementType() == WolfSpawnPlacementType.UNDERGROUND;
            }
            return true;
        })).isEmpty()) {
            return null;
        }
        return new WolfPackData(possible_variant);
    }

    public WolfPackData initializeGroupData(ServerLevelAccessor levelAccessor, WolfBiomeConfig config) {
        Set<WolfVariant> variants = config.variants();
        if (variants.isEmpty()) {
            variants = Set.of(WolfVariantUtil.getDefault());
        }
        return new WolfPackData(new ArrayList<WolfVariant>(variants));
    }

    public int getMaxSpawnClusterSize() {
        return 8;
    }

    public static boolean checkWolfSpawnableBlockDefault(LevelAccessor level, BlockPos pos, BlockState state_below) {
        return state_below.is(BlockTags.WOLVES_SPAWNABLE_ON);
    }

    public static boolean checkWolfSpawnableLight(LevelAccessor level, BlockPos pos) {
        return DTNWolf.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public boolean checkSpawnRules(LevelAccessor level, EntitySpawnReason spawn_type) {
        return true;
    }

    public boolean checkSpawnObstruction(LevelReader levelReader) {
        return levelReader.isUnobstructed((Entity)this);
    }

    public boolean DTNWolfCheckAdditionalSpawnObstruction(LevelReader levelReader, WolfBiomeConfig config) {
        boolean water_obstruction_check = config.placementType() == WolfSpawnPlacementType.WATER || !levelReader.containsAnyLiquid(this.getBoundingBox());
        return water_obstruction_check;
    }

    public static class WolfPackData
    extends AgeableMob.AgeableMobGroupData {
        public final List<WolfVariant> variants;

        private WolfPackData(List<WolfVariant> variants) {
            super(false);
            this.variants = variants;
        }

        public WolfVariant getWolfVariant(RandomSource random) {
            if (this.variants.size() == 1) {
                return this.variants.get(0);
            }
            int r_index = random.nextInt(this.variants.size());
            return this.variants.get(r_index);
        }
    }
}

