/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.entity;

import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.entity.ai.nav.DTNWolfSwimMoveControl;
import dtnpaletteofpaws.common.entity.ai.nav.DTNWolfWaterBoundNavigation;
import dtnpaletteofpaws.common.util.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.neoforged.neoforge.common.NeoForgeMod;

public class DTNWolfSwimmingManager {
    private final DTNWolf dog;
    private static final ResourceLocation SWIM_BOOST_ID = Util.getResource("swim_boost");
    private DTNWolfSwimMoveControl moveControl_water;
    private DTNWolfWaterBoundNavigation navigator_water;
    private boolean swimming = false;
    private static final float baseSwimSpeedModifierAdd = 2.0f;
    private float swimSpeedModifierAdd = 2.0f;

    public DTNWolfSwimmingManager(DTNWolf dog) {
        this.dog = dog;
        this.moveControl_water = new DTNWolfSwimMoveControl(dog);
        this.navigator_water = new DTNWolfWaterBoundNavigation(dog, dog.level());
    }

    public void tickServer() {
        if (this.swimming) {
            this.updateSwimming(this.dog);
        } else {
            this.updateNotSwimming(this.dog);
        }
    }

    private void updateSwimming(DTNWolf dog) {
        if (!dog.isInWater() && dog.onGround()) {
            this.swimming = false;
            this.stopSwimming(dog);
        }
    }

    private void updateNotSwimming(DTNWolf dog) {
        if (dog.isInWater() && this.readyToBeginSwimming(dog) && !dog.isDogSwimming()) {
            this.swimming = true;
            this.startSwimming(dog);
        }
    }

    private boolean readyToBeginSwimming(DTNWolf dog) {
        return dog.getAirSupply() == dog.getMaxAirSupply();
    }

    private void applySwimAttributes(DTNWolf dog) {
        dog.setAttributeModifier((Holder<Attribute>)NeoForgeMod.SWIM_SPEED, SWIM_BOOST_ID, (dd, u) -> new AttributeModifier(u, 7.0, AttributeModifier.Operation.ADD_VALUE));
    }

    private void removeSwimAttributes(DTNWolf dog) {
        dog.removeAttributeModifier((Holder<Attribute>)NeoForgeMod.SWIM_SPEED, SWIM_BOOST_ID);
    }

    private void startSwimming(DTNWolf dog) {
        dog.setJumping(false);
        dog.setNavigation((PathNavigation)this.navigator_water);
        dog.setMoveControl(this.moveControl_water);
        if (dog.isInSittingPose()) {
            dog.setInSittingPose(false);
        }
        this.applySwimAttributes(dog);
        dog.setDogSwimming(true);
    }

    private void stopSwimming(DTNWolf dog) {
        dog.resetMoveControl();
        dog.resetNavigation();
        this.removeSwimAttributes(dog);
        dog.setDogSwimming(false);
    }
}

