/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.entity.ai;

import dtnpaletteofpaws.common.entity.DTNWolf;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class DTNWolfFollwOwnerGoal
extends Goal {
    private final DTNWolf dog;
    private final Level world;
    private final double followSpeed;
    private final float stopDist;
    private final float startDist;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private int tickTillSearchForTp = 0;
    private float oldWaterCost;

    public DTNWolfFollwOwnerGoal(DTNWolf dogIn, double speedIn, float minDistIn, float maxDistIn) {
        this.dog = dogIn;
        this.world = dogIn.level();
        this.followSpeed = speedIn;
        this.startDist = minDistIn;
        this.stopDist = maxDistIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity owner = this.dog.getOwner();
        if (owner == null) {
            return false;
        }
        if (owner.isSpectator()) {
            return false;
        }
        if (this.dog.isInSittingPose()) {
            return false;
        }
        if (this.dog.distanceToSqr((Entity)owner) < (double)this.getMinStartDistanceSq()) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.dog.getNavigation().isDone()) {
            return false;
        }
        if (this.dog.isInSittingPose()) {
            return false;
        }
        return this.dog.distanceToSqr((Entity)this.owner) > (double)(this.stopDist * this.stopDist);
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.dog.setDogFollowingSomeone(true);
    }

    public void stop() {
        this.owner = null;
        this.dog.getNavigation().stop();
        this.dog.setDogFollowingSomeone(false);
    }

    public void tick() {
        this.dog.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.dog.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            DTNWolfFollwOwnerGoal.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.followSpeed, 144.0, false, false, 400.0, this.dog.getMaxFallDistance());
        }
    }

    public float getMinStartDistanceSq() {
        return this.startDist * this.startDist;
    }

    public static void moveToOwnerOrTeleportIfFarAway(DTNWolf dog, LivingEntity owner, double speedModifier, double distanceToTeleportSqr, boolean continueToMoveWhenTryTp, boolean forceTeleport, double distanceToForceTeleportSqr, int dY) {
        if (owner == null) {
            return;
        }
        double distance = dog.distanceToSqr((Entity)owner);
        if (!dog.isLeashed() && !dog.isPassenger()) {
            if (distance >= distanceToTeleportSqr) {
                DTNWolfFollwOwnerGoal.guessAndTryToTeleportToOwner(dog, owner, 4);
            } else {
                dog.getNavigation().moveTo((Entity)owner, speedModifier);
            }
        }
    }

    public static boolean guessAndTryToTeleportToOwner(DTNWolf dog, LivingEntity owner, int radius) {
        BlockPos owner_b0 = owner.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int randZ;
            int randY;
            int randX = owner_b0.getX() + DTNWolfFollwOwnerGoal.getRandomNumber(dog, -radius, radius);
            BlockPos b0 = new BlockPos(randX, randY = owner_b0.getY() + DTNWolfFollwOwnerGoal.getRandomNumber(dog, -1, 1), randZ = owner_b0.getZ() + DTNWolfFollwOwnerGoal.getRandomNumber(dog, -radius, radius));
            if (!DTNWolfFollwOwnerGoal.wantToTeleportToThePosition(dog, owner, b0)) continue;
            DTNWolfFollwOwnerGoal.teleportInternal(dog, b0);
            return true;
        }
        return false;
    }

    private static void teleportInternal(DTNWolf dog, BlockPos target) {
        dog.fallDistance = 0.0;
        dog.snapTo((float)target.getX() + 0.5f, target.getY(), (float)target.getZ() + 0.5f, dog.getYRot(), dog.getXRot());
        dog.getNavigation().stop();
        dog.breakMoveControl();
    }

    public static boolean wantToTeleportToThePosition(DTNWolf dog, LivingEntity owner, BlockPos pos) {
        BlockPos owner_b0 = owner.blockPosition();
        boolean flag = (Mth.abs((int)(owner_b0.getX() - pos.getX())) >= 2 || Mth.abs((int)(owner_b0.getZ() - pos.getZ())) >= 2) && DTNWolfFollwOwnerGoal.isTeleportSafeBlock(dog, pos, owner);
        return flag;
    }

    public static boolean isTeleportSafeBlock(DTNWolf dog, BlockPos pos, @Nullable LivingEntity owner) {
        PathType pathnodetype = WalkNodeEvaluator.getPathTypeStatic((Mob)dog, (BlockPos)pos.mutable());
        boolean alterationWalkable = false;
        PathType infer_type = dog.inferType(pathnodetype);
        if (infer_type == PathType.WALKABLE) {
            alterationWalkable = true;
        }
        if (dog.fireImmune() && pathnodetype == PathType.OPEN && dog.level().getFluidState(pos.below()).is(FluidTags.LAVA)) {
            alterationWalkable = true;
        }
        if (pathnodetype != PathType.WALKABLE && !alterationWalkable) {
            return false;
        }
        BlockPos blockpos = pos.subtract((Vec3i)dog.blockPosition());
        return dog.level().noCollision((Entity)dog, dog.getBoundingBox().move(blockpos));
    }

    public static int getRandomNumber(DTNWolf entityIn, int minIn, int maxIn) {
        return entityIn.getRandom().nextInt(maxIn - minIn + 1) + minIn;
    }
}

