/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.entity.ai;

import dtnpaletteofpaws.common.entity.DTNWolf;
import javax.annotation.Nullable;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class DTNWolfRandomStrollGoal
extends RandomStrollGoal {
    private final DTNWolf wolf;

    public DTNWolfRandomStrollGoal(DTNWolf wolf) {
        super((PathfinderMob)wolf, 1.0);
        this.wolf = wolf;
    }

    @Nullable
    protected Vec3 getPosition() {
        if (this.wolf.getVariant().swimUnderwater() && this.wolf.isInWater()) {
            if (this.wolf.isTame()) {
                return BehaviorUtils.getRandomSwimmablePos((PathfinderMob)this.wolf, (int)10, (int)7);
            }
            return BehaviorUtils.getRandomSwimmablePos((PathfinderMob)this.wolf, (int)10, (int)3);
        }
        return this.getWaterAvoidingPos();
    }

    private Vec3 getWaterAvoidingPos() {
        if (this.wolf.isInWater()) {
            Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)7);
            return vec3 == null ? super.getPosition() : vec3;
        }
        return this.wolf.getRandom().nextFloat() >= 0.001f ? LandRandomPos.getPos((PathfinderMob)this.wolf, (int)10, (int)7) : super.getPosition();
    }
}

