/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.entity.ai.nav;

import dtnpaletteofpaws.common.entity.DTNWolf;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class DTNWolfPathNavigation
extends GroundPathNavigation {
    private DTNWolf dog;

    public DTNWolfPathNavigation(DTNWolf dog, Level level) {
        super((Mob)dog, level);
        this.dog = dog;
    }

    public void tick() {
        super.tick();
        if (this.isDone() && this.path != null && this.path.isDone()) {
            this.stop();
        }
    }

    protected void followThePath() {
        boolean isCloseEnough;
        if (this.invalidateIfNextNodeIsTooHigh()) {
            return;
        }
        Vec3 currentPos = this.getTempMobPos();
        this.maxDistanceToWaypoint = 0.45f;
        BlockPos nextPos = this.path.getNextNodePos();
        double dx = Math.abs(this.mob.getX() - ((double)nextPos.getX() + 0.5));
        double dy = Math.abs(this.mob.getY() - (double)nextPos.getY());
        double dz = Math.abs(this.mob.getZ() - ((double)nextPos.getZ() + 0.5));
        boolean bl = isCloseEnough = dx <= (double)this.maxDistanceToWaypoint && dy < 1.0 && dz <= (double)this.maxDistanceToWaypoint;
        if (isCloseEnough) {
            this.path.advance();
        }
        this.doStuckDetection(currentPos);
    }

    protected boolean invalidateIfNextNodeIsTooHigh() {
        boolean is_first_fence_node;
        Path path = this.path;
        if (path == null) {
            return true;
        }
        BlockPos nextPos = path.getNextNodePos();
        double dy = this.dog.getY() - (double)nextPos.getY();
        if (dy < -1.75) {
            this.stop();
            return true;
        }
        Node nextNode = path.getNextNode();
        boolean bl = is_first_fence_node = nextNode.type == PathType.FENCE && path.getNextNodeIndex() == 0;
        if (!is_first_fence_node && this.dog.getPathfindingMalus(nextNode.type) < 0.0f) {
            this.stop();
            return true;
        }
        return false;
    }

    protected boolean canUpdatePath() {
        return super.canUpdatePath();
    }

    protected boolean hasValidPathType(PathType type) {
        if (this.dog.fireImmune()) {
            if (type == PathType.LAVA) {
                return true;
            }
            if (type == PathType.DAMAGE_FIRE) {
                return true;
            }
            if (type == PathType.DANGER_FIRE) {
                return true;
            }
        }
        return super.hasValidPathType(type);
    }

    public boolean isStableDestination(BlockPos pos) {
        if (this.dog.fireImmune() && this.level.getFluidState(pos).is(FluidTags.LAVA)) {
            return true;
        }
        return super.isStableDestination(pos);
    }

    protected PathFinder createPathFinder(int p_26453_) {
        this.nodeEvaluator = new WalkNodeEvaluator(){

            protected double getFloorLevel(BlockPos pos) {
                if (DTNWolfPathNavigation.this.dog.fireImmune() && DTNWolfPathNavigation.this.dog.level().getFluidState(pos).is(FluidTags.LAVA)) {
                    return pos.getY();
                }
                return super.getFloorLevel(pos);
            }
        };
        this.nodeEvaluator.setCanPassDoors(true);
        return new PathFinder(this.nodeEvaluator, p_26453_);
    }

    @Nullable
    protected Path createPath(@Nonnull Set<BlockPos> pos, int p_148224_, boolean p_148225_, int p_148226_, float p_148227_) {
        this.dogThrowIfLockAndDebug();
        return super.createPath(pos, p_148224_, p_148225_, p_148226_, p_148227_);
    }

    private void dogThrowIfLockAndDebug() {
    }
}

