/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.entity.ai.nav;

import dtnpaletteofpaws.common.entity.DTNWolf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DTNWolfSwimMoveControl
extends MoveControl {
    private DTNWolf dog;

    public DTNWolfSwimMoveControl(DTNWolf dog) {
        super((Mob)dog);
        this.dog = dog;
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO && !this.dog.getNavigation().isDone() && this.dog.isInWater()) {
            double dz;
            double dy;
            double dx = this.wantedX - this.dog.getX();
            double l_sqr = dx * dx + (dy = this.wantedY - this.dog.getY()) * dy + (dz = this.wantedZ - this.dog.getZ()) * dz;
            if (l_sqr < 2.500000277905201E-7) {
                this.dog.setZza(0.0f);
                return;
            }
            double l_xz = Math.sqrt(dx * dx + dz * dz);
            float speed = (float)(this.speedModifier * this.dog.getAttributeValue(Attributes.MOVEMENT_SPEED));
            this.dog.setSpeed(speed);
            float dy_abs = Mth.abs((float)((float)dy));
            if ((double)dy_abs / l_xz >= 6.0) {
                this.dog.yya = (float)Mth.sign((double)dy) * speed;
                this.dog.zza = 0.0f;
                return;
            }
            float wantedYRot = (float)(Mth.atan2((double)dz, (double)dx) * 57.2957763671875) - 90.0f;
            this.dog.setYRot(this.rotlerp(this.dog.getYRot(), wantedYRot, this.dog.getMaxHeadYRot()));
            this.dog.yBodyRot = this.dog.getYRot();
            this.dog.yHeadRot = this.dog.getYRot();
            if (Math.abs(dy) > (double)1.0E-5f || Math.abs(l_xz) > (double)1.0E-5f) {
                float wantedXRot = -((float)(Mth.atan2((double)dy, (double)l_xz) * 57.2957763671875));
                float maxTurnX = this.dog.getMaxHeadXRot();
                wantedXRot = Mth.clamp((float)Mth.wrapDegrees((float)wantedXRot), (float)(-maxTurnX), (float)maxTurnX);
                float approachingXRot = this.rotlerp(this.dog.getXRot(), wantedXRot, 5.0f);
                this.dog.setXRot(approachingXRot);
            }
            float f6 = Mth.cos((float)(this.dog.getXRot() * ((float)Math.PI / 180)));
            float f4 = Mth.sin((float)(this.dog.getXRot() * ((float)Math.PI / 180)));
            this.dog.zza = f6 * speed;
            this.dog.yya = -f4 * speed;
            this.mayCheckAndLeapUpOrDownObstacle(speed);
        } else {
            this.dog.setSpeed(0.0f);
            this.dog.setXxa(0.0f);
            this.dog.setYya(0.0f);
            this.dog.setZza(0.0f);
        }
    }

    private void mayCheckAndLeapUpOrDownObstacle(float speed) {
        double min_lxz;
        double dz;
        if (!this.dog.isInWater()) {
            return;
        }
        double dy = this.getWantedY() - this.dog.getY();
        if (Math.abs(dy) <= 0.1) {
            return;
        }
        double dx = this.getWantedX() - this.dog.getX();
        double l_xz_sqr = dx * dx + (dz = this.getWantedZ() - this.dog.getZ()) * dz;
        if (l_xz_sqr < (min_lxz = (double)(this.dog.getBbWidth() / 2.0f) + 0.5 - 0.1) * min_lxz) {
            return;
        }
        boolean is_up = dy > 0.0;
        Vec3 check_pos_offset = new Vec3(dx, 0.0, dz).normalize().scale((double)(this.dog.getBbWidth() / 2.0f) + 0.2).add(0.0, is_up ? 0.0 : (double)this.dog.getBbHeight(), 0.0);
        BlockPos check_pos = BlockPos.containing((Position)this.dog.position().add(check_pos_offset));
        BlockState state = this.dog.level().getBlockState(check_pos);
        if (!state.getCollisionShape((BlockGetter)this.dog.level(), check_pos).isEmpty()) {
            speed = Mth.clamp((float)speed, (float)0.0f, (float)0.39f);
            this.dog.yya = is_up ? speed : -speed;
        }
    }
}

