/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.entity.ai.nav;

import dtnpaletteofpaws.common.entity.DTNWolf;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.SwimNodeEvaluator;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class DTNWolfSwimNodeEvaluator
extends SwimNodeEvaluator {
    private boolean checkLand = false;
    private DTNWolf dog;

    public DTNWolfSwimNodeEvaluator(DTNWolf dog) {
        super(false);
        this.dog = dog;
    }

    public int getNeighbors(Node[] buffer, Node currentNode) {
        this.checkLand = currentNode.type == PathType.WATER;
        int ret = super.getNeighbors(buffer, currentNode);
        this.checkLand = false;
        return ret;
    }

    @Nullable
    protected Node findAcceptedNode(int p_263032_, int p_263066_, int p_263105_) {
        Node node = null;
        PathType PathType2 = this.getCachedBlockType(p_263032_, p_263066_, p_263105_);
        if (PathType2 == PathType.WATER) {
            float f = this.mob.getPathfindingMalus(PathType2);
            if (f >= 0.0f) {
                node = this.getNode(p_263032_, p_263066_, p_263105_);
                node.type = PathType2;
                node.costMalus = Math.max(node.costMalus, f);
                if (this.mob.level().getFluidState(new BlockPos(p_263032_, p_263066_, p_263105_)).isEmpty()) {
                    node.costMalus += 8.0f;
                }
            }
        } else if (this.checkLand) {
            float f;
            if (PathType2 == PathType.WALKABLE && (f = this.mob.getPathfindingMalus(PathType2)) >= 0.0f) {
                node = this.getNode(p_263032_, p_263066_ + 1, p_263105_);
                node.type = PathType2;
                node.costMalus = Math.max(node.costMalus, f);
            }
        }
        return node;
    }

    public Node getStart() {
        Node ret = super.getStart();
        if (this.dog.isInWater()) {
            ret.type = PathType.WATER;
        }
        return ret;
    }

    public PathType getPathTypeOfMob(PathfindingContext context, int x, int y, int z, Mob dog) {
        BlockPos.MutableBlockPos checking_pos = new BlockPos.MutableBlockPos();
        for (int i = y; i < y + this.entityHeight; ++i) {
            boolean checkedWalkable;
            checking_pos.set(x, i, z);
            BlockState state = dog.level().getBlockState((BlockPos)checking_pos);
            FluidState fluid = state.getFluidState();
            boolean bl = checkedWalkable = this.checkLand && i == y && this.checkLand((BlockPos)checking_pos, state, (BlockGetter)dog.level());
            if (checkedWalkable) {
                return PathType.WALKABLE;
            }
            if (fluid.is(FluidTags.WATER)) continue;
            return PathType.BLOCKED;
        }
        return PathType.WATER;
    }

    private boolean checkLand(BlockPos currentPos, BlockState currenState, BlockGetter level) {
        if (currenState.isPathfindable(PathComputationType.LAND)) {
            return false;
        }
        PathType walkType = WalkNodeEvaluator.getPathTypeStatic((Mob)this.dog, (BlockPos)currentPos.above().mutable());
        return walkType == PathType.WATER_BORDER || walkType == PathType.WALKABLE;
    }
}

