/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.event;

import dtnpaletteofpaws.DTNEntityTypes;
import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.util.Util;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class WolfCharmItem
extends Item {
    public WolfCharmItem() {
        super(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Util.getResource("wolf_charm"))));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel sLevel = (ServerLevel)level;
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockPos clicked_pos = context.getClickedPos();
        Direction clicked_face = context.getClickedFace();
        BlockState state = level.getBlockState(clicked_pos);
        if (player == null) {
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos spawn_pos = state.getCollisionShape((BlockGetter)level, clicked_pos).isEmpty() ? clicked_pos : clicked_pos.relative(clicked_face);
        boolean upward_collision = !Objects.equals(spawn_pos, clicked_pos) && clicked_face == Direction.UP;
        DTNWolf entity = (DTNWolf)DTNEntityTypes.DTNWOLF.get().spawn(sLevel, stack, (LivingEntity)context.getPlayer(), spawn_pos, EntitySpawnReason.SPAWN_ITEM_USE, upward_collision, false);
        if (entity == null) {
            return InteractionResult.SUCCESS;
        }
        stack.shrink(1);
        if (player instanceof ServerPlayer) {
            ServerPlayer sP = (ServerPlayer)player;
            sP.getCooldowns().addCooldown(new ItemStack((ItemLike)this), 30);
        }
        return InteractionResult.SUCCESS;
    }
}

