/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.network;

import java.util.function.Supplier;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class PacketDistributor<T> {
    public static PacketDistributor<Void> SERVER = new PacketDistributor<Void>(new ToServerPacketTarget());
    public static PacketDistributor<ServerPlayer> PLAYER = new PacketDistributor<ServerPlayer>(new ToClientSinglePacketTarget());
    public static PacketDistributor<Entity> TRACKING_ENTITY = new PacketDistributor<Entity>(new ToClientTrackingEntityTarget());
    public static PacketDistributor<Entity> TRACKING_ENTITY_AND_SELF = new PacketDistributor<Entity>(new ToClientTrackingEntityAndSelfTarget());
    private PacketTarget<T> defaultTarget;

    PacketDistributor(PacketTarget<T> target) {
        this.defaultTarget = target;
    }

    public PacketTarget<T> noArg() {
        return this.defaultTarget.acceptArg(null);
    }

    public PacketTarget<T> with(Supplier<T> arg) {
        return this.defaultTarget.acceptArg(arg.get());
    }

    public static abstract class PacketTarget<T> {
        protected Type type;

        public abstract void sendPacket(CustomPacketPayload var1);

        public Type getType() {
            return this.type;
        }

        public PacketTarget<T> acceptArg(T arg) {
            return this;
        }

        public static enum Type {
            TO_CLIENT,
            TO_SERVER;

        }
    }

    public static class ToServerPacketTarget
    extends PacketTarget<Void> {
        public ToServerPacketTarget() {
            this.type = PacketTarget.Type.TO_SERVER;
        }

        @Override
        public void sendPacket(CustomPacketPayload payload) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        @Override
        public PacketTarget<Void> acceptArg(Void arg) {
            return this;
        }
    }

    public static class ToClientSinglePacketTarget
    extends PacketTarget<ServerPlayer> {
        private ServerPlayer arg;

        public ToClientSinglePacketTarget() {
            this.type = PacketTarget.Type.TO_CLIENT;
        }

        @Override
        public void sendPacket(CustomPacketPayload payload) {
            if (this.arg == null) {
                return;
            }
            net.neoforged.neoforge.network.PacketDistributor.sendToPlayer((ServerPlayer)this.arg, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        @Override
        public PacketTarget<ServerPlayer> acceptArg(ServerPlayer arg) {
            ToClientSinglePacketTarget ret = new ToClientSinglePacketTarget();
            ret.arg = arg;
            return ret;
        }
    }

    public static class ToClientTrackingEntityTarget
    extends PacketTarget<Entity> {
        private Entity arg;

        public ToClientTrackingEntityTarget() {
            this.type = PacketTarget.Type.TO_CLIENT;
        }

        @Override
        public void sendPacket(CustomPacketPayload payload) {
            if (this.arg == null) {
                return;
            }
            net.neoforged.neoforge.network.PacketDistributor.sendToPlayersTrackingEntity((Entity)this.arg, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        @Override
        public PacketTarget<Entity> acceptArg(Entity arg) {
            ToClientTrackingEntityTarget ret = new ToClientTrackingEntityTarget();
            ret.arg = arg;
            return ret;
        }
    }

    public static class ToClientTrackingEntityAndSelfTarget
    extends PacketTarget<Entity> {
        private Entity arg;

        public ToClientTrackingEntityAndSelfTarget() {
            this.type = PacketTarget.Type.TO_CLIENT;
        }

        @Override
        public void sendPacket(CustomPacketPayload payload) {
            if (this.arg == null) {
                return;
            }
            net.neoforged.neoforge.network.PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this.arg, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        @Override
        public PacketTarget<Entity> acceptArg(Entity arg) {
            ToClientTrackingEntityAndSelfTarget ret = new ToClientTrackingEntityAndSelfTarget();
            ret.arg = arg;
            return ret;
        }
    }
}

