/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.network;

import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.network.DTNNetworkHandler;
import dtnpaletteofpaws.common.network.IPacket;
import dtnpaletteofpaws.common.network.PacketDistributor;
import dtnpaletteofpaws.common.network.PacketHandler;
import dtnpaletteofpaws.common.network.data.WolfShakingData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;

public class WolfShakingPacket
implements IPacket<WolfShakingData> {
    @Override
    public void encode(WolfShakingData data, FriendlyByteBuf buf) {
        buf.writeInt(data.dogId);
        buf.writeByte((byte)data.state.getId());
    }

    @Override
    public WolfShakingData decode(FriendlyByteBuf buf) {
        int dogId = buf.readInt();
        WolfShakingData.State state = WolfShakingData.State.fromId(buf.readByte());
        return new WolfShakingData(dogId, state);
    }

    @Override
    public void handle(WolfShakingData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                Minecraft mc = Minecraft.getInstance();
                Entity e = mc.level.getEntity(data.dogId);
                if (e instanceof DTNWolf) {
                    DTNWolf wolf = (DTNWolf)e;
                    wolf.handleDogShakingUpdate(data.state);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void sendDogShakingPacket(DTNWolf dog, WolfShakingData.State state) {
        PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> dog), new WolfShakingData(dog.getId(), state));
    }
}

