/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.spawn;

import dtnpaletteofpaws.DTNEntityTypes;
import dtnpaletteofpaws.common.backward_imitate.MobSpawnSettings_1_21_5;
import dtnpaletteofpaws.common.util.Util;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weighted;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class DTNWolfSpawnModifiers {
    public static void bootstrap(BootstrapContext<BiomeModifier> ctx) {
    }

    private static void registerWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerCherryWolfModifier(ctx);
        DTNWolfSpawnModifiers.registerLemonyLimeWolfModifier(ctx);
        DTNWolfSpawnModifiers.registerHimalayanSaltWolfModifier(ctx);
        DTNWolfSpawnModifiers.registerBambooWolfModifier(ctx);
        DTNWolfSpawnModifiers.registerCrimsonWolfModifier(ctx);
        DTNWolfSpawnModifiers.registerWarpedWolfModifier(ctx);
        DTNWolfSpawnModifiers.registerMoltenWolfModifier(ctx);
        DTNWolfSpawnModifiers.registerBirchWolfModifier(ctx);
        DTNWolfSpawnModifiers.registerPistachioWolfModifier(ctx);
        DTNWolfSpawnModifiers.registerGuacamoleWolfModifier(ctx);
        DTNWolfSpawnModifiers.registerYuzuWolfModifier(ctx);
        DTNWolfSpawnModifiers.registerCaffeinePackModifier(ctx);
        DTNWolfSpawnModifiers.registerWitheredSoulWolfModifier(ctx);
        DTNWolfSpawnModifiers.registerMushroomPackModifier(ctx);
        DTNWolfSpawnModifiers.registerDesertSuiteModifier(ctx);
        DTNWolfSpawnModifiers.registerBonitoFlakesWolfModifier(ctx);
        DTNWolfSpawnModifiers.registerGelatoSuiteModifier(ctx);
        DTNWolfSpawnModifiers.registerWalnutWolfModifier(ctx);
        DTNWolfSpawnModifiers.registerCoralWolfSpawnModifier(ctx);
        DTNWolfSpawnModifiers.registerNetherWasteSuite(ctx);
        DTNWolfSpawnModifiers.registerIcySpawnModifier(ctx);
        DTNWolfSpawnModifiers.registerSavannaSpawnModifier(ctx);
    }

    private static void registerCherryWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_cherry", (ResourceKey<Biome>)Biomes.CHERRY_GROVE, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 1));
    }

    private static void registerLemonyLimeWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_lemony_lime", (ResourceKey<Biome>)Biomes.BEACH, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 1));
    }

    private static void registerHimalayanSaltWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_himalayan_salt", (ResourceKey<Biome>)Biomes.JAGGED_PEAKS, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 1));
    }

    private static void registerBambooWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_bamboo", (ResourceKey<Biome>)Biomes.JUNGLE, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 1));
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_bamboo_dedicated", (ResourceKey<Biome>)Biomes.BAMBOO_JUNGLE, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 60, 1, 3));
    }

    private static void registerCrimsonWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_crimson", (ResourceKey<Biome>)Biomes.CRIMSON_FOREST, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 20, 1, 1));
    }

    private static void registerWarpedWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_warped", (ResourceKey<Biome>)Biomes.WARPED_FOREST, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 20, 1, 1));
    }

    private static void registerMoltenWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_molten", (ResourceKey<Biome>)Biomes.BASALT_DELTAS, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 20, 1, 1));
    }

    private static void registerBirchWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_birch", (ResourceKey<Biome>)Biomes.BIRCH_FOREST, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 1));
    }

    private static void registerPistachioWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_pistachio", (ResourceKey<Biome>)Biomes.MANGROVE_SWAMP, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 1));
    }

    private static void registerGuacamoleWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_guacamole", (ResourceKey<Biome>)Biomes.MEADOW, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 1));
    }

    private static void registerYuzuWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_yuzu", (ResourceKey<Biome>)Biomes.SNOWY_BEACH, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 1));
    }

    private static void registerCaffeinePackModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "dark_forest_suite", (ResourceKey<Biome>)Biomes.DARK_FOREST, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 4, 2, 4));
    }

    private static void registerWitheredSoulWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_withered_soul", (ResourceKey<Biome>)Biomes.SOUL_SAND_VALLEY, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 1));
    }

    private static void registerMushroomPackModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "mushroom_pack", (ResourceKey<Biome>)Biomes.MUSHROOM_FIELDS, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 5, 2, 4));
    }

    private static void registerDesertSuiteModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "desert_suite", (ResourceKey<Biome>)Biomes.DESERT, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 1));
    }

    private static void registerBonitoFlakesWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_bonito_flakes", (ResourceKey<Biome>)Biomes.WOODED_BADLANDS, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 1));
    }

    private static void registerGelatoSuiteModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "gelato_suite", (ResourceKey<Biome>)Biomes.SNOWY_PLAINS, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 3));
    }

    private static void registerWalnutWolfModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_walnut", (ResourceKey<Biome>)Biomes.OLD_GROWTH_SPRUCE_TAIGA, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 3));
    }

    private static void registerKombuWolfWaterModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_kombu_waterspawn", (ResourceKey<Biome>)Biomes.LUKEWARM_OCEAN, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 1));
    }

    private static void registerCoralWolfSpawnModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_coral_pack_spawn", (ResourceKey<Biome>)Biomes.WARM_OCEAN, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 3));
    }

    private static void registerNetherWasteSuite(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "nether_waste_suite", (ResourceKey<Biome>)Biomes.NETHER_WASTES, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 1));
    }

    private static void registerIcySpawnModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_icy_spawn", (ResourceKey<Biome>)Biomes.ICE_SPIKES, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 1, 1, 4));
    }

    private static void registerSavannaSpawnModifier(BootstrapContext<BiomeModifier> ctx) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, "wolf_savanna_spawn", (ResourceKey<Biome>)Biomes.SAVANNA, new MobSpawnSettings_1_21_5.SpawnerData(DTNEntityTypes.DTNWOLF.get(), 8, 1, 4));
    }

    private static void registerSingleSpawnModifier(BootstrapContext<BiomeModifier> ctx, String name, ResourceKey<Biome> biome, MobSpawnSettings_1_21_5.SpawnerData spawner_data) {
        DTNWolfSpawnModifiers.registerSingleSpawnModifier(ctx, name, List.of(biome), spawner_data);
    }

    private static void registerSingleSpawnModifier(BootstrapContext<BiomeModifier> ctx, String name, List<ResourceKey<Biome>> biomes, MobSpawnSettings_1_21_5.SpawnerData spawner_data) {
        ResourceKey spawn_id = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Util.getResource(name));
        HolderGetter biome_reg = ctx.lookup(Registries.BIOME);
        List biome_holders = biomes.stream().map(x -> biome_reg.get(x)).filter(x -> x.isPresent()).map(x -> (Holder.Reference)x.get()).collect(Collectors.toList());
        if (biome_holders.isEmpty()) {
            return;
        }
        HolderSet.Direct spawn_biomes = HolderSet.direct(biome_holders);
        BiomeModifiers.AddSpawnsBiomeModifier spawn_modifier = BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)spawn_biomes, (Weighted)new Weighted((Object)new MobSpawnSettings.SpawnerData(spawner_data.type, spawner_data.minCount, spawner_data.maxCount), spawner_data.weight));
        ctx.register(spawn_id, (Object)spawn_modifier);
    }
}

