/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.spawn;

import dtnpaletteofpaws.DTNEntityTypes;
import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.spawn.WolfSpawnPlacementType;
import dtnpaletteofpaws.common.variant.biome_config.WolfBiomeConfig;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class DTNWolfSpawnPlacements {
    public static void onRegisterSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register(DTNEntityTypes.DTNWOLF.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DTNWolfSpawnPlacements::DTNWolfSpawnableOnDefault, RegisterSpawnPlacementsEvent.Operation.OR);
    }

    public static boolean DTNWolfSpawnableOnDefault(EntityType<DTNWolf> type, ServerLevelAccessor level, EntitySpawnReason spawn_type, BlockPos pos, RandomSource random) {
        BlockState state_below = level.getBlockState(pos.below());
        return DTNWolf.checkWolfSpawnableBlockDefault((LevelAccessor)level, pos, state_below) && DTNWolf.checkWolfSpawnableLight((LevelAccessor)level, pos);
    }

    public static boolean DTNWolfSpawnableOn(WolfBiomeConfig config, LevelAccessor level, EntitySpawnReason spawn_type, BlockPos pos, RandomSource random) {
        boolean light_condition;
        boolean block_is_spawnable = DTNWolfSpawnPlacements.checkWolfSpawnableBlock(level, pos, config);
        if (!block_is_spawnable) {
            return false;
        }
        boolean bl = light_condition = config.canSpawnInDark() || DTNWolf.checkWolfSpawnableLight(level, pos);
        return light_condition;
    }

    public static boolean checkWolfSpawnableBlock(LevelAccessor level, BlockPos pos, WolfBiomeConfig config) {
        BlockState state_below;
        Block block_below;
        Set<Block> blocks = config.blocks();
        return blocks.contains(block_below = (state_below = level.getBlockState(pos.below())).getBlock()) || DTNWolf.checkWolfSpawnableBlockDefault(level, pos, state_below);
    }

    public static boolean spawnPlacementTypeCheck(LevelReader world, BlockPos pos, WolfBiomeConfig config) {
        boolean spawn_in_lava;
        SpawnPlacementType placement = config.placementType() == WolfSpawnPlacementType.WATER ? SpawnPlacementTypes.IN_WATER : SpawnPlacementTypes.ON_GROUND;
        boolean bl = spawn_in_lava = DTNWolfSpawnPlacements.configHasLavaSpawn(config) && SpawnPlacementTypes.IN_LAVA.isSpawnPositionOk(world, pos.below(), DTNEntityTypes.DTNWOLF.get());
        if (spawn_in_lava) {
            return true;
        }
        return placement.isSpawnPositionOk(world, pos, DTNEntityTypes.DTNWOLF.get());
    }

    private static boolean configHasLavaSpawn(WolfBiomeConfig config) {
        return config.blocks().contains(Blocks.LAVA);
    }

    public static BlockPos getDTNWolfTopNonCollidingPos(WolfSpawnPlacementType placementType, LevelReader world, int x, int z) {
        BlockState below_state;
        boolean below_state_pathfindable;
        BlockPos check_pos_below;
        Heightmap.Types height_map_type = placementType == WolfSpawnPlacementType.WATER ? Heightmap.Types.OCEAN_FLOOR : Heightmap.Types.MOTION_BLOCKING_NO_LEAVES;
        int inital_height = world.getHeight(height_map_type, x, z);
        BlockPos check_pos = new BlockPos(x, inital_height, z);
        if (world.dimensionType().hasCeiling()) {
            while (!world.getBlockState(check_pos = check_pos.below()).isAir()) {
            }
            check_pos_below = check_pos.below();
            while (check_pos_below.getY() > world.getMinY() && world.getBlockState(check_pos_below).isAir()) {
                check_pos = check_pos_below;
                check_pos_below = check_pos.below();
            }
        }
        if ((below_state_pathfindable = (below_state = world.getBlockState(check_pos_below = check_pos.below())).isPathfindable(placementType == WolfSpawnPlacementType.WATER ? PathComputationType.WATER : PathComputationType.LAND)) && below_state.getFluidState().isEmpty()) {
            return check_pos_below;
        }
        return check_pos;
    }

    public static BlockPos getRandomUndergroundPos(RandomSource random, LevelReader world, int x, int z, Holder<Biome> biome) {
        boolean bound_check;
        int max_spawn_y = -12;
        int min_spawn_y = biome.is(BiomeTags.IS_MOUNTAIN) ? -53 : -47;
        boolean bl = bound_check = world.getMinY() < min_spawn_y && -12 < world.getMaxY();
        if (!bound_check) {
            return new BlockPos(x, world.getMinY(), z);
        }
        int start_at = random.nextIntBetweenInclusive(min_spawn_y, -12);
        BlockPos check_pos = new BlockPos(x, start_at, z);
        BlockState check_state = world.getBlockState(check_pos);
        while (!check_state.isAir() && check_pos.getY() >= min_spawn_y) {
            check_pos = check_pos.below();
            check_state = world.getBlockState(check_pos);
        }
        while (check_state.isAir() && check_pos.getY() >= min_spawn_y && (check_pos = check_pos.below()).getY() >= min_spawn_y) {
            check_state = world.getBlockState(check_pos);
        }
        if ((check_pos = check_pos.above()).getY() <= min_spawn_y) {
            return check_pos;
        }
        BlockPos check_pos_below = check_pos.below();
        BlockState below_state = world.getBlockState(check_pos_below);
        boolean below_state_pathfindable = below_state.isPathfindable(PathComputationType.LAND);
        if (below_state_pathfindable && below_state.getFluidState().isEmpty()) {
            return check_pos_below;
        }
        return check_pos;
    }
}

