/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.spawn;

import com.google.common.collect.ImmutableMap;
import dtnpaletteofpaws.DTNEntityTypes;
import dtnpaletteofpaws.DTNPConfig;
import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.spawn.DTNWolfSpawnPlacements;
import dtnpaletteofpaws.common.spawn.WolfSpawnPlacementType;
import dtnpaletteofpaws.common.util.RandomUtil;
import dtnpaletteofpaws.common.variant.biome_config.WolfBiomeConfig;
import dtnpaletteofpaws.common.variant.biome_config.WolfBiomeConfigs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.EventHooks;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class DTNWolfStaticSpawnManager {
    private static final DTNWolfStaticSpawnManager instance = new DTNWolfStaticSpawnManager();
    private static final ThreadLocal<Holder<Biome>> currentSpawnBiome = new ThreadLocal();
    private static Map<ResourceKey<Biome>, List<WolfBiomeConfig>> configByBiome = ImmutableMap.of();
    private static boolean disabled = false;

    public static DTNWolfStaticSpawnManager get() {
        return instance;
    }

    public void onChunkGenerationMobSpawn(ServerLevelAccessor level_accessor, Holder<Biome> biome, ChunkPos chunk_pos, RandomSource random) {
        MobSpawnSettings spawn_settings = ((Biome)biome.value()).getMobSettings();
        float biome_chance = spawn_settings.getCreatureProbability();
        this.onChunkGenerationMobSpawn(level_accessor, biome, chunk_pos, random, biome_chance);
    }

    public void onChunkGenerationMobSpawn(ServerLevelAccessor level_accessor, Holder<Biome> biome, ChunkPos chunk_pos, RandomSource random, float biome_chance) {
        if (disabled) {
            return;
        }
        List configs = null;
        while (random.nextFloat() < biome_chance && (configs != null || !(configs = configByBiome.getOrDefault(biome.getKey(), List.of())).isEmpty())) {
            WolfBiomeConfig config;
            List<WolfBiomeConfig> filtered_configs = DTNWolfStaticSpawnManager.filterWolfBiomeConfig(configs, random);
            if (filtered_configs.isEmpty() || (config = (WolfBiomeConfig)RandomUtil.getRandomItem(random, filtered_configs).orElse(null)) == null) continue;
            DTNWolfStaticSpawnManager.doChunkGeneratedSpawnIteration(level_accessor, biome, chunk_pos, random, config);
        }
    }

    public static List<WolfBiomeConfig> filterWolfBiomeConfig(List<WolfBiomeConfig> configs, RandomSource random) {
        float r = random.nextFloat();
        return configs.stream().filter(x -> r <= x.spawnChance()).toList();
    }

    public Optional<Holder<Biome>> currentSpawnBiome() {
        Holder<Biome> val = currentSpawnBiome.get();
        return Optional.ofNullable(val);
    }

    public static void onSpawnOriginalMobsForChunk(WorldGenRegion region) {
        if (disabled) {
            return;
        }
        if (DTNWolfStaticSpawnManager.isTheEndSpawn(region)) {
            DTNWolfStaticSpawnManager.spawnDTNWOlfForChunkGeneration(region, 0.01f, region.getMaxY() - 1);
        }
    }

    private static boolean isTheEndSpawn(WorldGenRegion region) {
        ServerLevel level = region.getLevel();
        if (level == null) {
            return false;
        }
        ResourceKey dim = level.dimension();
        if (dim == null) {
            return false;
        }
        return dim.equals(Level.END);
    }

    public static void spawnDTNWOlfForChunkGeneration(WorldGenRegion region, float biome_chance, int at_height) {
        ChunkPos chunkpos = region.getCenter();
        Holder biome = region.getBiome(chunkpos.getWorldPosition().atY(at_height));
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.generateUniqueSeed()));
        worldgenrandom.setDecorationSeed(region.getSeed(), chunkpos.getMinBlockX(), chunkpos.getMinBlockZ());
        DTNWolfStaticSpawnManager.spawnDTNWOlfForChunkGeneration((ServerLevelAccessor)region, (Holder<Biome>)biome, chunkpos, (RandomSource)worldgenrandom, biome_chance);
    }

    public static void spawnDTNWOlfForChunkGeneration(ServerLevelAccessor level_accessor, Holder<Biome> biome, ChunkPos chunk_pos, RandomSource rand, float biome_chance) {
        DTNWolfStaticSpawnManager.get().onChunkGenerationMobSpawn(level_accessor, biome, chunk_pos, rand, biome_chance);
    }

    private static void doChunkGeneratedSpawnIteration(ServerLevelAccessor level_accessor, Holder<Biome> biome, ChunkPos chunk_pos, RandomSource rand, WolfBiomeConfig config) {
        int min_x = chunk_pos.getMinBlockX();
        int min_z = chunk_pos.getMinBlockZ();
        int spawn_count = config.minCount() + rand.nextInt(1 + config.maxCount() - config.minCount());
        MutableObject spawngroupdata = new MutableObject(null);
        int check_x = min_x + rand.nextInt(16);
        int check_z = min_z + rand.nextInt(16);
        for (int indiv_no = 0; indiv_no < spawn_count; ++indiv_no) {
            boolean spawned_individual = false;
            for (int attempt = 0; !spawned_individual && attempt < 4; ++attempt) {
                BlockPos spawnable_pos = config.placementType() == WolfSpawnPlacementType.UNDERGROUND ? DTNWolfSpawnPlacements.getRandomUndergroundPos(rand, (LevelReader)level_accessor, check_x, check_z, biome) : DTNWolfSpawnPlacements.getDTNWolfTopNonCollidingPos(config.placementType(), (LevelReader)level_accessor, check_x, check_z);
                if (DTNWolfSpawnPlacements.spawnPlacementTypeCheck((LevelReader)level_accessor, spawnable_pos, config)) {
                    spawned_individual = DTNWolfStaticSpawnManager.doSpawnIndividual(level_accessor, config, min_x, min_z, spawnable_pos, (Mutable<SpawnGroupData>)spawngroupdata, rand);
                }
                int check_x0 = check_x;
                int check_z0 = check_z;
                check_x = check_x0 + DTNWolfStaticSpawnManager.randTriangle(rand, 4);
                check_z = check_z0 + DTNWolfStaticSpawnManager.randTriangle(rand, 4);
                while (check_x < min_x || check_x >= min_x + 16 || check_z < min_z || check_z >= min_z + 16) {
                    check_x = check_x0 + DTNWolfStaticSpawnManager.randTriangle(rand, 4);
                    check_z = check_z0 + DTNWolfStaticSpawnManager.randTriangle(rand, 4);
                }
            }
        }
    }

    private static boolean doSpawnIndividual(ServerLevelAccessor level_accessor, WolfBiomeConfig config, int min_x, int min_z, BlockPos check_pos, Mutable<SpawnGroupData> spawn_group_mut, RandomSource rand) {
        boolean spawn_position_check;
        DTNWolf wolf;
        double spawn_x = (float)check_pos.getX() + 0.5f;
        double spawn_z = (float)check_pos.getZ() + 0.5f;
        float entity_width = DTNWolfStaticSpawnManager.wolfType().getWidth();
        spawn_x = Mth.clamp((double)spawn_x, (double)((float)min_x + entity_width), (double)((double)min_x + 16.0 - (double)entity_width));
        spawn_z = Mth.clamp((double)spawn_z, (double)((float)min_z + entity_width), (double)((double)min_z + 16.0 - (double)entity_width));
        check_pos = BlockPos.containing((double)spawn_x, (double)check_pos.getY(), (double)spawn_z);
        AABB spawn_aabb = DTNWolfStaticSpawnManager.wolfType().getSpawnAABB(spawn_x, (double)check_pos.getY(), spawn_z);
        boolean no_collision_at_pos = level_accessor.noCollision(spawn_aabb);
        if (!no_collision_at_pos) {
            return false;
        }
        boolean spawn_rule_check = DTNWolfSpawnPlacements.DTNWolfSpawnableOn(config, (LevelAccessor)level_accessor, EntitySpawnReason.CHUNK_GENERATION, check_pos, level_accessor.getRandom());
        if (!spawn_rule_check) {
            return false;
        }
        try {
            wolf = (DTNWolf)DTNWolfStaticSpawnManager.wolfType().create((Level)level_accessor.getLevel(), EntitySpawnReason.CHUNK_GENERATION);
        }
        catch (Exception exception) {
            return false;
        }
        if (wolf == null) {
            return false;
        }
        wolf.snapTo(spawn_x, check_pos.getY(), spawn_z, rand.nextFloat() * 360.0f, 0.0f);
        boolean bl = spawn_position_check = EventHooks.checkSpawnPosition((Mob)wolf, (ServerLevelAccessor)level_accessor, (EntitySpawnReason)EntitySpawnReason.CHUNK_GENERATION) && wolf.DTNWolfCheckAdditionalSpawnObstruction((LevelReader)level_accessor, config);
        if (!spawn_position_check) {
            return false;
        }
        Object spawn_group0 = (SpawnGroupData)spawn_group_mut.getValue();
        if (spawn_group0 == null) {
            spawn_group0 = wolf.initializeGroupData(level_accessor, config);
        }
        SpawnGroupData spawngroupdata = wolf.finalizeSpawn(level_accessor, level_accessor.getCurrentDifficultyAt(wolf.blockPosition()), EntitySpawnReason.CHUNK_GENERATION, (SpawnGroupData)spawn_group0);
        spawn_group_mut.setValue((Object)spawngroupdata);
        level_accessor.addFreshEntityWithPassengers((Entity)wolf);
        return true;
    }

    private static int randTriangle(RandomSource rand, int vary_range) {
        return rand.nextInt(vary_range + 1) - rand.nextInt(vary_range + 1);
    }

    private static EntityType<DTNWolf> wolfType() {
        return DTNEntityTypes.DTNWOLF.get();
    }

    private static void initConfigCache(HolderLookup.Provider prov) {
        HashMap new_map = new HashMap();
        HolderLookup.RegistryLookup config_reg = prov.lookupOrThrow(WolfBiomeConfigs.regKey());
        boolean underground_spawn = (Boolean)DTNPConfig.SERVER.DTNP_STATIC_UNDERGROUND_SPAWN.get();
        config_reg.listElements().forEach(config_holder -> {
            WolfBiomeConfig config = (WolfBiomeConfig)config_holder.value();
            if (!config.doSpawn()) {
                return;
            }
            if (!underground_spawn && config.placementType() == WolfSpawnPlacementType.UNDERGROUND) {
                return;
            }
            for (Holder biome : config.biomes()) {
                new_map.computeIfAbsent(biome.getKey(), key -> new ArrayList()).add(config);
            }
        });
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : new_map.entrySet()) {
            builder.put((Object)((ResourceKey)entry.getKey()), List.copyOf((Collection)entry.getValue()));
        }
        configByBiome = builder.build();
    }

    private static void invalidateConifgCache() {
        configByBiome = ImmutableMap.of();
    }

    public static void onServerStarting(MinecraftServer server) {
        DTNWolfStaticSpawnManager.initConfigCache((HolderLookup.Provider)server.registryAccess());
        disabled = (Boolean)DTNPConfig.SERVER.DTNP_STATIC_SPAWN.get() == false;
    }

    public static void onServerStopped() {
        DTNWolfStaticSpawnManager.invalidateConifgCache();
    }
}

