/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.util;

import dtnpaletteofpaws.DTNRegistries;
import dtnpaletteofpaws.WolfVariants;
import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.variant.WolfVariant;
import dtnpaletteofpaws.common.variant.biome_config.WolfBiomeConfig;
import dtnpaletteofpaws.common.variant.biome_config.WolfBiomeConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.Tags;

public class WolfVariantUtil {
    public static WolfVariant getDefault() {
        return WolfVariants.BIRCH.get();
    }

    public static WolfVariant variantFromString(String id) {
        ResourceLocation res = ResourceLocation.tryParse((String)id);
        if (res == null) {
            return WolfVariantUtil.getDefault();
        }
        WolfVariant variant = (WolfVariant)DTNRegistries.DTN_WOLF_VARIANT.get().getValue(res);
        if (variant == null) {
            variant = WolfVariantUtil.getDefault();
        }
        return variant;
    }

    public static String variantToString(WolfVariant variant) {
        ResourceLocation id = DTNRegistries.DTN_WOLF_VARIANT.get().getKey((Object)variant);
        if (id == null) {
            return DTNRegistries.DTN_WOLF_VARIANT.get().getKey((Object)WolfVariantUtil.getDefault()).toString();
        }
        return id.toString();
    }

    public static WolfVariant getDefaultForSpawn(DTNWolf wolf, ServerLevelAccessor s_level_accessor) {
        ServerLevel level = s_level_accessor.getLevel();
        if (level != null && level.dimension().equals(Level.NETHER)) {
            return WolfVariants.MOLTEN.get();
        }
        if (WolfVariantUtil.checkWaterSpawn(s_level_accessor, wolf)) {
            return WolfVariants.KOMBU.get();
        }
        return WolfVariantUtil.getDefault();
    }

    private static boolean checkWaterSpawn(ServerLevelAccessor s_level_accessor, DTNWolf wolf) {
        BlockPos pos = wolf.blockPosition();
        FluidState below_state = s_level_accessor.getFluidState(pos.below());
        return below_state.is(Tags.Fluids.WATER);
    }

    public static List<WolfBiomeConfig> getAllWolfBiomeConfigForBiome(RegistryAccess prov, Holder<Biome> biome, Predicate<WolfBiomeConfig> extra_conditions) {
        Registry biome_config_reg = prov.lookupOrThrow(WolfBiomeConfigs.regKey());
        List<WolfBiomeConfig> filtered_config = biome_config_reg.listElements().filter(filter_config -> ((WolfBiomeConfig)filter_config.value()).biomes().contains(biome)).map(x -> (WolfBiomeConfig)x.value()).filter(extra_conditions).collect(Collectors.toList());
        return filtered_config;
    }

    public static List<WolfVariant> getPossibleSpawnVariants(RandomSource random, RegistryAccess prov, Holder<Biome> biome, Predicate<WolfBiomeConfig> extra_conditions) {
        List<WolfBiomeConfig> filtered_config = WolfVariantUtil.getAllWolfBiomeConfigForBiome(prov, biome, extra_conditions);
        if (filtered_config.isEmpty()) {
            return List.of();
        }
        if (filtered_config.size() == 1) {
            return new ArrayList<WolfVariant>(filtered_config.get(0).variants());
        }
        int r = random.nextInt(filtered_config.size());
        WolfBiomeConfig selected_config = filtered_config.get(r);
        return new ArrayList<WolfVariant>(selected_config.variants());
    }
}

