/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.variant;

import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.lib.Resources;
import dtnpaletteofpaws.common.util.RandomUtil;
import dtnpaletteofpaws.common.variant.WolfVariant;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class MoltenWolfVariant
extends WolfVariant {
    public MoltenWolfVariant(String name) {
        super(WolfVariant.props(name).fireImmune().fallImmune().glowingOverlay(Resources.getDTNWolfTexture("variants/wolf_molten_overlay"), Resources.getDTNWolfTexture("variants/wolf_molten_wild_overlay")));
    }

    @Override
    public void tickWolf(DTNWolf wolf) {
        double dz;
        double dx;
        boolean is_moving;
        super.tickWolf(wolf);
        if (!wolf.level().isClientSide) {
            return;
        }
        RandomSource random = wolf.getRandom();
        Level level = wolf.level();
        if (random.nextInt(100) == 0) {
            double d0 = wolf.getX() + (double)(RandomUtil.nextFloatRemapped(random) * (wolf.getBbWidth() / 2.0f));
            double d1 = wolf.getY() + (double)(random.nextFloat() * wolf.getBbHeight());
            double d2 = wolf.getZ() + (double)(RandomUtil.nextFloatRemapped(random) * (wolf.getBbWidth() / 2.0f));
            level.addParticle((ParticleOptions)ParticleTypes.LAVA, d0, d1, d2, 0.0, 0.0, 0.0);
            level.playLocalSound(d0, d1, d2, SoundEvents.LAVA_POP, SoundSource.AMBIENT, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
        boolean bl = is_moving = (dx = wolf.getX() - wolf.xo) * dx + (dz = wolf.getZ() - wolf.zo) * dz > 2.500000277905201E-7;
        if (is_moving && wolf.getRandom().nextInt(3) == 0) {
            int r = wolf.getRandom().nextInt(3);
            SimpleParticleType type = null;
            type = r == 0 ? ParticleTypes.FLAME : ParticleTypes.LANDING_LAVA;
            if (type != null) {
                double d0 = wolf.getX() + (double)(RandomUtil.nextFloatRemapped(random) * (wolf.getBbWidth() / 2.0f));
                double d1 = wolf.getY() + (double)random.nextFloat() * ((double)wolf.getBbHeight() * 0.8);
                double d2 = wolf.getZ() + (double)(RandomUtil.nextFloatRemapped(random) * (wolf.getBbWidth() / 2.0f));
                level.addParticle((ParticleOptions)type, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }
}

