/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.variant;

import dtnpaletteofpaws.DTNParticles;
import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.lib.Resources;
import dtnpaletteofpaws.common.util.RandomUtil;
import dtnpaletteofpaws.common.variant.WolfVariant;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class WanderingSoulWolfVariant
extends WolfVariant {
    public WanderingSoulWolfVariant(String name) {
        super(WolfVariant.props(name).fireImmune().fallImmune().glowingOverlay(Resources.getDTNWolfTexture("variants/wolf_wandering_soul"), Resources.getDTNWolfTexture("variants/wolf_wandering_soul_wild")));
    }

    @Override
    public void tickWolf(DTNWolf wolf) {
        super.tickWolf(wolf);
        if (!wolf.level().isClientSide) {
            return;
        }
        RandomSource random = wolf.getRandom();
        Level level = wolf.level();
        double dx = wolf.getX() - wolf.xo;
        double dz = wolf.getZ() - wolf.zo;
        if (wolf.getRandom().nextInt(3) == 0) {
            double d0 = wolf.getX() + (double)(RandomUtil.nextFloatRemapped(random) * (wolf.getBbWidth() / 2.0f));
            double d1 = wolf.getY() + (double)random.nextFloat() * ((double)wolf.getBbHeight() * 0.8);
            double d2 = wolf.getZ() + (double)(RandomUtil.nextFloatRemapped(random) * (wolf.getBbWidth() / 2.0f));
            level.addParticle((ParticleOptions)DTNParticles.WANDERING_SOUL_GLOW.get(), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

