/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.variant;

import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.lib.Resources;
import dtnpaletteofpaws.common.util.RandomUtil;
import dtnpaletteofpaws.common.variant.WolfVariant;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class WitheredSoulWolfVariant
extends WolfVariant {
    public WitheredSoulWolfVariant(String name) {
        super(WolfVariant.props(name).fireImmune().fallImmune().glowingOverlay(Resources.getDTNWolfTexture("variants/wolf_withered_soul_overlay"), Resources.getDTNWolfTexture("variants/wolf_withered_soul_wild_overlay")));
    }

    @Override
    public void tickWolf(DTNWolf wolf) {
        SimpleParticleType type;
        super.tickWolf(wolf);
        if (!wolf.level().isClientSide) {
            return;
        }
        RandomSource random = wolf.getRandom();
        Level level = wolf.level();
        if (wolf.getRandom().nextInt(3) == 0 && (type = ParticleTypes.SOUL_FIRE_FLAME) != null) {
            double d0 = wolf.getX() + (double)(RandomUtil.nextFloatRemapped(random) * (wolf.getBbWidth() / 2.0f));
            double d1 = wolf.getY() + (double)wolf.getBbHeight();
            double d2 = wolf.getZ() + (double)(RandomUtil.nextFloatRemapped(random) * (wolf.getBbWidth() / 2.0f));
            level.addParticle((ParticleOptions)type, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

