/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.variant.biome_config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dtnpaletteofpaws.DTNRegistries;
import dtnpaletteofpaws.common.spawn.WolfSpawnPlacementType;
import dtnpaletteofpaws.common.variant.WolfVariant;
import dtnpaletteofpaws.common.variant.biome_config.WolfBiomeConfigs;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public class WolfBiomeConfig {
    private final Set<WolfVariant> variants;
    private final HolderSet<Biome> biomes;
    private final Set<Block> extraSpawnableBlocks;
    private final boolean canSpawnInDark;
    private final WolfSpawnPlacementType placementType;
    private final int minCount;
    private final int maxCount;
    private final float spawnChance;
    private final List<WolfVariant> variantsAsList;
    private final List<Block> blocksAsList;
    public static final Codec<WolfBiomeConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DTNRegistries.DTN_WOLF_VARIANT.get().byNameCodec().listOf().optionalFieldOf("variants").forGetter(WolfBiomeConfig::variantsAsList), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).fieldOf("biomes").forGetter(WolfBiomeConfig::biomes), (App)BuiltInRegistries.BLOCK.byNameCodec().listOf().optionalFieldOf("blocks").forGetter(WolfBiomeConfig::blocksAsList), (App)Codec.BOOL.optionalFieldOf("can_spawn_in_dark", (Object)false).forGetter(WolfBiomeConfig::canSpawnInDark), (App)WolfSpawnPlacementType.CODEC.optionalFieldOf("placement_type", (Object)WolfSpawnPlacementType.GROUND).forGetter(WolfBiomeConfig::placementType), (App)Codec.INT.optionalFieldOf("min_count", (Object)1).forGetter(WolfBiomeConfig::minCount), (App)Codec.INT.optionalFieldOf("max_count", (Object)1).forGetter(WolfBiomeConfig::maxCount), (App)Codec.FLOAT.optionalFieldOf("spawn_chance", (Object)Float.valueOf(WolfBiomeConfig.defaultSpawnChance())).forGetter(WolfBiomeConfig::spawnChance)).apply((Applicative)builder, WolfBiomeConfig::codecDeserializer));

    private WolfBiomeConfig(List<WolfVariant> variants, HolderSet<Biome> biomes, List<Block> blocks, boolean canSpawnInDark, WolfSpawnPlacementType placementType, int minCount, int maxCount, float spawnChance) {
        this.variants = new HashSet<WolfVariant>(variants);
        this.biomes = biomes;
        this.extraSpawnableBlocks = new HashSet<Block>(blocks);
        this.canSpawnInDark = canSpawnInDark;
        this.placementType = placementType;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.spawnChance = Mth.clamp((float)spawnChance, (float)0.0f, (float)1.0f);
        this.variantsAsList = variants;
        this.blocksAsList = blocks;
    }

    public boolean doSpawn() {
        return this.spawnChance > 0.0f;
    }

    public int minCount() {
        return this.minCount;
    }

    public int maxCount() {
        return this.maxCount;
    }

    public float spawnChance() {
        return this.spawnChance;
    }

    public HolderSet<Biome> biomes() {
        return this.biomes;
    }

    public Set<Block> blocks() {
        return this.extraSpawnableBlocks;
    }

    public Set<WolfVariant> variants() {
        return this.variants;
    }

    public boolean canSpawnInDark() {
        return this.canSpawnInDark;
    }

    public WolfSpawnPlacementType placementType() {
        return this.placementType;
    }

    public Optional<List<Block>> blocksAsList() {
        return Optional.of(this.blocksAsList).filter(x -> !x.isEmpty());
    }

    public Optional<List<WolfVariant>> variantsAsList() {
        return Optional.of(this.variantsAsList).filter(x -> !x.isEmpty());
    }

    public static float defaultSpawnChance() {
        return 0.0f;
    }

    public static final Builder builder(BootstrapContext<WolfBiomeConfig> ctx, ResourceLocation id) {
        return new Builder(ctx, (ResourceKey<WolfBiomeConfig>)ResourceKey.create(WolfBiomeConfigs.regKey(), (ResourceLocation)id));
    }

    public static final Builder builder(BootstrapContext<WolfBiomeConfig> ctx, Supplier<WolfVariant> variant_sup) {
        WolfVariant variant = variant_sup.get();
        Registry<WolfVariant> variant_reg = DTNRegistries.DTN_WOLF_VARIANT.get();
        ResourceLocation wolf_variant_id = variant_reg.getKey((Object)variant);
        if (wolf_variant_id == null) {
            throw new IllegalStateException("unregistered wolf variant");
        }
        ResourceKey res_key = ResourceKey.create(WolfBiomeConfigs.regKey(), (ResourceLocation)wolf_variant_id);
        return new Builder(ctx, (ResourceKey<WolfBiomeConfig>)res_key).variant(variant);
    }

    private static WolfBiomeConfig codecDeserializer(Optional<List<WolfVariant>> variants, HolderSet<Biome> biomes, Optional<List<Block>> blocks, boolean canSpawnInDark, WolfSpawnPlacementType placementType, int minCount, int maxCount, float spawnChance) {
        return new WolfBiomeConfig(variants.orElse(List.of()), biomes, blocks.orElse(List.of()), canSpawnInDark, placementType, minCount, maxCount, spawnChance);
    }

    public static class Builder {
        private final BootstrapContext<WolfBiomeConfig> ctx;
        private final ResourceKey<WolfBiomeConfig> id;
        private List<WolfVariant> variants = List.of();
        private HolderSet<Biome> biomes = HolderSet.empty();
        private List<Block> extraSpawnableBlocks = List.of();
        private boolean canSpawnInDark = false;
        private WolfSpawnPlacementType placementType = WolfSpawnPlacementType.GROUND;
        private int minCount = 1;
        private int maxCount = 1;
        private float spawnChance = 0.0f;

        private Builder(BootstrapContext<WolfBiomeConfig> ctx, ResourceKey<WolfBiomeConfig> id) {
            this.ctx = ctx;
            this.id = id;
        }

        public Builder variant(WolfVariant ... variants) {
            if (variants.length <= 0) {
                throw new IllegalArgumentException("variants cannot be empty!");
            }
            this.variants = Arrays.asList(variants);
            return this;
        }

        @SafeVarargs
        public final Builder variant(Supplier<WolfVariant> ... variants) {
            return this.variant((WolfVariant[])Arrays.stream(variants).map(x -> (WolfVariant)x.get()).toArray(WolfVariant[]::new));
        }

        @SafeVarargs
        public final Builder biome(ResourceKey<Biome> ... biomes) {
            if (biomes.length <= 0) {
                throw new IllegalArgumentException("biomes cannot be empty!");
            }
            HolderGetter biome_reg = this.ctx.lookup(Registries.BIOME);
            List biome_holders_list = Arrays.stream(biomes).map(x -> biome_reg.get(x)).filter(x -> x.isPresent()).map(x -> (Holder.Reference)x.get()).collect(Collectors.toList());
            HolderSet.Direct biome_holder_set = HolderSet.direct(biome_holders_list);
            return this.biome((HolderSet<Biome>)biome_holder_set);
        }

        public Builder biome(HolderSet<Biome> biome_set) {
            this.biomes = biome_set;
            return this;
        }

        public Builder extraSpawnableBlock(Block ... blocks) {
            this.extraSpawnableBlocks = Arrays.asList(blocks);
            return this;
        }

        public Builder canSpawnInDark() {
            this.canSpawnInDark = true;
            return this;
        }

        public Builder placementType(WolfSpawnPlacementType val) {
            this.placementType = val;
            return this;
        }

        public Builder packSize(int minCount, int maxCount) {
            this.minCount = minCount;
            this.maxCount = maxCount;
            return this;
        }

        public Builder spawnChance(float val) {
            this.spawnChance = val;
            return this;
        }

        public WolfBiomeConfig build() {
            if (this.variants.isEmpty()) {
                throw new IllegalStateException(String.format("Attempting to register a config that has no Wolf Variants: %s", this.id.location().toString()));
            }
            return new WolfBiomeConfig(this.variants, this.biomes, this.extraSpawnableBlocks, this.canSpawnInDark, this.placementType, this.minCount, this.maxCount, this.spawnChance);
        }

        public void buildAndRegister() {
            this.ctx.register(this.id, (Object)this.build());
        }
    }
}

