/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.dtn_support;

import doggytalents.DoggyAccessories;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.accessory.DyeableAccessory;
import doggytalents.common.entity.ai.triggerable.AnimationAction;
import doggytalents.common.entity.ai.triggerable.DogBackFlipAction;
import doggytalents.common.event.EventHandler;
import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.variant.WolfVariant;
import dtnpaletteofpaws.dtn_support.variant.DTNDogVariantMapping;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class DTNSupportEventHandler {
    public static void registerSelf(IEventBus forge_event_bus) {
        forge_event_bus.register((Object)new DTNSupportEventHandler());
    }

    @SubscribeEvent
    public void onWolfRightClickWithTreat(PlayerInteractEvent.EntityInteract event) {
        Level level = event.getLevel();
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        Player owner = event.getEntity();
        if (stack.getItem() != DoggyItems.TRAINING_TREAT.get()) {
            return;
        }
        if (!(target instanceof DTNWolf)) {
            return;
        }
        DTNWolf wolf = (DTNWolf)target;
        event.setCanceled(true);
        if (!DTNSupportEventHandler.checkValidWolf(wolf, owner)) {
            event.setCancellationResult((InteractionResult)InteractionResult.FAIL);
            return;
        }
        if (!level.isClientSide) {
            DTNSupportEventHandler.checkAndTrainWolf(owner, wolf);
        }
        event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
    }

    public static void checkAndTrainWolf(Player trainer, DTNWolf wolf) {
        Level level = trainer.level();
        if (level.isClientSide) {
            return;
        }
        ItemStack stack = trainer.getMainHandItem();
        if (stack.getItem() != DoggyItems.TRAINING_TREAT.get()) {
            return;
        }
        if (!DTNSupportEventHandler.checkValidWolf(wolf, trainer)) {
            return;
        }
        if (!EventHandler.isWithinTrainWolfLimit((Player)trainer)) {
            level.broadcastEntityEvent((Entity)wolf, (byte)6);
            return;
        }
        if (!trainer.getAbilities().instabuild) {
            stack.shrink(1);
        }
        DTNSupportEventHandler.tameWolfIfNeccessary(wolf, trainer);
        DTNSupportEventHandler.trainWolf(wolf, trainer, level);
    }

    private static boolean checkValidWolf(DTNWolf wolf, Player owner) {
        if (!wolf.isAlive()) {
            return false;
        }
        boolean condition1 = !wolf.isTame();
        boolean condition2 = wolf.isTame() && wolf.isOwnedBy((LivingEntity)owner);
        return condition1 || condition2;
    }

    public static void tameWolfIfNeccessary(DTNWolf wolf, Player owner) {
        if (wolf.isTame()) {
            return;
        }
        wolf.tame(owner);
    }

    public static void trainWolf(DTNWolf wolf, Player owner, Level level) {
        Dog dog = (Dog)((EntityType)DoggyEntityTypes.DOG.get()).create(level, EntitySpawnReason.LOAD);
        if (dog == null) {
            throw new IllegalStateException("Creator function for the dog returned \"null\"");
        }
        dog.setTame(true, true);
        dog.setOwnerUUID(owner.getUUID());
        dog.maxHealth();
        dog.setOrderedToSit(false);
        dog.setAge(wolf.getAge());
        dog.snapTo(wolf.getX(), wolf.getY(), wolf.getZ(), wolf.getYRot(), wolf.getXRot());
        dog.setYHeadRot(wolf.yBodyRot);
        dog.setYBodyRot(wolf.yBodyRot);
        dog.setYRot(wolf.yBodyRot);
        DyeColor wolf_collar_color = wolf.getCollarColor();
        int color = wolf_collar_color.getTextureDiffuseColor();
        AccessoryInstance dog_collar = ((DyeableAccessory)DoggyAccessories.DYEABLE_COLLAR.get()).create(color);
        if (dog_collar != null) {
            dog.addAccessory(dog_collar);
        }
        DTNSupportEventHandler.migrateWolfVariant(wolf, dog);
        DTNSupportEventHandler.migrateWolfArmor(wolf, dog);
        if (wolf.hasCustomName()) {
            dog.setDogCustomName(wolf.getCustomName());
        }
        UUID wolf_uuid = wolf.getUUID();
        wolf.discard();
        if (level instanceof ServerLevel) {
            ServerLevel sL = (ServerLevel)level;
            DTNSupportEventHandler.migrateUUID(wolf_uuid, dog, sL);
        }
        level.addFreshEntity((Entity)dog);
        dog.triggerAnimationAction((AnimationAction)new DogBackFlipAction(dog));
        dog.getJumpControl().jump();
    }

    private static void migrateUUID(UUID uuid, Dog dog, ServerLevel level) {
        if (((Boolean)ConfigHandler.SERVER.DISABLE_PRESERVE_UUID.get()).booleanValue()) {
            return;
        }
        if (level.getEntity(uuid) != null) {
            return;
        }
        dog.setUUID(uuid);
    }

    private static void migrateWolfVariant(DTNWolf wolf, Dog dog) {
        WolfVariant variant = wolf.getVariant();
        dog.setDogVariant(DTNDogVariantMapping.getDTNWolf(variant));
    }

    private static void migrateWolfArmor(DTNWolf wolf, Dog dog) {
        if (!wolf.hasWolfArmor()) {
            return;
        }
        ItemStack armor_stack = wolf.getBodyArmorItem().copyWithCount(1);
        dog.setWolfArmor(armor_stack);
    }
}

