/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.dtn_support.variant;

import doggytalents.DoggyRegistries;
import doggytalents.common.variant.DogVariant;
import dtnpaletteofpaws.common.util.Util;
import dtnpaletteofpaws.dtn_support.variant.DessicatedDogVariant;
import dtnpaletteofpaws.dtn_support.variant.EnderDogVariant;
import dtnpaletteofpaws.dtn_support.variant.FrostyDogVariant;
import dtnpaletteofpaws.dtn_support.variant.SanguineDogVariant;
import dtnpaletteofpaws.dtn_support.variant.SwimmerDogVariant;
import dtnpaletteofpaws.dtn_support.variant.WanderingSoulDogVariant;
import dtnpaletteofpaws.dtn_support.variant.WitheredSoulDogVariant;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DTNSupportDogVariants {
    public static final DeferredRegister<DogVariant> DOG_VARIANT = DeferredRegister.create((ResourceKey)DoggyRegistries.Keys.DOG_VARIANT, (String)"dtnpaletteofpaws");
    public static final Supplier<DogVariant> CAPPUCCINO = DTNSupportDogVariants.register("cappuccino", -5344201);
    public static final Supplier<DogVariant> ESPRESSO = DTNSupportDogVariants.register("espresso", -14152445);
    public static final Supplier<DogVariant> LATTE = DTNSupportDogVariants.register("latte", -6586522);
    public static final Supplier<DogVariant> MOCHA = DTNSupportDogVariants.register("mocha", -10671360);
    public static final Supplier<DogVariant> WITHERED_SOUL = DTNSupportDogVariants.register("withered_soul", WitheredSoulDogVariant::new);
    public static final Supplier<DogVariant> MUSHROOM_RED = DTNSupportDogVariants.register("red_mushroom", -4184540);
    public static final Supplier<DogVariant> MUSHROOM_BROWN = DTNSupportDogVariants.register("brown_mushroom", -6720429);
    public static final Supplier<DogVariant> BONITO_FLAKES = DTNSupportDogVariants.register("bonito_flakes", -3440546);
    public static final Supplier<DogVariant> KOMBU = DTNSupportDogVariants.registerSwimmer("kombu", -13219555);
    public static final Supplier<DogVariant> SHITAKE = DTNSupportDogVariants.register("shitake", -13818332);
    public static final Supplier<DogVariant> ENOKI = DTNSupportDogVariants.register("enoki", -2045794);
    public static final Supplier<DogVariant> VANILLA = DTNSupportDogVariants.register("vanilla", -923466);
    public static final Supplier<DogVariant> STRAWBERRY = DTNSupportDogVariants.register("strawberry", -1211499);
    public static final Supplier<DogVariant> CHOCOLATE = DTNSupportDogVariants.register("chocolate", -11325148);
    public static final Supplier<DogVariant> WALNUT = DTNSupportDogVariants.register("walnut", -4683947);
    public static final Supplier<DogVariant> CORAL_BRAIN = DTNSupportDogVariants.registerSwimmer("coral_brain", -3256682);
    public static final Supplier<DogVariant> CORAL_BUBBLE = DTNSupportDogVariants.registerSwimmer("coral_bubble", -7268719);
    public static final Supplier<DogVariant> CORAL_FIRE = DTNSupportDogVariants.registerSwimmer("coral_fire", -5036493);
    public static final Supplier<DogVariant> CORAL_HORN = DTNSupportDogVariants.registerSwimmer("coral_horn", -2041275);
    public static final Supplier<DogVariant> CORAL_TUBE = DTNSupportDogVariants.registerSwimmer("coral_tube", -14334302);
    public static final Supplier<DogVariant> ENDER = DTNSupportDogVariants.register("ender", EnderDogVariant::new);
    public static final Supplier<DogVariant> CHORUS = DTNSupportDogVariants.register("chorus", -11129258);
    public static final Supplier<DogVariant> WANDERING_SOUL = DTNSupportDogVariants.register("wandering_soul", WanderingSoulDogVariant::new);
    public static final Supplier<DogVariant> SANGUINE = DTNSupportDogVariants.register("sanguine", SanguineDogVariant::new);
    public static final Supplier<DogVariant> DESICCATED = DTNSupportDogVariants.register("desiccated", DessicatedDogVariant::new);
    public static final Supplier<DogVariant> FROSTY = DTNSupportDogVariants.register("frosty", FrostyDogVariant::new);
    public static final Supplier<DogVariant> ICY = DTNSupportDogVariants.register("icy", -9460227);
    public static final Supplier<DogVariant> MUDDY = DTNSupportDogVariants.register("muddy", -9741755);
    public static final Supplier<DogVariant> BRINDLE = DTNSupportDogVariants.register("brindle", -10001330);
    public static final Supplier<DogVariant> SOOTY = DTNSupportDogVariants.register("sooty", -15395307);
    public static final Supplier<DogVariant> ROOT_BEER = DTNSupportDogVariants.register("root_beer", -12436938);
    public static final Supplier<DogVariant> CAKE = DTNSupportDogVariants.register("cake", -9095920);
    public static final Supplier<DogVariant> CHARCOAL = DTNSupportDogVariants.register("charcoal", -15002597);
    public static final Supplier<DogVariant> SCULK = DTNSupportDogVariants.register("sculk", -15123388);

    private static Supplier<DogVariant> registerSwimmer(String name, int guiColor) {
        return DOG_VARIANT.register(name, () -> new SwimmerDogVariant(name, guiColor));
    }

    private static Supplier<DogVariant> register(String name, Function<String, DogVariant> variant_creator) {
        DogVariant captured_variant = variant_creator.apply(name);
        return DOG_VARIANT.register(name, () -> captured_variant);
    }

    private static Supplier<DogVariant> register(String name, int gui_color) {
        return DTNSupportDogVariants.register(name, p -> {}, gui_color);
    }

    private static Supplier<DogVariant> register(String name, Consumer<DogVariant.Props> props_consumer, int gui_color) {
        DogVariant.Props props = DogVariant.props((ResourceLocation)Util.getResource(name)).customTexture(Util.modifyPath(Util.getResource(name), x -> "textures/entity/dtnwolf/variants/wolf_" + x)).customTranslation("dtnpaletteofpaws.variant." + name).guiColor(gui_color);
        props_consumer.accept(props);
        DogVariant captured_variant = new DogVariant(props);
        return DOG_VARIANT.register(name, () -> captured_variant);
    }
}

