/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.dtn_support.variant;

import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.variant.DogVariant;
import dtnpaletteofpaws.common.lib.Resources;
import dtnpaletteofpaws.common.util.RandomUtil;
import dtnpaletteofpaws.common.util.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class WitheredSoulDogVariant
extends DogVariant
implements IDogAlteration {
    public WitheredSoulDogVariant(String name) {
        super(DogVariant.props((ResourceLocation)Util.getResource(name)).customTexture(Util.modifyPath(Util.getResource(name), x -> "textures/entity/dtnwolf/variants/wolf_" + x)).glowingOverlay(Resources.getDTNWolfTexture("variants/wolf_withered_soul_overlay")).customTranslation("dtnpaletteofpaws.variant." + name).guiColor(-16668756).burnsPetter().preventWetShade());
    }

    public void props(AbstractDog dog, DogAlterationProps props) {
        props.setFireImmune();
        props.setFallImmune();
    }

    public void tick(AbstractDog dog) {
        SimpleParticleType type;
        if (!dog.level().isClientSide) {
            return;
        }
        if (!((Boolean)ConfigHandler.CLIENT.DOG_VARIANT_CLIENT_EFFECT.get()).booleanValue()) {
            return;
        }
        if (!dog.level().isClientSide) {
            return;
        }
        RandomSource random = dog.getRandom();
        Level level = dog.level();
        if (dog.getRandom().nextInt(3) == 0 && (type = ParticleTypes.SOUL_FIRE_FLAME) != null) {
            double d0 = dog.getX() + (double)(RandomUtil.nextFloatRemapped(random) * (dog.getBbWidth() / 2.0f));
            double d1 = dog.getY() + (double)dog.getBbHeight();
            double d2 = dog.getZ() + (double)(RandomUtil.nextFloatRemapped(random) * (dog.getBbWidth() / 2.0f));
            level.addParticle((ParticleOptions)type, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

