/*
 * Decompiled with CFR 0.152.
 */
package confusedalex.thegoldeconomy.libs.co.aikar.commands;

import confusedalex.thegoldeconomy.libs.co.aikar.commands.ACFBukkitUtil;
import confusedalex.thegoldeconomy.libs.co.aikar.commands.BukkitCommandManager;
import confusedalex.thegoldeconomy.libs.co.aikar.commands.CommandIssuer;
import confusedalex.thegoldeconomy.libs.co.aikar.commands.CommandManager;
import confusedalex.thegoldeconomy.libs.org.jetbrains.annotations.NotNull;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitCommandIssuer
implements CommandIssuer {
    private final BukkitCommandManager manager;
    private final CommandSender sender;

    protected BukkitCommandIssuer(BukkitCommandManager manager, CommandSender sender) {
        this.manager = manager;
        this.sender = sender;
    }

    @Override
    public boolean isPlayer() {
        return this.sender instanceof Player;
    }

    public CommandSender getIssuer() {
        return this.sender;
    }

    public Player getPlayer() {
        return this.isPlayer() ? (Player)this.sender : null;
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        if (this.isPlayer()) {
            return ((Player)this.sender).getUniqueId();
        }
        return UUID.nameUUIDFromBytes(this.sender.getName().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public CommandManager getManager() {
        return this.manager;
    }

    @Override
    public void sendMessageInternal(String message) {
        this.sender.sendMessage(ACFBukkitUtil.color(message));
    }

    @Override
    public boolean hasPermission(String name) {
        return this.sender.hasPermission(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BukkitCommandIssuer that = (BukkitCommandIssuer)o;
        return Objects.equals(this.sender, that.sender);
    }

    public int hashCode() {
        return Objects.hash(this.sender);
    }
}

