/*
 * Decompiled with CFR 0.152.
 */
package dev.confusedalex.thegoldeconomy;

import confusedalex.thegoldeconomy.libs.co.aikar.commands.BaseCommand;
import confusedalex.thegoldeconomy.libs.co.aikar.commands.CommandHelp;
import confusedalex.thegoldeconomy.libs.co.aikar.commands.annotation.CommandAlias;
import confusedalex.thegoldeconomy.libs.co.aikar.commands.annotation.CommandPermission;
import confusedalex.thegoldeconomy.libs.co.aikar.commands.annotation.Description;
import confusedalex.thegoldeconomy.libs.co.aikar.commands.annotation.HelpCommand;
import confusedalex.thegoldeconomy.libs.co.aikar.commands.annotation.Subcommand;
import confusedalex.thegoldeconomy.libs.kotlin.Metadata;
import confusedalex.thegoldeconomy.libs.kotlin.jvm.internal.Intrinsics;
import confusedalex.thegoldeconomy.libs.org.jetbrains.annotations.NotNull;
import confusedalex.thegoldeconomy.libs.org.jetbrains.annotations.Nullable;
import dev.confusedalex.thegoldeconomy.Bank;
import dev.confusedalex.thegoldeconomy.Base;
import dev.confusedalex.thegoldeconomy.Converter;
import dev.confusedalex.thegoldeconomy.EconomyImplementer;
import dev.confusedalex.thegoldeconomy.TheGoldEconomy;
import dev.confusedalex.thegoldeconomy.Util;
import java.util.Arrays;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

@CommandAlias(value="bank")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0018H\u0007J\u001c\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0007J \u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0007J\u001c\u0010\"\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0001\u0010#\u001a\u0004\u0018\u00010$H\u0007J\u001c\u0010%\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0001\u0010#\u001a\u0004\u0018\u00010$H\u0007J\"\u0010&\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020!H\u0007J\"\u0010(\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020!H\u0007J\"\u0010)\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020!H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006*"}, d2={"Ldev/confusedalex/thegoldeconomy/BankCommand;", "Lconfusedalex/thegoldeconomy/libs/co/aikar/commands/BaseCommand;", "plugin", "Ldev/confusedalex/thegoldeconomy/TheGoldEconomy;", "<init>", "(Ldev/confusedalex/thegoldeconomy/TheGoldEconomy;)V", "bundle", "Ljava/util/ResourceBundle;", "eco", "Ldev/confusedalex/thegoldeconomy/EconomyImplementer;", "util", "Ldev/confusedalex/thegoldeconomy/Util;", "getUtil", "()Ldev/confusedalex/thegoldeconomy/Util;", "setUtil", "(Ldev/confusedalex/thegoldeconomy/Util;)V", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "getConfig", "()Lorg/bukkit/configuration/file/FileConfiguration;", "setConfig", "(Lorg/bukkit/configuration/file/FileConfiguration;)V", "help", "", "Lconfusedalex/thegoldeconomy/libs/co/aikar/commands/CommandHelp;", "balance", "commandSender", "Lorg/bukkit/command/CommandSender;", "player", "Lorg/bukkit/OfflinePlayer;", "pay", "target", "amount", "", "deposit", "nuggets", "", "withdraw", "set", "gold", "add", "remove", "GoldEconomy"})
public final class BankCommand
extends BaseCommand {
    @NotNull
    private ResourceBundle bundle;
    @NotNull
    private EconomyImplementer eco;
    @NotNull
    private Util util;
    @NotNull
    private FileConfiguration config;

    public BankCommand(@NotNull TheGoldEconomy plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        ResourceBundle resourceBundle = plugin.eco.bundle;
        Intrinsics.checkNotNullExpressionValue(resourceBundle, "bundle");
        this.bundle = resourceBundle;
        EconomyImplementer economyImplementer = plugin.eco;
        Intrinsics.checkNotNullExpressionValue(economyImplementer, "eco");
        this.eco = economyImplementer;
        Util util = plugin.util;
        Intrinsics.checkNotNullExpressionValue(util, "util");
        this.util = util;
        FileConfiguration fileConfiguration = plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        this.config = fileConfiguration;
    }

    @NotNull
    public final Util getUtil() {
        return this.util;
    }

    public final void setUtil(@NotNull Util util) {
        Intrinsics.checkNotNullParameter(util, "<set-?>");
        this.util = util;
    }

    @NotNull
    public final FileConfiguration getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull FileConfiguration fileConfiguration) {
        Intrinsics.checkNotNullParameter(fileConfiguration, "<set-?>");
        this.config = fileConfiguration;
    }

    @HelpCommand
    public final void help(@NotNull CommandHelp help) {
        Intrinsics.checkNotNullParameter(help, "help");
        help.showHelp();
    }

    @Subcommand(value="balance")
    @CommandAlias(value="balance")
    @Description(value="{@@command.info.balance}")
    @CommandPermission(value="thegoldeconomy.balance")
    public final void balance(@NotNull CommandSender commandSender, @confusedalex.thegoldeconomy.libs.co.aikar.commands.annotation.Optional @Nullable OfflinePlayer player) {
        Intrinsics.checkNotNullParameter(commandSender, "commandSender");
        Optional<Player> senderOptional = this.util.isPlayer(commandSender);
        if (senderOptional.isEmpty()) {
            return;
        }
        Player player2 = senderOptional.get();
        Intrinsics.checkNotNullExpressionValue(player2, "get(...)");
        Player sender = player2;
        UUID uUID = sender.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        if (player == null) {
            String string = this.bundle.getString("info.balance");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String string2 = string;
            Object[] objectArray = new Object[3];
            objectArray[0] = this.util.colorCurrency((int)this.eco.getBalance(uuid.toString()));
            objectArray[1] = this.util.colorCurrency(this.eco.bank.getAccountBalance(uuid));
            Converter converter = this.eco.converter;
            Base base = TheGoldEconomy.base;
            Intrinsics.checkNotNullExpressionValue((Object)base, "base");
            objectArray[2] = this.util.colorCurrency(converter.getInventoryValue(sender, base));
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            sender.sendMessage(this.util.formatMessage(string3));
        } else if (sender.hasPermission("thegoldeconomy.balance.others")) {
            String string = this.bundle.getString("info.balance.other");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String string4 = string;
            Object[] objectArray = new Object[]{player.getName(), this.util.colorCurrency((int)this.eco.getBalance(player))};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
            sender.sendMessage(this.util.formatMessage(string5));
        } else {
            String string = this.bundle.getString("error.noPermission");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            sender.sendMessage(this.util.formatMessage(string));
        }
    }

    @Subcommand(value="pay")
    @Description(value="{@@command.info.pay}")
    @CommandPermission(value="thegoldeconomy.pay")
    public final void pay(@NotNull CommandSender commandSender, @NotNull OfflinePlayer target, int amount) {
        Intrinsics.checkNotNullParameter(commandSender, "commandSender");
        Intrinsics.checkNotNullParameter(target, "target");
        Optional<Player> playerOptional = this.util.isPlayer(commandSender);
        if (playerOptional.isEmpty()) {
            return;
        }
        Player player = playerOptional.get();
        Intrinsics.checkNotNullExpressionValue(player, "get(...)");
        Player sender = player;
        UUID uUID = sender.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID senderuuid = uUID;
        UUID uUID2 = target.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        UUID targetuuid = uUID2;
        if (this.util.isBankingRestrictedToPlot(sender)) {
            return;
        }
        if (amount == 0) {
            String string = this.bundle.getString("error.zero");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            sender.sendMessage(this.util.formatMessage(string));
            return;
        }
        if (amount < 0) {
            String string = this.bundle.getString("error.negative");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            sender.sendMessage(this.util.formatMessage(string));
            return;
        }
        if (amount > this.eco.bank.getTotalPlayerBalance(senderuuid)) {
            String string = this.bundle.getString("error.notEnough");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            sender.sendMessage(this.util.formatMessage(string));
            return;
        }
        if (Intrinsics.areEqual(senderuuid, targetuuid)) {
            String string = this.bundle.getString("error.payYourself");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            sender.sendMessage(this.util.formatMessage(string));
            return;
        }
        if (this.util.isOfflinePlayer(String.valueOf(target.getName())).isEmpty()) {
            String string = this.bundle.getString("error.noPlayer");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            sender.sendMessage(this.util.formatMessage(string));
            return;
        }
        this.eco.withdrawPlayer((OfflinePlayer)sender, (double)amount);
        String string = this.bundle.getString("info.sendMoneyTo");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = string;
        Object object = new Object[]{this.util.colorCurrency(amount), target.getName()};
        String string3 = String.format(string2, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        sender.sendMessage(this.util.formatMessage(string3));
        if (target.isOnline()) {
            Player player2 = Bukkit.getPlayer((UUID)target.getUniqueId());
            if (player2 != null) {
                String string4 = this.bundle.getString("info.moneyReceived");
                Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
                object = string4;
                Object[] objectArray = new Object[]{this.util.colorCurrency(amount), sender.getName()};
                String string5 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
                player2.sendMessage(this.util.formatMessage(string5));
            }
            Bank bank = this.eco.bank;
            UUID uUID3 = target.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
            bank.setAccountBalance(uUID3, this.eco.bank.getAccountBalance(targetuuid) + amount);
        } else {
            this.eco.depositPlayer(target, (double)amount);
        }
    }

    @Subcommand(value="deposit")
    @Description(value="{@@command.info.deposit}")
    @CommandPermission(value="thegoldeconomy.deposit")
    public final void deposit(@NotNull CommandSender commandSender, @confusedalex.thegoldeconomy.libs.co.aikar.commands.annotation.Optional @Nullable String nuggets) {
        Intrinsics.checkNotNullParameter(commandSender, "commandSender");
        Optional<Player> playerOptional = this.util.isPlayer(commandSender);
        if (playerOptional.isEmpty()) {
            return;
        }
        Player player = playerOptional.get();
        Intrinsics.checkNotNullExpressionValue(player, "get(...)");
        Player player2 = player;
        Converter converter = this.eco.converter;
        Base base = TheGoldEconomy.base;
        Intrinsics.checkNotNullExpressionValue((Object)base, "base");
        int inventoryValue = converter.getInventoryValue(player2, base);
        if (this.util.isBankingRestrictedToPlot(player2)) {
            return;
        }
        if (nuggets == null || Intrinsics.areEqual(nuggets, "all")) {
            if (inventoryValue <= 0) {
                String string = this.bundle.getString("error.zero");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                player2.sendMessage(this.util.formatMessage(string));
                return;
            }
            String string = this.bundle.getString("info.deposit");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String string2 = string;
            Object[] objectArray = new Object[]{this.util.colorCurrency(inventoryValue)};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            player2.sendMessage(this.util.formatMessage(string3));
            Converter converter2 = this.eco.converter;
            Base base2 = TheGoldEconomy.base;
            Intrinsics.checkNotNullExpressionValue((Object)base2, "base");
            converter2.deposit(player2, inventoryValue, base2);
            return;
        }
        int amount = 0;
        try {
            amount = Integer.parseInt(nuggets);
        }
        catch (NumberFormatException e) {
            this.getCommandHelp().showHelp();
            return;
        }
        if (amount == 0) {
            String string = this.bundle.getString("error.zero");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            player2.sendMessage(this.util.formatMessage(string));
        } else if (amount < 0) {
            String string = this.bundle.getString("error.negative");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            player2.sendMessage(this.util.formatMessage(string));
        } else if (amount > inventoryValue) {
            String string = this.bundle.getString("error.notEnough");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            player2.sendMessage(this.util.formatMessage(string));
        } else {
            String string = this.bundle.getString("info.deposit");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String string4 = string;
            Object[] objectArray = new Object[]{this.util.colorCurrency(amount)};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
            player2.sendMessage(this.util.formatMessage(string5));
            Converter converter3 = this.eco.converter;
            int n = Integer.parseInt(nuggets);
            Base base3 = TheGoldEconomy.base;
            Intrinsics.checkNotNullExpressionValue((Object)base3, "base");
            converter3.deposit(player2, n, base3);
        }
    }

    @Subcommand(value="withdraw")
    @Description(value="{@@command.info.withdraw}")
    @CommandPermission(value="thegoldeconomy.withdraw")
    public final void withdraw(@NotNull CommandSender commandSender, @confusedalex.thegoldeconomy.libs.co.aikar.commands.annotation.Optional @Nullable String nuggets) {
        Intrinsics.checkNotNullParameter(commandSender, "commandSender");
        Optional<Player> playerOptional = this.util.isPlayer(commandSender);
        if (playerOptional.isEmpty()) {
            return;
        }
        Player player = playerOptional.get();
        Intrinsics.checkNotNullExpressionValue(player, "get(...)");
        Player player2 = player;
        if (this.util.isBankingRestrictedToPlot(player2)) {
            return;
        }
        if (nuggets == null || Intrinsics.areEqual(nuggets, "all")) {
            Bank bank = this.eco.bank;
            UUID uUID = player2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            int accountBalance = bank.getAccountBalance(uUID);
            String string = this.bundle.getString("info.withdraw");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String string2 = string;
            Object[] objectArray = new Object[]{this.util.colorCurrency(accountBalance)};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            player2.sendMessage(this.util.formatMessage(string3));
            Converter converter = this.eco.converter;
            Bank bank2 = this.eco.bank;
            UUID uUID2 = player2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            int n = bank2.getAccountBalance(uUID2);
            Base base = TheGoldEconomy.base;
            Intrinsics.checkNotNullExpressionValue((Object)base, "base");
            converter.withdraw(player2, n, base);
            return;
        }
        int amount = 0;
        try {
            amount = Integer.parseInt(nuggets);
        }
        catch (NumberFormatException e) {
            this.getCommandHelp().showHelp();
            return;
        }
        if (amount == 0) {
            String string = this.bundle.getString("error.zero");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            player2.sendMessage(this.util.formatMessage(string));
        } else if (amount < 0) {
            String string = this.bundle.getString("error.negative");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            player2.sendMessage(this.util.formatMessage(string));
        } else {
            Bank bank = this.eco.bank;
            UUID uUID = player2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            if (amount > bank.getAccountBalance(uUID)) {
                String string = this.bundle.getString("error.notEnough");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                player2.sendMessage(this.util.formatMessage(string));
            } else {
                String string = this.bundle.getString("info.withdraw");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String string4 = string;
                Object[] objectArray = new Object[]{this.util.colorCurrency(amount)};
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
                player2.sendMessage(this.util.formatMessage(string5));
                Converter converter = this.eco.converter;
                Base base = TheGoldEconomy.base;
                Intrinsics.checkNotNullExpressionValue((Object)base, "base");
                converter.withdraw(player2, amount, base);
            }
        }
    }

    @Subcommand(value="set")
    @CommandPermission(value="thegoldeconomy.set")
    @Description(value="{@@command.info.set}")
    public final void set(@Nullable CommandSender commandSender, @NotNull OfflinePlayer target, int gold) {
        block3: {
            Object object;
            Intrinsics.checkNotNullParameter(target, "target");
            if (gold < 0) {
                CommandSender commandSender2 = commandSender;
                if (commandSender2 != null) {
                    String string = this.bundle.getString("error.negative");
                    Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                    String string2 = string;
                    Object[] objectArray = new Object[]{target.getName(), this.util.colorCurrency(gold)};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                    commandSender2.sendMessage(this.util.formatMessage(string3));
                }
                return;
            }
            CommandSender commandSender3 = commandSender;
            if (commandSender3 != null) {
                String string = this.bundle.getString("info.sender.moneyset");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String string4 = string;
                object = new Object[]{target.getName(), this.util.colorCurrency(gold)};
                String string5 = String.format(string4, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
                commandSender3.sendMessage(this.util.formatMessage(string5));
            }
            Bank bank = this.eco.bank;
            UUID uUID = target.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            bank.setAccountBalance(uUID, gold);
            Player player = Bukkit.getPlayer((UUID)target.getUniqueId());
            if (player == null) break block3;
            String string = this.bundle.getString("info.target.moneySet");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            object = string;
            Object[] objectArray = new Object[]{this.util.colorCurrency(gold)};
            String string6 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string6, "format(...)");
            player.sendMessage(this.util.formatMessage(string6));
        }
    }

    @Subcommand(value="add")
    @CommandPermission(value="thegoldeconomy.add")
    @Description(value="{@@command.info.add}")
    public final void add(@Nullable CommandSender commandSender, @NotNull OfflinePlayer target, int gold) {
        block1: {
            Object object;
            Intrinsics.checkNotNullParameter(target, "target");
            CommandSender commandSender2 = commandSender;
            if (commandSender2 != null) {
                String string = this.bundle.getString("info.sender.addmoney");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String string2 = string;
                object = new Object[]{this.util.colorCurrency(gold), target.getName()};
                String string3 = String.format(string2, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                commandSender2.sendMessage(this.util.formatMessage(string3));
            }
            this.eco.depositPlayer(target, (double)gold);
            Player player = Bukkit.getPlayer((UUID)target.getUniqueId());
            if (player == null) break block1;
            String string = this.bundle.getString("info.target.addMoney");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            object = string;
            Object[] objectArray = new Object[]{this.util.colorCurrency(gold)};
            String string4 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
            player.sendMessage(this.util.formatMessage(string4));
        }
    }

    @Subcommand(value="remove")
    @CommandPermission(value="thegoldeconomy.remove")
    @Description(value="{@@command.info.remove}")
    public final void remove(@Nullable CommandSender commandSender, @NotNull OfflinePlayer target, int gold) {
        block1: {
            Object object;
            Intrinsics.checkNotNullParameter(target, "target");
            CommandSender commandSender2 = commandSender;
            if (commandSender2 != null) {
                String string = this.bundle.getString("info.sender.remove");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String string2 = string;
                object = new Object[]{this.util.colorCurrency(gold), target.getName()};
                String string3 = String.format(string2, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                commandSender2.sendMessage(this.util.formatMessage(string3));
            }
            this.eco.withdrawPlayer(target, (double)gold);
            Player player = Bukkit.getPlayer((UUID)target.getUniqueId());
            if (player == null) break block1;
            String string = this.bundle.getString("info.target.remove");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            object = string;
            Object[] objectArray = new Object[]{this.util.colorCurrency(gold)};
            String string4 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
            player.sendMessage(this.util.formatMessage(string4));
        }
    }
}

