/*
 * Decompiled with CFR 0.152.
 */
package dev.confusedalex.thegoldeconomy;

import confusedalex.thegoldeconomy.libs.kotlin.Metadata;
import confusedalex.thegoldeconomy.libs.kotlin.NoWhenBranchMatchedException;
import confusedalex.thegoldeconomy.libs.kotlin.collections.CollectionsKt;
import confusedalex.thegoldeconomy.libs.kotlin.jvm.internal.Intrinsics;
import confusedalex.thegoldeconomy.libs.kotlin.jvm.internal.SourceDebugExtension;
import confusedalex.thegoldeconomy.libs.org.jetbrains.annotations.NotNull;
import confusedalex.thegoldeconomy.libs.org.jetbrains.annotations.Nullable;
import dev.confusedalex.thegoldeconomy.Bank;
import dev.confusedalex.thegoldeconomy.Base;
import dev.confusedalex.thegoldeconomy.EconomyImplementer;
import dev.confusedalex.thegoldeconomy.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0018\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010 \u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Ldev/confusedalex/thegoldeconomy/Converter;", "", "eco", "Ldev/confusedalex/thegoldeconomy/EconomyImplementer;", "bundle", "Ljava/util/ResourceBundle;", "<init>", "(Ldev/confusedalex/thegoldeconomy/EconomyImplementer;Ljava/util/ResourceBundle;)V", "getEco", "()Ldev/confusedalex/thegoldeconomy/EconomyImplementer;", "setEco", "(Ldev/confusedalex/thegoldeconomy/EconomyImplementer;)V", "getBundle", "()Ljava/util/ResourceBundle;", "setBundle", "(Ljava/util/ResourceBundle;)V", "getValue", "", "material", "Lorg/bukkit/Material;", "base", "Ldev/confusedalex/thegoldeconomy/Base;", "isGold", "", "getInventoryValue", "player", "Lorg/bukkit/entity/Player;", "remove", "", "amount", "give", "value", "withdraw", "nuggets", "deposit", "GoldEconomy"})
@SourceDebugExtension(value={"SMAP\nConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Converter.kt\ndev/confusedalex/thegoldeconomy/Converter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n774#2:149\n865#2,2:150\n774#2:152\n865#2,2:153\n774#2:156\n865#2,2:157\n1869#2,2:159\n1#3:155\n*S KotlinDebug\n*F\n+ 1 Converter.kt\ndev/confusedalex/thegoldeconomy/Converter\n*L\n45#1:149\n45#1:150,2\n46#1:152\n46#1:153,2\n54#1:156\n54#1:157,2\n54#1:159,2\n*E\n"})
public final class Converter {
    @NotNull
    private EconomyImplementer eco;
    @NotNull
    private ResourceBundle bundle;

    public Converter(@NotNull EconomyImplementer eco, @NotNull ResourceBundle bundle) {
        Intrinsics.checkNotNullParameter(eco, "eco");
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        this.eco = eco;
        this.bundle = bundle;
    }

    @NotNull
    public final EconomyImplementer getEco() {
        return this.eco;
    }

    public final void setEco(@NotNull EconomyImplementer economyImplementer) {
        Intrinsics.checkNotNullParameter(economyImplementer, "<set-?>");
        this.eco = economyImplementer;
    }

    @NotNull
    public final ResourceBundle getBundle() {
        return this.bundle;
    }

    public final void setBundle(@NotNull ResourceBundle resourceBundle) {
        Intrinsics.checkNotNullParameter(resourceBundle, "<set-?>");
        this.bundle = resourceBundle;
    }

    public final int getValue(@Nullable Material material, @NotNull Base base) {
        Intrinsics.checkNotNullParameter((Object)base, "base");
        return switch (WhenMappings.$EnumSwitchMapping$1[base.ordinal()]) {
            case 1 -> {
                Material v0 = material;
                switch (v0 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                    case 1: {
                        yield 1;
                    }
                    case 2: {
                        yield 9;
                    }
                    case 3: {
                        yield 81;
                    }
                }
                yield 0;
            }
            case 2 -> {
                Material v2 = material;
                switch (v2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v2.ordinal()]) {
                    case 2: {
                        yield 1;
                    }
                    case 3: {
                        yield 9;
                    }
                }
                yield 0;
            }
            case 3 -> {
                Material v3 = material;
                switch (v3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v3.ordinal()]) {
                    case 4: {
                        yield 1;
                    }
                    case 5: {
                        yield 9;
                    }
                }
                yield 0;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean isGold(@Nullable Material material, @NotNull Base base) {
        Intrinsics.checkNotNullParameter((Object)base, "base");
        return switch (WhenMappings.$EnumSwitchMapping$1[base.ordinal()]) {
            case 1, 2 -> {
                Material v0 = material;
                switch (v0 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        yield true;
                    }
                }
                yield false;
            }
            case 3 -> {
                Material v2 = material;
                switch (v2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v2.ordinal()]) {
                    case 4: 
                    case 5: {
                        yield true;
                    }
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    public final int getInventoryValue(@Nullable Player player, @NotNull Base base) {
        int n;
        PlayerInventory playerInventory;
        Intrinsics.checkNotNullParameter((Object)base, "base");
        if (player != null && (playerInventory = player.getInventory()) != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            Iterable iterable = (Iterable)playerInventory;
            boolean $i$f$filter22 = false;
            void var6_7 = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                ItemStack it = (ItemStack)element$iv$iv;
                boolean bl = false;
                if (!(it != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ItemStack it = (ItemStack)element$iv$iv;
                boolean bl = false;
                if (!this.isGold(it.getType(), base)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv2;
            int n2 = 0;
            for (Object t : iterable2) {
                void it;
                Object element$iv$iv;
                element$iv$iv = (ItemStack)t;
                int n3 = n2;
                boolean bl = false;
                int n4 = this.getValue(it.getType(), base) * it.getAmount();
                n2 = n3 + n4;
            }
            n = n2;
        } else {
            n = 0;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final void remove(@NotNull Player player, int amount, @NotNull Base base) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)base, "base");
        int value = this.getInventoryValue(player, base);
        if (value < amount) {
            return;
        }
        PlayerInventory playerInventory = player.getInventory();
        Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
        Iterable $this$filter$iv = CollectionsKt.filterNotNull((Iterable)playerInventory);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack it = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!(this.getValue(it.getType(), base) > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack item = (ItemStack)element$iv;
            boolean bl = false;
            item.setAmount(0);
            item.setType(Material.AIR);
        }
        int newBalance = value - amount;
        this.give(player, newBalance, base);
    }

    public final void give(@NotNull Player player, int value, @NotNull Base base) {
        ItemStack item2;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)base, "base");
        int value2 = value;
        boolean warning = false;
        int blockValue = 0;
        int ingotValue = 0;
        Material block = null;
        Material ingot = null;
        switch (WhenMappings.$EnumSwitchMapping$1[base.ordinal()]) {
            case 1: 
            case 2: {
                block = Material.GOLD_BLOCK;
                ingot = Material.GOLD_INGOT;
                break;
            }
            case 3: {
                block = Material.RAW_GOLD_BLOCK;
                ingot = Material.RAW_GOLD;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        blockValue = this.getValue(block, base);
        ingotValue = this.getValue(ingot, base);
        player.getInventory().setMaxStackSize(64);
        if (value2 / blockValue > 0) {
            objectArray = new ItemStack[]{new ItemStack(block, value2 / blockValue)};
            HashMap hashMap = player.getInventory().addItem(objectArray);
            Intrinsics.checkNotNullExpressionValue(hashMap, "addItem(...)");
            HashMap blocks = hashMap;
            for (ItemStack item2 : blocks.values()) {
                if (item2 == null || item2.getType() != block || item2.getAmount() <= 0) continue;
                player.getWorld().dropItem(player.getLocation(), item2);
                warning = true;
            }
        }
        if ((value2 -= value2 / blockValue * blockValue) / ingotValue > 0) {
            item2 = new ItemStack[]{new ItemStack(ingot, value2 / ingotValue)};
            HashMap hashMap = player.getInventory().addItem((ItemStack[])item2);
            Intrinsics.checkNotNullExpressionValue(hashMap, "addItem(...)");
            HashMap ingots = hashMap;
            for (ItemStack item2 : ingots.values()) {
                if (item2 == null || item2.getType() != ingot || item2.getAmount() <= 0) continue;
                player.getWorld().dropItem(player.getLocation(), item2);
                warning = true;
            }
        }
        value2 -= value2 / ingotValue * ingotValue;
        if (base == Base.NUGGETS && value2 > 0) {
            item2 = new ItemStack[]{new ItemStack(Material.GOLD_NUGGET, value2)};
            HashMap hashMap = player.getInventory().addItem((ItemStack[])item2);
            Intrinsics.checkNotNullExpressionValue(hashMap, "addItem(...)");
            HashMap nuggets = hashMap;
            for (ItemStack item2 : nuggets.values()) {
                if (item2 == null || item2.getType() != Material.GOLD_NUGGET || item2.getAmount() <= 0) continue;
                player.getWorld().dropItem(player.getLocation(), item2);
                warning = true;
            }
        }
        if (warning) {
            Util util = this.eco.util;
            String string = this.bundle.getString("warning.drops");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            Iterator iterator2 = string;
            objectArray = new Object[]{};
            String string2 = String.format(iterator2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            player.sendMessage(util.formatMessage(string2));
        }
    }

    public final void withdraw(@NotNull Player player, int nuggets, @NotNull Base base) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)base, "base");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        Bank bank = this.eco.bank;
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        int oldBalance = bank.getAccountBalance(uUID2);
        if (nuggets > this.eco.bank.getAccountBalance(uuid)) {
            Util util = this.eco.util;
            String string = this.bundle.getString("error.notEnoughMoneyWithdraw");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            player.sendMessage(util.formatMessage(string));
            return;
        }
        this.eco.bank.setAccountBalance(uuid, oldBalance - nuggets);
        this.give(player, nuggets, base);
    }

    public final void deposit(@NotNull Player player, int nuggets, @NotNull Base base) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)base, "base");
        if (nuggets <= 0) {
            return;
        }
        if (this.getInventoryValue(player, base) < nuggets) {
            return;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)player.getUniqueId());
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer op = offlinePlayer;
        this.remove(player, nuggets, base);
        this.eco.depositPlayer(op, (double)nuggets);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Material.values().length];
            try {
                nArray[Material.GOLD_NUGGET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.GOLD_INGOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.GOLD_BLOCK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.RAW_GOLD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.RAW_GOLD_BLOCK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Base.values().length];
            try {
                nArray[Base.NUGGETS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Base.INGOTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Base.RAW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

