/*
 * Decompiled with CFR 0.152.
 */
package dev.confusedalex.thegoldeconomy;

import dev.confusedalex.thegoldeconomy.Bank;
import dev.confusedalex.thegoldeconomy.Converter;
import dev.confusedalex.thegoldeconomy.TheGoldEconomy;
import dev.confusedalex.thegoldeconomy.Util;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class EconomyImplementer
implements Economy {
    TheGoldEconomy plugin;
    Bank bank;
    Converter converter;
    ResourceBundle bundle;
    Util util;

    public EconomyImplementer(TheGoldEconomy plugin, ResourceBundle bundle, Util util) {
        this.plugin = plugin;
        this.bundle = bundle;
        this.util = util;
        this.converter = new Converter(this, bundle);
        this.bank = new Bank(this.converter);
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return "TheGoldEconomy";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return 0;
    }

    public String format(double v) {
        return v + " Gold";
    }

    public String currencyNamePlural() {
        return "Gold";
    }

    public String currencyNameSingular() {
        return "Gold";
    }

    public boolean hasAccount(String s) {
        if (this.util.isOfflinePlayer(s).isPresent()) {
            return true;
        }
        if (this.bank.getFakeAccounts().containsKey(s)) {
            return true;
        }
        this.bank.setFakeAccountBalance(s, 0);
        return true;
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer) {
        return true;
    }

    public boolean hasAccount(String s, String s1) {
        if (this.util.isOfflinePlayer(s).isPresent()) {
            return true;
        }
        if (this.bank.getFakeAccounts().containsKey(s)) {
            return true;
        }
        this.bank.setFakeAccountBalance(s, 0);
        return true;
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer, String s) {
        return true;
    }

    public double getBalance(String s) {
        try {
            UUID uuid = UUID.fromString(s);
            if (Bukkit.getPlayer((UUID)uuid) != null) {
                return this.bank.getTotalPlayerBalance(uuid);
            }
        }
        catch (IllegalArgumentException uuid) {
            // empty catch block
        }
        Optional<OfflinePlayer> playerOptional = this.util.isOfflinePlayer(s);
        return playerOptional.map(offlinePlayer -> this.bank.getTotalPlayerBalance(offlinePlayer.getUniqueId())).orElseGet(() -> this.bank.getFakeBalance(s)).intValue();
    }

    public double getBalance(OfflinePlayer offlinePlayer) {
        if (offlinePlayer != null) {
            return this.bank.getTotalPlayerBalance(offlinePlayer.getUniqueId());
        }
        return 0.0;
    }

    public double getBalance(String s, String s1) {
        try {
            UUID uuid = UUID.fromString(s);
            if (Bukkit.getPlayer((UUID)uuid) != null) {
                return this.bank.getTotalPlayerBalance(uuid);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.util.isOfflinePlayer(s).isPresent()) {
            return this.bank.getTotalPlayerBalance(Bukkit.getOfflinePlayer((String)s).getUniqueId());
        }
        return this.bank.getFakeBalance(s);
    }

    public double getBalance(OfflinePlayer offlinePlayer, String s) {
        if (offlinePlayer != null) {
            return this.bank.getTotalPlayerBalance(offlinePlayer.getUniqueId());
        }
        return 0.0;
    }

    public boolean has(String s, double v) {
        if (this.util.isOfflinePlayer(s).isPresent()) {
            return v < (double)this.bank.getTotalPlayerBalance(Bukkit.getOfflinePlayer((String)s).getUniqueId());
        }
        return v < (double)this.bank.getFakeBalance(s);
    }

    public boolean has(OfflinePlayer offlinePlayer, double v) {
        return v < (double)this.bank.getTotalPlayerBalance(offlinePlayer.getUniqueId());
    }

    public boolean has(String s, String s1, double v) {
        if (this.util.isOfflinePlayer(s).isPresent()) {
            return v < (double)this.bank.getTotalPlayerBalance(Bukkit.getOfflinePlayer((String)s).getUniqueId());
        }
        return v < (double)this.bank.getFakeBalance(s);
    }

    public boolean has(OfflinePlayer offlinePlayer, String s, double v) {
        return v < (double)this.bank.getTotalPlayerBalance(offlinePlayer.getUniqueId());
    }

    public EconomyResponse withdrawPlayer(String s, double amount) {
        int oldBalance = 0;
        if (amount < 0.0) {
            return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "error");
        }
        Optional<OfflinePlayer> playerOptional = this.util.isOfflinePlayer(s);
        if (playerOptional.isPresent()) {
            OfflinePlayer offlinePlayer = playerOptional.get();
            UUID uuid = offlinePlayer.getUniqueId();
            if (offlinePlayer.isOnline()) {
                int oldInventoryBalance;
                Player player = offlinePlayer.getPlayer();
                if (player == null) {
                    return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "error");
                }
                int oldBankBalance = this.bank.getAccountBalance(uuid);
                if (amount > (double)(oldBankBalance + (oldInventoryBalance = this.converter.getInventoryValue(player, TheGoldEconomy.base)))) {
                    return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "Not enough Money!");
                }
                if ((double)oldBankBalance - amount > 0.0) {
                    this.bank.setAccountBalance(uuid, (int)((double)oldBankBalance - amount));
                    return new EconomyResponse(amount, (double)oldBankBalance - amount, EconomyResponse.ResponseType.SUCCESS, "");
                }
                int diff = (int)(amount - (double)oldBankBalance);
                this.bank.setAccountBalance(uuid, 0);
                this.converter.remove(player, diff, TheGoldEconomy.base);
                return new EconomyResponse(amount, (double)oldInventoryBalance - amount, EconomyResponse.ResponseType.SUCCESS, "");
            }
            oldBalance = this.bank.getTotalPlayerBalance(uuid);
            int newBalance = (int)((double)oldBalance - amount);
            this.bank.setAccountBalance(uuid, newBalance);
            return new EconomyResponse(amount, (double)newBalance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        oldBalance = this.bank.getFakeBalance(s);
        int newBalance = (int)((double)oldBalance - amount);
        this.bank.setFakeAccountBalance(s, newBalance);
        return new EconomyResponse(amount, (double)newBalance, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, double amount) {
        UUID uuid = offlinePlayer.getUniqueId();
        int oldBalance = 0;
        if (amount < 0.0) {
            return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "error");
        }
        if (offlinePlayer.isOnline()) {
            int oldInventoryBalance;
            Player player = offlinePlayer.getPlayer();
            if (player == null) {
                return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "error");
            }
            int oldBankBalance = this.bank.getAccountBalance(uuid);
            if (amount > (double)(oldBankBalance + (oldInventoryBalance = this.converter.getInventoryValue(player, TheGoldEconomy.base)))) {
                return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "error");
            }
            if ((double)oldBankBalance - amount > 0.0) {
                this.bank.setAccountBalance(uuid, (int)((double)oldBankBalance - amount));
                return new EconomyResponse(amount, (double)oldBankBalance - amount, EconomyResponse.ResponseType.SUCCESS, "");
            }
            int diff = (int)(amount - (double)oldBankBalance);
            this.bank.setAccountBalance(uuid, 0);
            this.converter.remove(player, diff, TheGoldEconomy.base);
            return new EconomyResponse(amount, (double)oldInventoryBalance - amount, EconomyResponse.ResponseType.SUCCESS, "");
        }
        oldBalance = this.bank.getTotalPlayerBalance(uuid);
        int newBalance = (int)((double)oldBalance - amount);
        this.bank.setAccountBalance(uuid, newBalance);
        return new EconomyResponse(amount, (double)newBalance, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse withdrawPlayer(String s, String s1, double amount) {
        int oldBalance = 0;
        if (amount < 0.0) {
            return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "error");
        }
        Optional<OfflinePlayer> playerOptional = this.util.isOfflinePlayer(s);
        if (playerOptional.isPresent()) {
            OfflinePlayer offlinePlayer = playerOptional.get();
            UUID uuid = offlinePlayer.getUniqueId();
            if (offlinePlayer.isOnline()) {
                int oldInventoryBalance;
                Player player = offlinePlayer.getPlayer();
                if (player == null) {
                    return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "error");
                }
                int oldBankBalance = this.bank.getAccountBalance(uuid);
                if (amount > (double)(oldBankBalance + (oldInventoryBalance = this.converter.getInventoryValue(player, TheGoldEconomy.base)))) {
                    return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "Not enough Money!");
                }
                if ((double)oldBankBalance - amount > 0.0) {
                    this.bank.setAccountBalance(uuid, (int)((double)oldBankBalance - amount));
                    return new EconomyResponse(amount, (double)oldBankBalance - amount, EconomyResponse.ResponseType.SUCCESS, "");
                }
                int diff = (int)(amount - (double)oldBankBalance);
                this.bank.setAccountBalance(uuid, 0);
                this.converter.remove(player, diff, TheGoldEconomy.base);
                return new EconomyResponse(amount, (double)oldInventoryBalance - amount, EconomyResponse.ResponseType.SUCCESS, "");
            }
            oldBalance = this.bank.getTotalPlayerBalance(uuid);
            int newBalance = (int)((double)oldBalance - amount);
            this.bank.setAccountBalance(uuid, newBalance);
            return new EconomyResponse(amount, (double)newBalance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        oldBalance = this.bank.getFakeBalance(s);
        int newBalance = (int)((double)oldBalance - amount);
        this.bank.setFakeAccountBalance(s, newBalance);
        return new EconomyResponse(amount, (double)newBalance, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, String s, double amount) {
        UUID uuid = offlinePlayer.getUniqueId();
        int oldBalance = 0;
        if (amount < 0.0) {
            return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "error");
        }
        if (offlinePlayer.isOnline()) {
            int oldInventoryBalance;
            Player player = offlinePlayer.getPlayer();
            if (player == null) {
                return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "error");
            }
            int oldBankBalance = this.bank.getAccountBalance(uuid);
            if (amount > (double)(oldBankBalance + (oldInventoryBalance = this.converter.getInventoryValue(player, TheGoldEconomy.base)))) {
                return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "error");
            }
            if ((double)oldBankBalance - amount > 0.0) {
                this.bank.setAccountBalance(uuid, (int)((double)oldBankBalance - amount));
                return new EconomyResponse(amount, (double)oldBankBalance - amount, EconomyResponse.ResponseType.SUCCESS, "");
            }
            int diff = (int)(amount - (double)oldBankBalance);
            this.bank.setAccountBalance(uuid, 0);
            this.converter.remove(player, diff, TheGoldEconomy.base);
            return new EconomyResponse(amount, (double)oldInventoryBalance - amount, EconomyResponse.ResponseType.SUCCESS, "");
        }
        oldBalance = this.bank.getTotalPlayerBalance(uuid);
        int newBalance = (int)((double)oldBalance - amount);
        this.bank.setAccountBalance(uuid, newBalance);
        return new EconomyResponse(amount, (double)newBalance, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse depositPlayer(String s, double amount) {
        int oldBalance = 0;
        if (amount < 0.0) {
            return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "error");
        }
        Optional<OfflinePlayer> playerOptional = this.util.isOfflinePlayer(s);
        if (playerOptional.isPresent()) {
            OfflinePlayer player = playerOptional.get();
            UUID uuid = player.getUniqueId();
            oldBalance = this.bank.getAccountBalance(uuid);
            int newBalance = (int)((double)oldBalance + amount);
            this.bank.setAccountBalance(uuid, newBalance);
            return new EconomyResponse(amount, (double)newBalance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        oldBalance = this.bank.getFakeBalance(s);
        int newBalance = (int)((double)oldBalance + amount);
        this.bank.setFakeAccountBalance(s, newBalance);
        return new EconomyResponse(amount, (double)newBalance, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, double amount) {
        UUID uuid = offlinePlayer.getUniqueId();
        int oldBalance = this.bank.getAccountBalance(uuid);
        int newBalance = (int)(amount + (double)oldBalance);
        if (amount < 0.0) {
            return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "error");
        }
        this.bank.setAccountBalance(uuid, newBalance);
        return new EconomyResponse(amount, (double)newBalance, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse depositPlayer(String s, String s1, double amount) {
        int oldBalance = 0;
        if (amount < 0.0) {
            return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "error");
        }
        Optional<OfflinePlayer> playerOptional = this.util.isOfflinePlayer(s);
        if (playerOptional.isPresent()) {
            OfflinePlayer player = playerOptional.get();
            UUID uuid = player.getUniqueId();
            oldBalance = this.bank.getAccountBalance(uuid);
            int newBalance = (int)((double)oldBalance + amount);
            this.bank.setAccountBalance(uuid, newBalance);
            return new EconomyResponse(amount, (double)newBalance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        oldBalance = this.bank.getFakeBalance(s);
        int newBalance = (int)((double)oldBalance + amount);
        this.bank.setFakeAccountBalance(s, newBalance);
        return new EconomyResponse(amount, (double)newBalance, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, String s, double amount) {
        UUID uuid = offlinePlayer.getUniqueId();
        int oldBalance = this.bank.getAccountBalance(uuid);
        int newBalance = (int)(amount + (double)oldBalance);
        if (amount < 0.0) {
            return new EconomyResponse(amount, (double)oldBalance, EconomyResponse.ResponseType.FAILURE, "error");
        }
        this.bank.setAccountBalance(uuid, newBalance);
        return new EconomyResponse(amount, (double)newBalance, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse createBank(String s, String s1) {
        return null;
    }

    public EconomyResponse createBank(String s, OfflinePlayer offlinePlayer) {
        return null;
    }

    public EconomyResponse deleteBank(String s) {
        return null;
    }

    public EconomyResponse bankBalance(String s) {
        return null;
    }

    public EconomyResponse bankHas(String s, double v) {
        return null;
    }

    public EconomyResponse bankWithdraw(String s, double v) {
        return null;
    }

    public EconomyResponse bankDeposit(String s, double v) {
        return null;
    }

    public EconomyResponse isBankOwner(String s, String s1) {
        return null;
    }

    public EconomyResponse isBankOwner(String s, OfflinePlayer offlinePlayer) {
        return null;
    }

    public EconomyResponse isBankMember(String s, String s1) {
        return null;
    }

    public EconomyResponse isBankMember(String s, OfflinePlayer offlinePlayer) {
        return null;
    }

    public List<String> getBanks() {
        return null;
    }

    public boolean createPlayerAccount(String s) {
        return false;
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer) {
        return false;
    }

    public boolean createPlayerAccount(String s, String s1) {
        return false;
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer, String s) {
        return false;
    }
}

