/*
 * Decompiled with CFR 0.152.
 */
package dev.confusedalex.thegoldeconomy;

import confusedalex.thegoldeconomy.libs.co.aikar.commands.Locales;
import confusedalex.thegoldeconomy.libs.co.aikar.commands.PaperCommandManager;
import dev.confusedalex.thegoldeconomy.BankCommand;
import dev.confusedalex.thegoldeconomy.Base;
import dev.confusedalex.thegoldeconomy.EconomyImplementer;
import dev.confusedalex.thegoldeconomy.Events;
import dev.confusedalex.thegoldeconomy.FileUtilsKt;
import dev.confusedalex.thegoldeconomy.Metrics;
import dev.confusedalex.thegoldeconomy.Placeholders;
import dev.confusedalex.thegoldeconomy.RemoveGoldDrops;
import dev.confusedalex.thegoldeconomy.UpdateChecker;
import dev.confusedalex.thegoldeconomy.Util;
import dev.confusedalex.thegoldeconomy.VaultHook;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Consumer;

public class TheGoldEconomy
extends JavaPlugin {
    EconomyImplementer eco;
    Util util;
    ResourceBundle bundle;
    public static Base base;
    private VaultHook vaultHook;

    public void onEnable() {
        this.saveDefaultConfig();
        PaperCommandManager manager = new PaperCommandManager((Plugin)this);
        manager.enableUnstableAPI("help");
        String language = this.getConfig().getString("language");
        HashMap<String, Locale> localeMap = new HashMap<String, Locale>();
        localeMap.put("de_DE", Locales.GERMAN);
        localeMap.put("en_US", Locales.ENGLISH);
        localeMap.put("zh_CN", Locales.SIMPLIFIED_CHINESE);
        localeMap.put("es_ES", Locales.SPANISH);
        localeMap.put("tr_TR", Locales.TURKISH);
        localeMap.put("pt_BR", Locales.PORTUGUESE);
        localeMap.put("nb_NO", Locales.NORWEGIAN_BOKMAAL);
        localeMap.put("uk", Locales.UKRANIAN);
        localeMap.put("jp_JP", Locales.JAPANESE);
        localeMap.put("bg_BG", Locales.BULGARIAN);
        if (localeMap.containsKey(language)) {
            Object locale = (Locale)localeMap.get(language);
            this.bundle = ResourceBundle.getBundle("messages", (Locale)locale);
            manager.addSupportedLanguage((Locale)locale);
            manager.getLocales().addMessageBundle("messages", (Locale)locale);
            manager.getLocales().addMessageBundles("messages");
            manager.getLocales();
            manager.getLocales().setDefaultLocale((Locale)locale);
        } else {
            this.bundle = ResourceBundle.getBundle("messages", Locale.US);
            this.getLogger().warning("Invalid language in config. Defaulting to English.");
        }
        switch (this.getConfig().getString("base")) {
            case "nuggets": {
                base = Base.NUGGETS;
                break;
            }
            case "ingots": {
                base = Base.INGOTS;
                break;
            }
            case "raw": {
                base = Base.RAW;
                break;
            }
            default: {
                this.getLogger().severe(this.bundle.getString("error.invalidBase"));
                this.getServer().shutdown();
            }
        }
        int pluginId = 15402;
        new Metrics(this, pluginId);
        this.util = new Util(this);
        this.eco = new EconomyImplementer(this, this.bundle, this.util);
        this.vaultHook = new VaultHook(this, this.eco);
        this.vaultHook.hook();
        manager.registerCommand(new BankCommand(this));
        Bukkit.getPluginManager().registerEvents((Listener)new Events(this.eco.bank), (Plugin)this);
        if (this.getConfig().getBoolean("removeGoldDrop")) {
            Bukkit.getPluginManager().registerEvents((Listener)new RemoveGoldDrops(), (Plugin)this);
        }
        if (this.getConfig().getBoolean("updateCheck")) {
            new UpdateChecker(this, 102242).getVersion((Consumer<String>)((Consumer)version -> {
                if (!this.getDescription().getVersion().equals(version)) {
                    this.getLogger().info(this.bundle.getString("warning.update"));
                }
            }));
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new Placeholders(this).register();
        }
    }

    public void onDisable() {
        FileUtilsKt.writeToFiles(this.eco.bank.getPlayerAccounts(), this.eco.bank.getFakeAccounts());
        this.vaultHook.unhook();
        this.getLogger().info("TheGoldEconomy disabled.");
    }
}

