/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.moreconcrete.common.common;

import com.autovw.moreconcrete.common.common.Colour;
import com.autovw.moreconcrete.common.common.block.BlockType;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_7923;

public final class ColourUtil {
    private static final List<class_2248> CONCRETE_BLOCKS = List.of(class_2246.field_10107, class_2246.field_10210, class_2246.field_10585, class_2246.field_10242, class_2246.field_10542, class_2246.field_10421, class_2246.field_10434, class_2246.field_10038, class_2246.field_10172, class_2246.field_10308, class_2246.field_10206, class_2246.field_10011, class_2246.field_10439, class_2246.field_10367, class_2246.field_10058, class_2246.field_10458);

    public static Colour parse(String colour) {
        return Colour.valueOf(colour.toUpperCase(Locale.ROOT));
    }

    public static Stream<? extends class_2248> sortTab(Stream<? extends class_2248> blockStream) {
        return blockStream.sorted(Comparator.comparing(block -> {
            BlockData data = ColourUtil.parseBlockData(class_7923.field_41175.method_10221(block).method_12832());
            return data.blockType().getDisplayPos();
        }).thenComparing(block -> {
            BlockData data = ColourUtil.parseBlockData(class_7923.field_41175.method_10221(block).method_12832());
            return data.colour().getDisplayPos();
        }));
    }

    public static Stream<class_2248> sortConcreteTab(Stream<class_2248> blockStream) {
        return Stream.concat(CONCRETE_BLOCKS.stream(), blockStream).sorted(Comparator.comparing(block -> {
            BlockData data = ColourUtil.parseBlockData(class_7923.field_41175.method_10221(block).method_12832());
            return data.colour().getDisplayPos();
        }).thenComparing(block -> {
            BlockData data = ColourUtil.parseBlockData(class_7923.field_41175.method_10221(block).method_12832());
            return data.blockType().getDisplayPos();
        }));
    }

    private static BlockData parseBlockData(String blockData) {
        String[] data = blockData.concat("_").split("_concrete_");
        String blockType = null;
        if (data.length > 1) {
            blockType = data[1].substring(0, data[1].length() - 1);
        }
        return new BlockData(ColourUtil.parse(data[0]), BlockType.parse(blockType));
    }

    private record BlockData(Colour colour, BlockType blockType) {
    }
}

