/*
 * Decompiled with CFR 0.152.
 */
package actuallyharvest.config;

import actuallyharvest.common.Translations;
import actuallyharvest.util.BlockHelper;
import actuallyharvest.util.ToolHelper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_10735;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2320;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_4863;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;

public class ConfigHandler {
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    private static final Common COMMON;

    public static void init() {
        class_2746 upper = class_2746.method_11825((String)"upper");
        class_2746 top = class_2746.method_11825((String)"top");
        Common.crops.clear();
        Common.rightClickBlocks.clear();
        Common.hoeTools.clear();
        if (Common.autoConfigMods()) {
            for (class_2248 block : class_7923.field_41175) {
                if (Common.isBlacklistMod(block) || Common.isBlacklistCrop(block)) continue;
                if (block instanceof class_2302) {
                    class_2302 cropBlock = (class_2302)block;
                    class_2680 cropBlockstate = cropBlock.method_9564();
                    class_2680 maxAgeCropBlockstate = cropBlock.method_9828(cropBlock.method_9827());
                    if (cropBlockstate.method_28498((class_2769)upper)) {
                        cropBlockstate = (class_2680)cropBlockstate.method_11657((class_2769)upper, (Comparable)Boolean.valueOf(true));
                        maxAgeCropBlockstate = (class_2680)maxAgeCropBlockstate.method_11657((class_2769)upper, (Comparable)Boolean.valueOf(true));
                    } else if (cropBlockstate.method_28498((class_2769)top)) {
                        cropBlockstate = (class_2680)cropBlockstate.method_11657((class_2769)top, (Comparable)Boolean.valueOf(true));
                        maxAgeCropBlockstate = (class_2680)maxAgeCropBlockstate.method_11657((class_2769)top, (Comparable)Boolean.valueOf(true));
                    } else if (cropBlockstate.method_28498((class_2769)class_2320.field_10929)) {
                        cropBlockstate = (class_2680)cropBlockstate.method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12609);
                        maxAgeCropBlockstate = (class_2680)maxAgeCropBlockstate.method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12609);
                    }
                    if (BlockHelper.isBottomBlock(block)) continue;
                    Common.crops.put(maxAgeCropBlockstate, cropBlockstate);
                    continue;
                }
                if (block instanceof class_2282) {
                    class_2282 cocoaBlock = (class_2282)block;
                    class_2741.field_12481.method_30043().forEach(direction -> {
                        class_2680 zeroState = (class_2680)((class_2680)cocoaBlock.method_9564().method_11657((class_2769)class_2282.field_10779, (Comparable)Integer.valueOf(0))).method_11657((class_2769)class_2282.field_11177, (Comparable)((class_2350)direction.comp_71()));
                        class_2680 maxAgeState = (class_2680)((class_2680)cocoaBlock.method_9564().method_11657((class_2769)class_2282.field_10779, (Comparable)Integer.valueOf(2))).method_11657((class_2769)class_2282.field_11177, (Comparable)((class_2350)direction.comp_71()));
                        Common.crops.put(maxAgeState, zeroState);
                    });
                    continue;
                }
                if (!(block instanceof class_10735) && !(block instanceof class_4863) || !(block instanceof class_2256)) continue;
                Common.rightClickBlocks.add(block);
            }
        }
        for (String cropKey : (List)ConfigHandler.COMMON.harvestableCrops.get()) {
            String[] parts = BlockHelper.parseBlockString(cropKey);
            class_2680 initial = BlockHelper.fromString(cropKey);
            class_2248 block = initial.method_26204();
            if (block == class_2246.field_10124 || Common.isBlacklistCrop(block) || Common.isBlacklistMod(block)) continue;
            class_2680 result = parts.length > 1 ? BlockHelper.fromString(parts[1]) : block.method_9564();
            Common.crops.put(initial, result);
        }
        for (String blockKey : (List)ConfigHandler.COMMON.harvestableBlocks.get()) {
            Optional blockReference = class_7923.field_41175.method_10223(class_2960.method_60654((String)blockKey));
            if (!blockReference.isPresent() || ((class_6880.class_6883)blockReference.get()).comp_349() == class_2246.field_10124 || Common.isBlacklistMod((class_2248)((class_6880.class_6883)blockReference.get()).comp_349())) continue;
            Common.rightClickBlocks.add((class_2248)((class_6880.class_6883)blockReference.get()).comp_349());
        }
        class_7923.field_41178.forEach(item -> {
            if (item instanceof class_1794) {
                class_1794 hoe = (class_1794)item;
                class_9424 tool = (class_9424)hoe.method_57347().method_58694(class_9334.field_50077);
                class_6862 tagKey = null;
                class_6885 blocks = null;
                if (tool != null) {
                    for (class_9424.class_9425 rule : tool.comp_2498()) {
                        Optional optionalBlockTagKey;
                        if (!rule.comp_2503().isPresent() || !(optionalBlockTagKey = rule.comp_2501().method_45925()).isPresent()) continue;
                        tagKey = (class_6862)optionalBlockTagKey.get();
                        blocks = rule.comp_2501();
                    }
                }
                if (tagKey == class_3481.field_33714) {
                    Common.hoeTools.put((class_1792)hoe, ToolHelper.getBaseRange(ToolHelper.getToolTier(blocks)));
                }
            }
        });
        for (String hoeItem : (List)ConfigHandler.COMMON.hoeItems.get()) {
            String[] parts = hoeItem.split("-");
            int range = ToolHelper.getBaseRange(Integer.parseInt(parts[1]));
            class_2960 loc = class_2960.method_60654((String)parts[0]);
            Optional itemReference = class_7923.field_41178.method_10223(loc);
            itemReference.ifPresent(reference -> Common.hoeTools.put((class_1792)reference.comp_349(), range));
        }
    }

    private static String getTranslation(String key) {
        return Translations.get(key);
    }

    static {
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    public static class Common {
        private final WhiteNoiseConfigSpec.BooleanValue allowEmptyHand;
        private final WhiteNoiseConfigSpec.BooleanValue damageTool;
        private final WhiteNoiseConfigSpec.BooleanValue autoConfigMods;
        private final WhiteNoiseConfigSpec.IntValue xpFromHarvestChance;
        private final WhiteNoiseConfigSpec.IntValue xpFromHarvestAmount;
        private final WhiteNoiseConfigSpec.BooleanValue xpFromHarvestUseRange;
        private final WhiteNoiseConfigSpec.ConfigValue<String> xpFromHarvestRangeAmount;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> harvestableCrops;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> harvestableBlocks;
        private final WhiteNoiseConfigSpec.BooleanValue expandHoeRange;
        private final WhiteNoiseConfigSpec.IntValue smallTierExpansionRange;
        private final WhiteNoiseConfigSpec.IntValue highTierExpansionRange;
        private final WhiteNoiseConfigSpec.BooleanValue expandHoeRangeEnchanted;
        private final WhiteNoiseConfigSpec.IntValue maxHoeExpansionRange;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> hoeItems;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> blacklistCrops;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> blacklistMods;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> blacklistHeldItems;
        private final WhiteNoiseConfigSpec.BooleanValue allowFakePlayer;
        private final WhiteNoiseConfigSpec.BooleanValue replantCrops;
        private static final Map<class_2680, class_2680> crops = Maps.newHashMap();
        private static final Set<class_2248> rightClickBlocks = Sets.newHashSet();
        private static final List<String> harvestableCropsList = List.of("harvestableCrops");
        private static final String[] defaultHarvestableCrops = new String[0];
        private static final List<String> harvestableBlocksList = List.of("harvestableBlocks");
        private static final String[] defaultHarvestableBlocks = new String[]{"minecraft:sweet_berry_bush", "minecraft:cave_vines"};
        private static final Predicate<Object> resourceLocationValidator = s -> s instanceof String && ((String)s).matches("[a-z]+[:]{1}[a-z_]+");
        private static final Predicate<Object> modidValidator = s -> s instanceof String && ((String)s).matches("^[a-z][a-z0-9_]{1,63}$");
        private static final Map<class_1792, Integer> hoeTools = Maps.newHashMap();
        private static final Predicate<Object> hoeItemValidator = s -> s instanceof String && ((String)s).matches("[a-z][a-z0-9_]{1,63}+[:]{1}[a-z_]+[-]{1}[0-9]+");
        private static final Predicate<Object> xpRangeValidator = s -> s instanceof String && ((String)s).matches("[0-9]+[-]{1}[0-9]+");
        private static final List<String> hoeItemList = List.of("hoeItems");
        private static final String[] defaultHoeItemList = new String[0];
        private static final List<String> blacklistCropsList = List.of("blacklistCrops");
        private static final String[] defaultBlacklistCrops = new String[0];
        private static final List<String> blacklistModsList = List.of("blacklistMods");
        private static final String[] defaultBlacklistMods = new String[0];
        private static final List<String> blacklistHeldItemsList = List.of("blacklistHeldItems");
        private static final String[] defaultBlacklistHeldItems = new String[0];

        public Common(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("general");
            this.allowEmptyHand = builder.comment(ConfigHandler.getTranslation("allowemptyhand")).define("allowEmptyHand", true);
            this.damageTool = builder.comment(ConfigHandler.getTranslation("damagetool")).define("damageTool", false);
            this.autoConfigMods = builder.comment(ConfigHandler.getTranslation("autoconfigmods")).define("autoConfigMods", true);
            this.xpFromHarvestChance = builder.comment(ConfigHandler.getTranslation("xpfromharvestchance")).defineInRange("xpFromHarvestChance", 100, 0, 100);
            this.xpFromHarvestAmount = builder.comment(ConfigHandler.getTranslation("xpfromharvestamount")).defineInRange("xpFromHarvestAmount", 1, 0, 10);
            this.xpFromHarvestUseRange = builder.comment(ConfigHandler.getTranslation("xpfromharvestuserange")).define("xpFromHarvestUseRange", false);
            this.xpFromHarvestRangeAmount = builder.comment(ConfigHandler.getTranslation("xpfromharvestrangeamount")).define("xpFromHarvestRangeAmount", (Object)"0-3", xpRangeValidator);
            this.harvestableCrops = builder.comment(ConfigHandler.getTranslation("harvestablecrops")).defineListAllowEmpty(harvestableCropsList, Common.getCropsList(), s -> s instanceof String);
            this.harvestableBlocks = builder.comment(ConfigHandler.getTranslation("harvestableblocks")).defineListAllowEmpty(harvestableBlocksList, Common.getHarvestableBlocksList(), resourceLocationValidator);
            this.expandHoeRange = builder.comment(ConfigHandler.getTranslation("expandhoerange")).define("expandHoeRange", true);
            this.smallTierExpansionRange = builder.comment(ConfigHandler.getTranslation("smalltierexpansionrange")).defineInRange("smallTierExpansionRange", 2, 1, 5);
            this.highTierExpansionRange = builder.comment(ConfigHandler.getTranslation("hightierexpansionrange")).defineInRange("highTierExpansionRange", 3, 1, 5);
            this.expandHoeRangeEnchanted = builder.comment(ConfigHandler.getTranslation("expandhoerangeenchanted")).define("expandHoeRangeEnchanted", true);
            this.maxHoeExpansionRange = builder.comment(ConfigHandler.getTranslation("maxhoeexpansionrange")).defineInRange("maxHoeExpansionRange", 11, 1, 11);
            this.hoeItems = builder.comment(ConfigHandler.getTranslation("hoeitems")).defineListAllowEmpty(hoeItemList, Common.getHoeItems(), hoeItemValidator);
            this.blacklistCrops = builder.comment(ConfigHandler.getTranslation("blacklistcrops")).defineListAllowEmpty(blacklistCropsList, Common.getBlacklistCrops(), resourceLocationValidator);
            this.blacklistMods = builder.comment(ConfigHandler.getTranslation("blacklistmods")).defineListAllowEmpty(blacklistModsList, Common.getBlacklistMods(), modidValidator);
            this.allowFakePlayer = builder.comment(ConfigHandler.getTranslation("allowfakeplayer")).define("allowFakePlayer", true);
            this.blacklistHeldItems = builder.comment(ConfigHandler.getTranslation("blacklisthelditems")).defineListAllowEmpty(blacklistHeldItemsList, Common.getBlacklistHeldItems(), resourceLocationValidator);
            this.replantCrops = builder.comment(ConfigHandler.getTranslation("replantcrops")).define("replantCrops", true);
        }

        public static boolean allowEmptyHand() {
            return (Boolean)ConfigHandler.COMMON.allowEmptyHand.get();
        }

        public static boolean damageTool() {
            return (Boolean)ConfigHandler.COMMON.damageTool.get();
        }

        public static boolean autoConfigMods() {
            return (Boolean)ConfigHandler.COMMON.autoConfigMods.get();
        }

        public static int xpFromHarvestChance() {
            return (Integer)ConfigHandler.COMMON.xpFromHarvestChance.get();
        }

        public static int xpFromHarvestAmount() {
            return (Integer)ConfigHandler.COMMON.xpFromHarvestAmount.get();
        }

        public static boolean xpFromHarvestUseRange() {
            return (Boolean)ConfigHandler.COMMON.xpFromHarvestUseRange.get();
        }

        public static Pair<Integer, Integer> xpFromHarvestRangeAmount() {
            int right;
            String[] amounts = ((String)ConfigHandler.COMMON.xpFromHarvestRangeAmount.get()).split("-");
            int left = Integer.parseInt(amounts[0]);
            if (left > (right = Integer.parseInt(amounts[1]))) {
                return Pair.of((Object)0, (Object)3);
            }
            return Pair.of((Object)left, (Object)right);
        }

        public static Set<class_2248> getRightClickBlocks() {
            return rightClickBlocks;
        }

        public static Map<class_2680, class_2680> getCrops() {
            return crops;
        }

        public static boolean expandHoeRange() {
            return (Boolean)ConfigHandler.COMMON.expandHoeRange.get();
        }

        public static int smallTierExpansionRange() {
            return (Integer)ConfigHandler.COMMON.smallTierExpansionRange.get();
        }

        public static int highTierExpansionRange() {
            return (Integer)ConfigHandler.COMMON.highTierExpansionRange.get();
        }

        public static boolean expandHoeRangeEnchanted() {
            return (Boolean)ConfigHandler.COMMON.expandHoeRangeEnchanted.get();
        }

        public static int maxHoeExpansionRange() {
            return (Integer)ConfigHandler.COMMON.maxHoeExpansionRange.get();
        }

        public static Map<class_1792, Integer> getHoeTools() {
            return hoeTools;
        }

        public static boolean allowFakePlayer() {
            return (Boolean)ConfigHandler.COMMON.allowFakePlayer.get();
        }

        private static Supplier<List<? extends String>> getCropsList() {
            return () -> Arrays.asList(defaultHarvestableCrops);
        }

        private static Supplier<List<? extends String>> getHarvestableBlocksList() {
            return () -> Arrays.asList(defaultHarvestableBlocks);
        }

        private static Supplier<List<? extends String>> getHoeItems() {
            return () -> Arrays.asList(defaultHoeItemList);
        }

        private static Supplier<List<? extends String>> getBlacklistCrops() {
            return () -> Arrays.asList(defaultBlacklistCrops);
        }

        private static Supplier<List<? extends String>> getBlacklistMods() {
            return () -> Arrays.asList(defaultBlacklistMods);
        }

        private static Supplier<List<? extends String>> getBlacklistHeldItems() {
            return () -> Arrays.asList(defaultBlacklistHeldItems);
        }

        private static boolean isBlacklistCrop(class_2248 block) {
            return ((List)ConfigHandler.COMMON.blacklistCrops.get()).contains(BlockHelper.getBlockId(block).toString());
        }

        private static boolean isBlacklistMod(class_2248 block) {
            return ((List)ConfigHandler.COMMON.blacklistMods.get()).contains(BlockHelper.getBlockId(block).method_12836());
        }

        public static boolean isBlacklistHeldItem(class_1799 stack) {
            return ((List)ConfigHandler.COMMON.blacklistHeldItems.get()).contains(ToolHelper.getItemStackId(stack).toString());
        }

        public static boolean replantCrops() {
            return (Boolean)ConfigHandler.COMMON.replantCrops.get();
        }
    }
}

