/*
 * Decompiled with CFR 0.152.
 */
package actuallyharvest.event;

import actuallyharvest.ActuallyHarvest;
import actuallyharvest.config.ConfigHandler;
import actuallyharvest.event.ClickResult;
import actuallyharvest.util.BlockHelper;
import actuallyharvest.util.ToolHelper;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class HarvestEventHandler {
    private static boolean isHarvesting = false;

    public static ClickResult rightClickBlock(Player player, InteractionHand hand, BlockPos pos, BlockHitResult hitResult) {
        if (player.level().isClientSide() || isHarvesting || !BlockHelper.playerCanHarvest(player)) {
            return ClickResult.pass();
        }
        isHarvesting = true;
        ClickResult result = HarvestEventHandler.getClickResult(player, hand, pos, hitResult);
        isHarvesting = false;
        return result;
    }

    private static ClickResult getClickResult(Player player, InteractionHand hand, BlockPos pos, BlockHitResult hitResult) {
        if (player == null || hand == null || player.isSpectator()) {
            return ClickResult.pass();
        }
        if (hitResult.getType() != HitResult.Type.BLOCK || !hitResult.getBlockPos().equals((Object)pos)) {
            return ClickResult.pass();
        }
        Level level = player.level();
        BlockState blockState = level.getBlockState(pos);
        BlockState modifiedState = BlockHelper.getToolModifiedState(blockState, new UseOnContext(player, hand, hitResult), "hoe_till", true);
        if (modifiedState != null) {
            return ClickResult.pass();
        }
        ItemStack heldStack = player.getItemInHand(hand);
        boolean isHoe = ToolHelper.isHoe(heldStack);
        if (!ConfigHandler.Common.allowEmptyHand() && !isHoe) {
            return ClickResult.pass();
        }
        BlockState above = level.getBlockState(pos.above());
        int range = 1;
        if (isHoe) {
            if (BlockHelper.getInteractionTypeForBlock(blockState, true) == BlockHelper.InteractionType.NONE && BlockHelper.getInteractionTypeForBlock(above, true) == BlockHelper.InteractionType.NONE) {
                return ClickResult.pass();
            }
            range = ToolHelper.getRange(heldStack);
        }
        boolean harvested = false;
        for (int x = 1 - range; x < range; ++x) {
            for (int z = 1 - range; z < range; ++z) {
                BlockPos shiftPos = pos.offset(x, 0, z);
                if (!HarvestEventHandler.tryHarvest(level, shiftPos, (LivingEntity)player, hand, range > 1)) {
                    if (!HarvestEventHandler.tryHarvest(level, shiftPos = shiftPos.above(), (LivingEntity)player, hand, range > 1)) continue;
                    harvested = true;
                    continue;
                }
                harvested = true;
            }
        }
        if (!harvested) {
            return ClickResult.pass();
        }
        if (BlockHelper.isBlockItem(heldStack)) {
            return ClickResult.pass();
        }
        return ClickResult.interrupt();
    }

    private static boolean tryHarvest(Level level, BlockPos pos, @Nullable LivingEntity entity, @Nullable InteractionHand hand, boolean canReach) {
        Player player;
        if (entity instanceof Player && !level.mayInteract((Entity)(player = (Player)entity), pos)) {
            return false;
        }
        Pair<BlockState, Boolean> blockStatePair = BlockHelper.getModifiedState(level.getBlockState(pos));
        BlockState blockState = (BlockState)blockStatePair.getLeft();
        BlockHelper.InteractionType interactionType = BlockHelper.getInteractionTypeForBlock(blockState, canReach);
        if (interactionType != BlockHelper.InteractionType.NONE) {
            if (interactionType == BlockHelper.InteractionType.HARVEST) {
                if (entity instanceof Player) {
                    return HarvestEventHandler.harvestAndReplant(level, pos, blockState, entity, hand, (Boolean)blockStatePair.getRight());
                }
            } else if (interactionType == BlockHelper.InteractionType.CLICK && entity instanceof Player) {
                BlockHitResult hitResult = new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.UP, pos, true);
                if (hand == null) {
                    hand = InteractionHand.MAIN_HAND;
                }
                if (entity instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)entity;
                    return sp.gameMode.useItemOn(sp, (Level)sp.level(), sp.getItemInHand(hand), hand, hitResult).consumesAction();
                }
            }
        }
        return false;
    }

    private static boolean harvestAndReplant(Level level, BlockPos pos, BlockState blockState, LivingEntity entity, InteractionHand hand, boolean treeCrop) {
        BlockState cropBlockState = ConfigHandler.Common.getCrops().get(blockState);
        BlockState above = level.getBlockState(pos.above());
        BooleanProperty top = BooleanProperty.create((String)"top");
        if (!treeCrop && above.getBlock() instanceof CropBlock) {
            cropBlockState = ConfigHandler.Common.getCrops().get(above);
        }
        if (cropBlockState == null) {
            return false;
        }
        if (level instanceof ServerLevel) {
            ItemStack copy;
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack heldStack = null;
            if (entity == null || hand == null) {
                copy = new ItemStack((ItemLike)Items.STICK);
            } else {
                heldStack = entity.getItemInHand(hand);
                if (ConfigHandler.Common.isBlacklistHeldItem(heldStack)) {
                    return false;
                }
                copy = entity.getItemInHand(hand).copy();
            }
            MutableBoolean hasTaken = new MutableBoolean(false);
            Item blockItem = blockState.getBlock().asItem();
            boolean dropXp = entity instanceof Player;
            if (!cropBlockState.hasProperty((Property)top)) {
                Block.getDrops((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)entity, (ItemStack)copy).forEach(stack -> {
                    if (stack.getItem() == blockItem && !hasTaken.getValue().booleanValue()) {
                        stack.shrink(1);
                        hasTaken.setValue(true);
                    }
                    if (!stack.isEmpty()) {
                        Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
                    }
                });
                blockState.spawnAfterBreak(serverLevel, pos, copy, dropXp);
            }
            if (dropXp && ConfigHandler.Common.xpFromHarvestUseRange()) {
                int xp = ThreadLocalRandom.current().nextInt((Integer)ConfigHandler.Common.xpFromHarvestRangeAmount().getLeft(), (Integer)ConfigHandler.Common.xpFromHarvestRangeAmount().getRight() + 1);
                if (xp > 0) {
                    ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)Vec3.atCenterOf((Vec3i)pos), (int)xp);
                }
            } else if (dropXp && ActuallyHarvest.RANDOM.nextInt(100) + 1 <= ConfigHandler.Common.xpFromHarvestChance()) {
                ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)Vec3.atCenterOf((Vec3i)pos), (int)ConfigHandler.Common.xpFromHarvestAmount());
            }
            if (cropBlockState.hasProperty((Property)DoublePlantBlock.HALF)) {
                BlockPos blockPos = pos;
                if (cropBlockState.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER) {
                    blockPos = pos.below();
                }
                BlockState doubleBlockHalf = level.getBlockState(pos);
                level.levelEvent(2001, blockPos, Block.getId((BlockState)doubleBlockHalf));
                level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, blockPos, GameEvent.Context.of((Entity)entity, (BlockState)doubleBlockHalf));
                level.destroyBlock(blockPos, true, (Entity)entity);
                if (ConfigHandler.Common.replantCrops()) {
                    level.setBlock(blockPos, (BlockState)doubleBlockHalf.getBlock().defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 0);
                } else {
                    level.destroyBlock(blockPos, false, (Entity)entity);
                }
            } else {
                level.levelEvent(2001, pos, Block.getId((BlockState)cropBlockState));
                if (ConfigHandler.Common.replantCrops()) {
                    level.setBlockAndUpdate(pos, cropBlockState);
                } else {
                    level.destroyBlock(pos, false, (Entity)entity);
                }
                level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockState));
            }
            if (cropBlockState.hasProperty((Property)top)) {
                level.destroyBlock(pos, true, (Entity)entity);
            }
            if (!level.isClientSide() && heldStack != null && ConfigHandler.Common.damageTool() && ToolHelper.isHoe(heldStack)) {
                heldStack.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
            }
        }
        return true;
    }
}

