/*
 * Decompiled with CFR 0.152.
 */
package actuallyharvest.util;

import actuallyharvest.common.TagManager;
import actuallyharvest.config.ConfigHandler;
import actuallyharvest.util.BlockHolderLookup;
import com.google.common.collect.BiMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.platform.Services;

public class BlockHelper {
    public static boolean isVanilla(Block block) {
        return BlockHelper.getBlockId(block).getNamespace().equals("minecraft");
    }

    public static boolean isBottomBlock(Block block) {
        return BlockHelper.getBlockId(block).getPath().contains("_bottom");
    }

    public static ResourceLocation getBlockId(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static String[] parseBlockString(String blockString) {
        boolean inBracket = false;
        for (int i = 0; i < blockString.length(); ++i) {
            char c = blockString.charAt(i);
            if (c == '[') {
                inBracket = true;
                continue;
            }
            if (c == ']') {
                inBracket = false;
                continue;
            }
            if (c != ',' || inBracket) continue;
            return new String[]{blockString.substring(0, i), blockString.substring(i + 1)};
        }
        return new String[]{blockString};
    }

    public static BlockState fromString(String key) {
        try {
            BlockStateParser.BlockResult result = BlockStateParser.parseForBlock(BlockHolderLookup.asLookup(), (StringReader)new StringReader(key), (boolean)false);
            return result.blockState();
        }
        catch (CommandSyntaxException e) {
            return Blocks.AIR.defaultBlockState();
        }
    }

    public static BlockState getToolModifiedState(BlockState state, UseOnContext context, String toolActionType, boolean simulate) {
        return switch (toolActionType) {
            case "axe_strip" -> BlockHelper.getAxeStrippingState(state);
            case "axe_scrape" -> WeatheringCopper.getPrevious((BlockState)state).orElse(null);
            case "axe_wax_off" -> Optional.ofNullable((Block)((BiMap)HoneycombItem.WAX_OFF_BY_BLOCK.get()).get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state)).orElse(null);
            case "shovel_flatten" -> BlockHelper.getShovelPathingState(state);
            case "hoe_till" -> {
                Block block = state.getBlock();
                if (block == Blocks.ROOTED_DIRT) {
                    if (!simulate && !context.getLevel().isClientSide()) {
                        Block.popResourceFromFace((Level)context.getLevel(), (BlockPos)context.getClickedPos(), (Direction)context.getClickedFace(), (ItemStack)new ItemStack((ItemLike)Items.HANGING_ROOTS));
                    }
                    yield Blocks.DIRT.defaultBlockState();
                }
                if ((block == Blocks.GRASS_BLOCK || block == Blocks.DIRT_PATH || block == Blocks.DIRT || block == Blocks.COARSE_DIRT) && context.getLevel().getBlockState(context.getClickedPos().above()).isAir()) {
                    if (block == Blocks.COARSE_DIRT) {
                        yield Blocks.DIRT.defaultBlockState();
                    }
                    yield Blocks.FARMLAND.defaultBlockState();
                }
                yield null;
            }
            default -> null;
        };
    }

    public static InteractionType getInteractionTypeForBlock(BlockState state, boolean canRightClick) {
        if ((state = (BlockState)BlockHelper.getModifiedState(state).getLeft()).is(TagManager.Blocks.HARVEST_BLACKLIST)) {
            return InteractionType.NONE;
        }
        if (canRightClick && ConfigHandler.Common.getRightClickBlocks().contains(state.getBlock())) {
            return InteractionType.CLICK;
        }
        if (ConfigHandler.Common.getCrops().containsKey(state)) {
            return InteractionType.HARVEST;
        }
        return InteractionType.NONE;
    }

    public static Pair<BlockState, Boolean> getModifiedState(BlockState state) {
        IntegerProperty distance = IntegerProperty.create((String)"distance", (int)1, (int)7);
        AtomicBoolean useDefault = new AtomicBoolean(false);
        state.getProperties().forEach(property -> {
            if (property.equals((Object)distance)) {
                useDefault.set(true);
            }
        });
        if (useDefault.get()) {
            Block block = null;
            Optional optionalBlock = BuiltInRegistries.BLOCK.get(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()));
            if (optionalBlock.isPresent()) {
                block = (Block)((Holder.Reference)optionalBlock.get()).value();
            }
            if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                Integer age = (Integer)state.getValue((Property)cropBlock.getAgeProperty());
                state = (BlockState)cropBlock.defaultBlockState().setValue((Property)cropBlock.getAgeProperty(), (Comparable)age);
            }
        }
        return Pair.of((Object)state, (Object)useDefault.get());
    }

    public static boolean playerCanHarvest(Player player) {
        if (ConfigHandler.Common.allowFakePlayer()) {
            return true;
        }
        return !Services.PLATFORM.isFakePlayer(player);
    }

    private static BlockState getAxeStrippingState(BlockState state) {
        Block block = (Block)AxeItem.STRIPPABLES.get(state.getBlock());
        return block != null ? (BlockState)block.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS))) : null;
    }

    private static BlockState getShovelPathingState(BlockState state) {
        return (BlockState)ShovelItem.FLATTENABLES.get(state.getBlock());
    }

    public static boolean isBlockItem(ItemStack stack) {
        return Block.byItem((Item)stack.getItem()) instanceof Block;
    }

    public static enum InteractionType {
        NONE,
        CLICK,
        HARVEST;

    }
}

