/*
 * Decompiled with CFR 0.152.
 */
package actuallyharvest.util;

import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class BlockHolderLookup {
    public static HolderLookup.RegistryLookup<Block> asLookup() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        final ImmutableMap immutablemap = builder.build();
        return new HolderLookup.RegistryLookup.Delegate<Block>(){

            @NotNull
            public HolderLookup.RegistryLookup<Block> parent() {
                return BuiltInRegistries.BLOCK.filterElements(block -> block instanceof Block);
            }

            @NotNull
            public Optional<HolderSet.Named<Block>> get(@NotNull TagKey<Block> tagKey) {
                return Optional.ofNullable((HolderSet.Named)immutablemap.get(tagKey));
            }

            @NotNull
            public Stream<HolderSet.Named<Block>> listTags() {
                return immutablemap.values().stream();
            }
        };
    }
}

