/*
 * Decompiled with CFR 0.152.
 */
package actuallyharvest.util;

import actuallyharvest.config.ConfigHandler;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.Block;

public class ToolHelper {
    public static boolean isHoe(ItemStack stack) {
        return !stack.isEmpty() && (stack.getItem() instanceof HoeItem || stack.is(ItemTags.HOES));
    }

    public static int getRange(ItemStack hoe) {
        int range = ConfigHandler.Common.getHoeTools().getOrDefault(hoe.getItem(), 1);
        int expandedRange = 0;
        if (ConfigHandler.Common.expandHoeRangeEnchanted()) {
            ItemEnchantments enchantments = hoe.getEnchantments();
            for (Holder enchantmentHolder : enchantments.keySet()) {
                if (!enchantmentHolder.is(Enchantments.EFFICIENCY)) continue;
                expandedRange = enchantments.getLevel(enchantmentHolder);
            }
        }
        return Math.min(range + expandedRange, ConfigHandler.Common.maxHoeExpansionRange());
    }

    public static int getBaseRange(int level) {
        if (ConfigHandler.Common.expandHoeRange()) {
            if (level <= 2) {
                return ConfigHandler.Common.smallTierExpansionRange();
            }
            return ConfigHandler.Common.highTierExpansionRange();
        }
        return 1;
    }

    public static int getToolTier(HolderSet<Block> blocks) {
        int tier = 0;
        Map<TagKey, Integer> tiers = Map.of(BlockTags.INCORRECT_FOR_WOODEN_TOOL, 0, BlockTags.INCORRECT_FOR_STONE_TOOL, 1, BlockTags.INCORRECT_FOR_IRON_TOOL, 2, BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 3, BlockTags.INCORRECT_FOR_GOLD_TOOL, 4, BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 5);
        try {
            Optional key = blocks.unwrapKey();
            if (key.isPresent()) {
                tier = tiers.getOrDefault(key.get(), 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tier;
    }

    public static ResourceLocation getItemStackId(ItemStack stack) {
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
    }
}

