/*
 * Decompiled with CFR 0.152.
 */
package actuallyharvest.event;

import actuallyharvest.ActuallyHarvest;
import actuallyharvest.config.ConfigHandler;
import actuallyharvest.event.ClickResult;
import actuallyharvest.util.BlockHelper;
import actuallyharvest.util.ToolHelper;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class HarvestEventHandler {
    private static boolean isHarvesting = false;

    public static ClickResult rightClickBlock(class_1657 player, class_1268 hand, class_2338 pos, class_3965 hitResult) {
        if (player.method_73183().method_8608() || isHarvesting || !BlockHelper.playerCanHarvest(player)) {
            return ClickResult.pass();
        }
        isHarvesting = true;
        ClickResult result = HarvestEventHandler.getClickResult(player, hand, pos, hitResult);
        isHarvesting = false;
        return result;
    }

    private static ClickResult getClickResult(class_1657 player, class_1268 hand, class_2338 pos, class_3965 hitResult) {
        if (player == null || hand == null || player.method_7325()) {
            return ClickResult.pass();
        }
        if (hitResult.method_17783() != class_239.class_240.field_1332 || !hitResult.method_17777().equals((Object)pos)) {
            return ClickResult.pass();
        }
        class_1937 level = player.method_73183();
        class_2680 blockState = level.method_8320(pos);
        class_2680 modifiedState = BlockHelper.getToolModifiedState(blockState, new class_1838(player, hand, hitResult), "hoe_till", true);
        if (modifiedState != null) {
            return ClickResult.pass();
        }
        class_1799 heldStack = player.method_5998(hand);
        boolean isHoe = ToolHelper.isHoe(heldStack);
        if (!ConfigHandler.Common.allowEmptyHand() && !isHoe) {
            return ClickResult.pass();
        }
        class_2680 above = level.method_8320(pos.method_10084());
        int range = 1;
        if (isHoe) {
            if (BlockHelper.getInteractionTypeForBlock(blockState, true) == BlockHelper.InteractionType.NONE && BlockHelper.getInteractionTypeForBlock(above, true) == BlockHelper.InteractionType.NONE) {
                return ClickResult.pass();
            }
            range = ToolHelper.getRange(heldStack);
        }
        boolean harvested = false;
        for (int x = 1 - range; x < range; ++x) {
            for (int z = 1 - range; z < range; ++z) {
                class_2338 shiftPos = pos.method_10069(x, 0, z);
                if (!HarvestEventHandler.tryHarvest(level, shiftPos, (class_1309)player, hand, range > 1)) {
                    if (!HarvestEventHandler.tryHarvest(level, shiftPos = shiftPos.method_10084(), (class_1309)player, hand, range > 1)) continue;
                    harvested = true;
                    continue;
                }
                harvested = true;
            }
        }
        if (!harvested) {
            return ClickResult.pass();
        }
        if (BlockHelper.isBlockItem(heldStack)) {
            return ClickResult.pass();
        }
        return ClickResult.interrupt();
    }

    private static boolean tryHarvest(class_1937 level, class_2338 pos, @Nullable class_1309 entity, @Nullable class_1268 hand, boolean canReach) {
        class_1657 player;
        if (entity instanceof class_1657 && !level.method_8505((class_1297)(player = (class_1657)entity), pos)) {
            return false;
        }
        Pair<class_2680, Boolean> blockStatePair = BlockHelper.getModifiedState(level.method_8320(pos));
        class_2680 blockState = (class_2680)blockStatePair.getLeft();
        BlockHelper.InteractionType interactionType = BlockHelper.getInteractionTypeForBlock(blockState, canReach);
        if (interactionType != BlockHelper.InteractionType.NONE) {
            if (interactionType == BlockHelper.InteractionType.HARVEST) {
                if (entity instanceof class_1657) {
                    return HarvestEventHandler.harvestAndReplant(level, pos, blockState, entity, hand, (Boolean)blockStatePair.getRight());
                }
            } else if (interactionType == BlockHelper.InteractionType.CLICK && entity instanceof class_1657) {
                class_3965 hitResult = new class_3965(class_243.method_24953((class_2382)pos), class_2350.field_11036, pos, true);
                if (hand == null) {
                    hand = class_1268.field_5808;
                }
                if (entity instanceof class_3222) {
                    class_3222 sp = (class_3222)entity;
                    return sp.field_13974.method_14262(sp, (class_1937)sp.method_51469(), sp.method_5998(hand), hand, hitResult).method_23665();
                }
            }
        }
        return false;
    }

    private static boolean harvestAndReplant(class_1937 level, class_2338 pos, class_2680 blockState, class_1309 entity, class_1268 hand, boolean treeCrop) {
        class_2680 cropBlockState = ConfigHandler.Common.getCrops().get(blockState);
        class_2680 above = level.method_8320(pos.method_10084());
        class_2746 top = class_2746.method_11825((String)"top");
        if (!treeCrop && above.method_26204() instanceof class_2302) {
            cropBlockState = ConfigHandler.Common.getCrops().get(above);
        }
        if (cropBlockState == null) {
            return false;
        }
        if (level instanceof class_3218) {
            class_1799 copy;
            class_3218 serverLevel = (class_3218)level;
            class_1799 heldStack = null;
            if (entity == null || hand == null) {
                copy = new class_1799((class_1935)class_1802.field_8600);
            } else {
                heldStack = entity.method_5998(hand);
                if (ConfigHandler.Common.isBlacklistHeldItem(heldStack)) {
                    return false;
                }
                copy = entity.method_5998(hand).method_7972();
            }
            MutableBoolean hasTaken = new MutableBoolean(false);
            class_1792 blockItem = blockState.method_26204().method_8389();
            boolean dropXp = entity instanceof class_1657;
            if (!cropBlockState.method_28498((class_2769)top)) {
                class_2248.method_9609((class_2680)blockState, (class_3218)serverLevel, (class_2338)pos, (class_2586)level.method_8321(pos), (class_1297)entity, (class_1799)copy).forEach(stack -> {
                    if (stack.method_7909() == blockItem && !hasTaken.getValue().booleanValue()) {
                        stack.method_7934(1);
                        hasTaken.setValue(true);
                    }
                    if (!stack.method_7960()) {
                        class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)stack);
                    }
                });
                blockState.method_26180(serverLevel, pos, copy, dropXp);
            }
            if (dropXp && ConfigHandler.Common.xpFromHarvestUseRange()) {
                int xp = ThreadLocalRandom.current().nextInt((Integer)ConfigHandler.Common.xpFromHarvestRangeAmount().getLeft(), (Integer)ConfigHandler.Common.xpFromHarvestRangeAmount().getRight() + 1);
                if (xp > 0) {
                    class_1303.method_31493((class_3218)serverLevel, (class_243)class_243.method_24953((class_2382)pos), (int)xp);
                }
            } else if (dropXp && ActuallyHarvest.RANDOM.nextInt(100) + 1 <= ConfigHandler.Common.xpFromHarvestChance()) {
                class_1303.method_31493((class_3218)serverLevel, (class_243)class_243.method_24953((class_2382)pos), (int)ConfigHandler.Common.xpFromHarvestAmount());
            }
            if (cropBlockState.method_28498((class_2769)class_2320.field_10929)) {
                class_2338 blockPos = pos;
                if (cropBlockState.method_11654((class_2769)class_2320.field_10929) == class_2756.field_12609) {
                    blockPos = pos.method_10074();
                }
                class_2680 doubleBlockHalf = level.method_8320(pos);
                level.method_20290(2001, blockPos, class_2248.method_9507((class_2680)doubleBlockHalf));
                level.method_43276((class_6880)class_5712.field_28165, blockPos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)doubleBlockHalf));
                level.method_8651(blockPos, true, (class_1297)entity);
                level.method_8652(blockPos, (class_2680)doubleBlockHalf.method_26204().method_9564().method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12607), 0);
            } else {
                level.method_20290(2001, pos, class_2248.method_9507((class_2680)cropBlockState));
                level.method_8501(pos, cropBlockState);
                level.method_43276((class_6880)class_5712.field_28165, pos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)blockState));
            }
            if (cropBlockState.method_28498((class_2769)top)) {
                level.method_8651(pos, true, (class_1297)entity);
            }
            if (!level.method_8608() && heldStack != null && ConfigHandler.Common.damageTool() && ToolHelper.isHoe(heldStack)) {
                heldStack.method_7970(1, entity, class_1304.field_6173);
            }
        }
        return true;
    }
}

