/*
 * Decompiled with CFR 0.152.
 */
package actuallyharvest.util;

import actuallyharvest.common.TagManager;
import actuallyharvest.config.ConfigHandler;
import actuallyharvest.util.BlockHolderLookup;
import com.google.common.collect.BiMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1821;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5953;
import net.minecraft.class_5955;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.platform.Services;

public class BlockHelper {
    public static boolean isVanilla(class_2248 block) {
        return BlockHelper.getBlockId(block).method_12836().equals("minecraft");
    }

    public static boolean isBottomBlock(class_2248 block) {
        return BlockHelper.getBlockId(block).method_12832().contains("_bottom");
    }

    public static class_2960 getBlockId(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block);
    }

    public static String[] parseBlockString(String blockString) {
        boolean inBracket = false;
        for (int i = 0; i < blockString.length(); ++i) {
            char c = blockString.charAt(i);
            if (c == '[') {
                inBracket = true;
                continue;
            }
            if (c == ']') {
                inBracket = false;
                continue;
            }
            if (c != ',' || inBracket) continue;
            return new String[]{blockString.substring(0, i), blockString.substring(i + 1)};
        }
        return new String[]{blockString};
    }

    public static class_2680 fromString(String key) {
        try {
            class_2259.class_7211 result = class_2259.method_41955(BlockHolderLookup.asLookup(), (StringReader)new StringReader(key), (boolean)false);
            return result.comp_622();
        }
        catch (CommandSyntaxException e) {
            return class_2246.field_10124.method_9564();
        }
    }

    public static class_2680 getToolModifiedState(class_2680 state, class_1838 context, String toolActionType, boolean simulate) {
        return switch (toolActionType) {
            case "axe_strip" -> BlockHelper.getAxeStrippingState(state);
            case "axe_scrape" -> class_5955.method_34735((class_2680)state).orElse(null);
            case "axe_wax_off" -> Optional.ofNullable((class_2248)((BiMap)class_5953.field_29561.get()).get((Object)state.method_26204())).map(block -> block.method_34725(state)).orElse(null);
            case "shovel_flatten" -> BlockHelper.getShovelPathingState(state);
            case "hoe_till" -> {
                class_2248 block = state.method_26204();
                if (block == class_2246.field_28685) {
                    if (!simulate && !context.method_8045().method_8608()) {
                        class_2248.method_36992((class_1937)context.method_8045(), (class_2338)context.method_8037(), (class_2350)context.method_8038(), (class_1799)new class_1799((class_1935)class_1802.field_28656));
                    }
                    yield class_2246.field_10566.method_9564();
                }
                if ((block == class_2246.field_10219 || block == class_2246.field_10194 || block == class_2246.field_10566 || block == class_2246.field_10253) && context.method_8045().method_8320(context.method_8037().method_10084()).method_26215()) {
                    if (block == class_2246.field_10253) {
                        yield class_2246.field_10566.method_9564();
                    }
                    yield class_2246.field_10362.method_9564();
                }
                yield null;
            }
            default -> null;
        };
    }

    public static InteractionType getInteractionTypeForBlock(class_2680 state, boolean canRightClick) {
        if ((state = (class_2680)BlockHelper.getModifiedState(state).getLeft()).method_26164(TagManager.Blocks.HARVEST_BLACKLIST)) {
            return InteractionType.NONE;
        }
        if (canRightClick && ConfigHandler.Common.getRightClickBlocks().contains(state.method_26204())) {
            return InteractionType.CLICK;
        }
        if (ConfigHandler.Common.getCrops().containsKey(state)) {
            return InteractionType.HARVEST;
        }
        return InteractionType.NONE;
    }

    public static Pair<class_2680, Boolean> getModifiedState(class_2680 state) {
        class_2758 distance = class_2758.method_11867((String)"distance", (int)1, (int)7);
        AtomicBoolean useDefault = new AtomicBoolean(false);
        state.method_28501().forEach(property -> {
            if (property.equals((Object)distance)) {
                useDefault.set(true);
            }
        });
        if (useDefault.get()) {
            class_2248 block = null;
            Optional optionalBlock = class_7923.field_41175.method_10223(class_7923.field_41175.method_10221((Object)state.method_26204()));
            if (optionalBlock.isPresent()) {
                block = (class_2248)((class_6880.class_6883)optionalBlock.get()).comp_349();
            }
            if (block instanceof class_2302) {
                class_2302 cropBlock = (class_2302)block;
                Integer age = (Integer)state.method_11654((class_2769)cropBlock.method_9824());
                state = (class_2680)cropBlock.method_9564().method_11657((class_2769)cropBlock.method_9824(), (Comparable)age);
            }
        }
        return Pair.of((Object)state, (Object)useDefault.get());
    }

    public static boolean playerCanHarvest(class_1657 player) {
        if (ConfigHandler.Common.allowFakePlayer()) {
            return true;
        }
        return !Services.PLATFORM.isFakePlayer(player);
    }

    private static class_2680 getAxeStrippingState(class_2680 state) {
        class_2248 block = (class_2248)class_1743.field_7898.get(state.method_26204());
        return block != null ? (class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))) : null;
    }

    private static class_2680 getShovelPathingState(class_2680 state) {
        return (class_2680)class_1821.field_8912.get(state.method_26204());
    }

    public static boolean isBlockItem(class_1799 stack) {
        return class_2248.method_9503((class_1792)stack.method_7909()) instanceof class_2248;
    }

    public static enum InteractionType {
        NONE,
        CLICK,
        HARVEST;

    }
}

