/*
 * Decompiled with CFR 0.152.
 */
package actuallyharvest.util;

import actuallyharvest.config.ConfigHandler;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class ToolHelper {
    public static boolean isHoe(ItemStack stack) {
        if (!stack.isEmpty()) {
            boolean configuredHoe = ConfigHandler.Common.getHoeTools().containsKey(stack.getItem());
            return stack.getItem() instanceof HoeItem || stack.is(ItemTags.HOES) || configuredHoe;
        }
        return false;
    }

    public static int getRange(ItemStack hoe) {
        int range = ConfigHandler.Common.getHoeTools().getOrDefault(hoe.getItem(), 1);
        int expandedRange = 0;
        if (ConfigHandler.Common.expandHoeRangeEnchanted()) {
            ItemEnchantments enchantments = hoe.getEnchantments();
            for (Holder enchantmentHolder : enchantments.keySet()) {
                if (!enchantmentHolder.is(Enchantments.EFFICIENCY)) continue;
                expandedRange = enchantments.getLevel(enchantmentHolder);
            }
        }
        return Math.min(range + expandedRange, ConfigHandler.Common.maxHoeExpansionRange());
    }

    public static int getBaseRange(int level) {
        if (ConfigHandler.Common.expandHoeRange()) {
            if (level <= 2) {
                return ConfigHandler.Common.smallTierExpansionRange();
            }
            return ConfigHandler.Common.highTierExpansionRange();
        }
        return 1;
    }

    public static ResourceLocation getItemStackId(ItemStack stack) {
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
    }
}

