/*
 * Decompiled with CFR 0.152.
 */
package actuallyharvest.config;

import actuallyharvest.common.Translations;
import actuallyharvest.util.BlockHelper;
import actuallyharvest.util.ToolHelper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;

public class ConfigHandler {
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    private static final Common COMMON;

    public static void init() {
        BooleanProperty upper = BooleanProperty.create((String)"upper");
        BooleanProperty top = BooleanProperty.create((String)"top");
        Common.crops.clear();
        Common.rightClickBlocks.clear();
        Common.hoeTools.clear();
        if (Common.autoConfigMods()) {
            for (Block block : BuiltInRegistries.BLOCK) {
                if (Common.isBlacklistMod(block) || Common.isBlacklistCrop(block)) continue;
                if (block instanceof CropBlock) {
                    CropBlock cropBlock = (CropBlock)block;
                    BlockState cropBlockstate = cropBlock.defaultBlockState();
                    BlockState maxAgeCropBlockstate = cropBlock.getStateForAge(cropBlock.getMaxAge());
                    if (cropBlockstate.hasProperty((Property)upper)) {
                        cropBlockstate = (BlockState)cropBlockstate.setValue((Property)upper, (Comparable)Boolean.valueOf(true));
                        maxAgeCropBlockstate = (BlockState)maxAgeCropBlockstate.setValue((Property)upper, (Comparable)Boolean.valueOf(true));
                    } else if (cropBlockstate.hasProperty((Property)top)) {
                        cropBlockstate = (BlockState)cropBlockstate.setValue((Property)top, (Comparable)Boolean.valueOf(true));
                        maxAgeCropBlockstate = (BlockState)maxAgeCropBlockstate.setValue((Property)top, (Comparable)Boolean.valueOf(true));
                    } else if (cropBlockstate.hasProperty((Property)DoublePlantBlock.HALF)) {
                        cropBlockstate = (BlockState)cropBlockstate.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
                        maxAgeCropBlockstate = (BlockState)maxAgeCropBlockstate.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
                    }
                    if (BlockHelper.isBottomBlock(block)) continue;
                    Common.crops.put(maxAgeCropBlockstate, cropBlockstate);
                    continue;
                }
                if (block instanceof CocoaBlock) {
                    CocoaBlock cocoaBlock = (CocoaBlock)block;
                    BlockStateProperties.HORIZONTAL_FACING.getAllValues().forEach(direction -> {
                        BlockState zeroState = (BlockState)((BlockState)cocoaBlock.defaultBlockState().setValue((Property)CocoaBlock.AGE, (Comparable)Integer.valueOf(0))).setValue((Property)CocoaBlock.FACING, (Comparable)((Direction)direction.value()));
                        BlockState maxAgeState = (BlockState)((BlockState)cocoaBlock.defaultBlockState().setValue((Property)CocoaBlock.AGE, (Comparable)Integer.valueOf(2))).setValue((Property)CocoaBlock.FACING, (Comparable)((Direction)direction.value()));
                        Common.crops.put(maxAgeState, zeroState);
                    });
                    continue;
                }
                if (!(block instanceof BushBlock) && !(block instanceof GrowingPlantBlock) || !(block instanceof BonemealableBlock)) continue;
                Common.rightClickBlocks.add(block);
            }
        }
        for (String cropKey : (List)ConfigHandler.COMMON.harvestableCrops.get()) {
            String[] parts = BlockHelper.parseBlockString(cropKey);
            BlockState initial = BlockHelper.fromString(cropKey);
            Block block = initial.getBlock();
            if (block == Blocks.AIR || Common.isBlacklistCrop(block) || Common.isBlacklistMod(block)) continue;
            BlockState result = parts.length > 1 ? BlockHelper.fromString(parts[1]) : block.defaultBlockState();
            Common.crops.put(initial, result);
        }
        for (String blockKey : (List)ConfigHandler.COMMON.harvestableBlocks.get()) {
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockKey));
            if (block == Blocks.AIR || Common.isBlacklistCrop(block) || Common.isBlacklistMod(block)) continue;
            Common.rightClickBlocks.add(block);
        }
        BuiltInRegistries.ITEM.forEach(item -> {
            if (item instanceof DiggerItem) {
                DiggerItem digger = (DiggerItem)item;
                Tool tool = (Tool)digger.components().get(DataComponents.TOOL);
                TagKey tagKey = null;
                if (tool != null) {
                    for (Tool.Rule rule : tool.rules()) {
                        Optional optionalBlockTagKey;
                        if (!rule.correctForDrops().isPresent() || !(optionalBlockTagKey = rule.blocks().unwrapKey()).isPresent()) continue;
                        tagKey = (TagKey)optionalBlockTagKey.get();
                    }
                }
                if (tagKey == BlockTags.MINEABLE_WITH_HOE) {
                    int tier = 0;
                    try {
                        tier = Tiers.valueOf((String)digger.getTier().toString()).ordinal();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Common.hoeTools.put((Item)digger, ToolHelper.getBaseRange(tier));
                }
            }
        });
        for (String hoeItem : (List)ConfigHandler.COMMON.hoeItems.get()) {
            String[] parts = hoeItem.split("-");
            int range = ToolHelper.getBaseRange(Integer.parseInt(parts[1]));
            ResourceLocation loc = ResourceLocation.parse((String)parts[0]);
            Item item2 = (Item)BuiltInRegistries.ITEM.get(loc);
            Common.hoeTools.put(item2, range);
        }
    }

    private static String getTranslation(String key) {
        return Translations.get(key);
    }

    static {
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    public static class Common {
        private final WhiteNoiseConfigSpec.BooleanValue allowEmptyHand;
        private final WhiteNoiseConfigSpec.BooleanValue damageTool;
        private final WhiteNoiseConfigSpec.BooleanValue autoConfigMods;
        private final WhiteNoiseConfigSpec.IntValue xpFromHarvestChance;
        private final WhiteNoiseConfigSpec.IntValue xpFromHarvestAmount;
        private final WhiteNoiseConfigSpec.BooleanValue xpFromHarvestUseRange;
        private final WhiteNoiseConfigSpec.ConfigValue<String> xpFromHarvestRangeAmount;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> harvestableCrops;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> harvestableBlocks;
        private final WhiteNoiseConfigSpec.BooleanValue expandHoeRange;
        private final WhiteNoiseConfigSpec.IntValue smallTierExpansionRange;
        private final WhiteNoiseConfigSpec.IntValue highTierExpansionRange;
        private final WhiteNoiseConfigSpec.BooleanValue expandHoeRangeEnchanted;
        private final WhiteNoiseConfigSpec.IntValue maxHoeExpansionRange;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> hoeItems;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> blacklistCrops;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> blacklistMods;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> blacklistHeldItems;
        private final WhiteNoiseConfigSpec.BooleanValue allowFakePlayer;
        private static final Map<BlockState, BlockState> crops = Maps.newHashMap();
        private static final Set<Block> rightClickBlocks = Sets.newHashSet();
        private static final List<String> harvestableCropsList = List.of("harvestableCrops");
        private static final String[] defaultHarvestableCrops = new String[0];
        private static final List<String> harvestableBlocksList = List.of("harvestableBlocks");
        private static final String[] defaultHarvestableBlocks = new String[]{"minecraft:sweet_berry_bush", "minecraft:cave_vines"};
        private static final Predicate<Object> resourceLocationValidator = s -> s instanceof String && ((String)s).matches("[a-z]+[:]{1}[a-z_]+");
        private static final Predicate<Object> modidValidator = s -> s instanceof String && ((String)s).matches("^[a-z][a-z0-9_]{1,63}$");
        private static final Map<Item, Integer> hoeTools = Maps.newHashMap();
        private static final Predicate<Object> hoeItemValidator = s -> s instanceof String && ((String)s).matches("[a-z][a-z0-9_]{1,63}+[:]{1}[a-z_]+[-]{1}[0-9]+");
        private static final Predicate<Object> xpRangeValidator = s -> s instanceof String && ((String)s).matches("[0-9]+[-]{1}[0-9]+");
        private static final List<String> hoeItemList = List.of("hoeItems");
        private static final String[] defaultHoeItemList = new String[0];
        private static final List<String> blacklistCropsList = List.of("blacklistCrops");
        private static final String[] defaultBlacklistCrops = new String[0];
        private static final List<String> blacklistModsList = List.of("blacklistMods");
        private static final String[] defaultBlacklistMods = new String[0];
        private static final List<String> blacklistHeldItemsList = List.of("blacklistHeldItems");
        private static final String[] defaultBlacklistHeldItems = new String[0];

        public Common(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("general");
            this.allowEmptyHand = builder.comment(ConfigHandler.getTranslation("allowemptyhand")).define("allowEmptyHand", true);
            this.damageTool = builder.comment(ConfigHandler.getTranslation("damagetool")).define("damageTool", false);
            this.autoConfigMods = builder.comment(ConfigHandler.getTranslation("autoconfigmods")).define("autoConfigMods", true);
            this.xpFromHarvestChance = builder.comment(ConfigHandler.getTranslation("xpfromharvestchance")).defineInRange("xpFromHarvestChance", 100, 0, 100);
            this.xpFromHarvestAmount = builder.comment(ConfigHandler.getTranslation("xpfromharvestamount")).defineInRange("xpFromHarvestAmount", 1, 0, 10);
            this.xpFromHarvestUseRange = builder.comment(ConfigHandler.getTranslation("xpfromharvestuserange")).define("xpFromHarvestUseRange", false);
            this.xpFromHarvestRangeAmount = builder.comment(ConfigHandler.getTranslation("xpfromharvestrangeamount")).define("xpFromHarvestRangeAmount", (Object)"0-3", xpRangeValidator);
            this.harvestableCrops = builder.comment(ConfigHandler.getTranslation("harvestablecrops")).defineListAllowEmpty(harvestableCropsList, Common.getCropsList(), s -> s instanceof String);
            this.harvestableBlocks = builder.comment(ConfigHandler.getTranslation("harvestableblocks")).defineListAllowEmpty(harvestableBlocksList, Common.getHarvestableBlocksList(), resourceLocationValidator);
            this.expandHoeRange = builder.comment(ConfigHandler.getTranslation("expandhoerange")).define("expandHoeRange", true);
            this.smallTierExpansionRange = builder.comment(ConfigHandler.getTranslation("smalltierexpansionrange")).defineInRange("smallTierExpansionRange", 2, 1, 5);
            this.highTierExpansionRange = builder.comment(ConfigHandler.getTranslation("hightierexpansionrange")).defineInRange("highTierExpansionRange", 3, 1, 5);
            this.expandHoeRangeEnchanted = builder.comment(ConfigHandler.getTranslation("expandhoerangeenchanted")).define("expandHoeRangeEnchanted", true);
            this.maxHoeExpansionRange = builder.comment(ConfigHandler.getTranslation("maxhoeexpansionrange")).defineInRange("maxHoeExpansionRange", 11, 1, 11);
            this.hoeItems = builder.comment(ConfigHandler.getTranslation("hoeitems")).defineListAllowEmpty(hoeItemList, Common.getHoeItems(), hoeItemValidator);
            this.blacklistCrops = builder.comment(ConfigHandler.getTranslation("blacklistcrops")).defineListAllowEmpty(blacklistCropsList, Common.getBlacklistCrops(), resourceLocationValidator);
            this.blacklistMods = builder.comment(ConfigHandler.getTranslation("blacklistmods")).defineListAllowEmpty(blacklistModsList, Common.getBlacklistMods(), modidValidator);
            this.allowFakePlayer = builder.comment(ConfigHandler.getTranslation("allowfakeplayer")).define("allowFakePlayer", true);
            this.blacklistHeldItems = builder.comment(ConfigHandler.getTranslation("blacklisthelditems")).defineListAllowEmpty(blacklistHeldItemsList, Common.getBlacklistHeldItems(), resourceLocationValidator);
        }

        public static boolean allowEmptyHand() {
            return (Boolean)ConfigHandler.COMMON.allowEmptyHand.get();
        }

        public static boolean damageTool() {
            return (Boolean)ConfigHandler.COMMON.damageTool.get();
        }

        public static boolean autoConfigMods() {
            return (Boolean)ConfigHandler.COMMON.autoConfigMods.get();
        }

        public static int xpFromHarvestChance() {
            return (Integer)ConfigHandler.COMMON.xpFromHarvestChance.get();
        }

        public static int xpFromHarvestAmount() {
            return (Integer)ConfigHandler.COMMON.xpFromHarvestAmount.get();
        }

        public static boolean xpFromHarvestUseRange() {
            return (Boolean)ConfigHandler.COMMON.xpFromHarvestUseRange.get();
        }

        public static Pair<Integer, Integer> xpFromHarvestRangeAmount() {
            int right;
            String[] amounts = ((String)ConfigHandler.COMMON.xpFromHarvestRangeAmount.get()).split("-");
            int left = Integer.parseInt(amounts[0]);
            if (left > (right = Integer.parseInt(amounts[1]))) {
                return Pair.of((Object)0, (Object)3);
            }
            return Pair.of((Object)left, (Object)right);
        }

        public static Set<Block> getRightClickBlocks() {
            return rightClickBlocks;
        }

        public static Map<BlockState, BlockState> getCrops() {
            return crops;
        }

        public static boolean expandHoeRange() {
            return (Boolean)ConfigHandler.COMMON.expandHoeRange.get();
        }

        public static int smallTierExpansionRange() {
            return (Integer)ConfigHandler.COMMON.smallTierExpansionRange.get();
        }

        public static int highTierExpansionRange() {
            return (Integer)ConfigHandler.COMMON.highTierExpansionRange.get();
        }

        public static boolean expandHoeRangeEnchanted() {
            return (Boolean)ConfigHandler.COMMON.expandHoeRangeEnchanted.get();
        }

        public static int maxHoeExpansionRange() {
            return (Integer)ConfigHandler.COMMON.maxHoeExpansionRange.get();
        }

        public static Map<Item, Integer> getHoeTools() {
            return hoeTools;
        }

        public static boolean allowFakePlayer() {
            return (Boolean)ConfigHandler.COMMON.allowFakePlayer.get();
        }

        private static Supplier<List<? extends String>> getCropsList() {
            return () -> Arrays.asList(defaultHarvestableCrops);
        }

        private static Supplier<List<? extends String>> getHarvestableBlocksList() {
            return () -> Arrays.asList(defaultHarvestableBlocks);
        }

        private static Supplier<List<? extends String>> getHoeItems() {
            return () -> Arrays.asList(defaultHoeItemList);
        }

        private static Supplier<List<? extends String>> getBlacklistCrops() {
            return () -> Arrays.asList(defaultBlacklistCrops);
        }

        private static Supplier<List<? extends String>> getBlacklistMods() {
            return () -> Arrays.asList(defaultBlacklistMods);
        }

        private static Supplier<List<? extends String>> getBlacklistHeldItems() {
            return () -> Arrays.asList(defaultBlacklistHeldItems);
        }

        private static boolean isBlacklistCrop(Block block) {
            return ((List)ConfigHandler.COMMON.blacklistCrops.get()).contains(BlockHelper.getBlockId(block).toString());
        }

        private static boolean isBlacklistMod(Block block) {
            return ((List)ConfigHandler.COMMON.blacklistMods.get()).contains(BlockHelper.getBlockId(block).getNamespace());
        }

        public static boolean isBlacklistHeldItem(ItemStack stack) {
            return ((List)ConfigHandler.COMMON.blacklistHeldItems.get()).contains(ToolHelper.getItemStackId(stack).toString());
        }
    }
}

