/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit;

import io.fairyproject.Debug;
import io.fairyproject.FairyPlatform;
import io.fairyproject.PlatformType;
import io.fairyproject.bukkit.events.PostServicesInitialEvent;
import io.fairyproject.bukkit.listener.FilteredListener;
import io.fairyproject.bukkit.listener.RegisterAsListener;
import io.fairyproject.bukkit.listener.events.Events;
import io.fairyproject.bukkit.logger.ConsoleSenderLogger;
import io.fairyproject.bukkit.metadata.Metadata;
import io.fairyproject.bukkit.plugin.BukkitPluginHandler;
import io.fairyproject.bukkit.plugin.impl.RootJavaPluginIdentifier;
import io.fairyproject.bukkit.protocol.BukkitPacketEventsBuilder;
import io.fairyproject.bukkit.util.JavaPluginUtil;
import io.fairyproject.bukkit.util.SpigotUtil;
import io.fairyproject.container.PreInitialize;
import io.fairyproject.container.collection.ContainerObjCollector;
import io.fairyproject.log.Log;
import io.fairyproject.mc.protocol.MCProtocol;
import io.fairyproject.mc.protocol.PacketEventsBuilder;
import io.fairyproject.plugin.Plugin;
import io.fairyproject.plugin.PluginManager;
import io.fairyproject.util.URLClassLoaderAccess;
import io.fairyproject.util.terminable.Terminable;
import io.fairyproject.util.terminable.TerminableConsumer;
import io.fairyproject.util.terminable.composite.CompositeTerminable;
import java.io.File;
import java.net.URLClassLoader;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class FairyBukkitPlatform
extends FairyPlatform
implements TerminableConsumer {
    public static JavaPlugin PLUGIN = JavaPluginUtil.getProvidingPlugin(FairyBukkitPlatform.class);
    private final URLClassLoaderAccess classLoader;
    private final File dataFolder;
    private final CompositeTerminable compositeTerminable;

    @Override
    @NotNull
    public <T extends Terminable> T bind(@NotNull T terminable) {
        return this.compositeTerminable.bind(terminable);
    }

    public FairyBukkitPlatform(File dataFolder) {
        FairyPlatform.INSTANCE = this;
        this.dataFolder = dataFolder;
        this.compositeTerminable = CompositeTerminable.create();
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.classLoader = classLoader instanceof URLClassLoader ? URLClassLoaderAccess.create((URLClassLoader)classLoader) : URLClassLoaderAccess.create(null);
        PluginManager.initialize(new BukkitPluginHandler());
        if (!Debug.UNIT_TEST) {
            Log.set(new ConsoleSenderLogger(Bukkit.getConsoleSender()));
        }
    }

    @Override
    public void load(Plugin plugin) {
        super.load(plugin);
        this.loadProtocol();
    }

    @Override
    public void enable() {
        SpigotUtil.init();
        super.enable();
    }

    @Override
    public void disable() {
        super.disable();
        RootJavaPluginIdentifier.clearInstance();
        Metadata.destroy();
    }

    @PreInitialize
    public void onPreInitialize() {
        this.getContainerContext().objectCollectorRegistry().add(ContainerObjCollector.create().withFilter(ContainerObjCollector.inherits(Listener.class)).withFilter(ContainerObjCollector.inherits(FilteredListener.class).negate()).withAddHandler(ContainerObjCollector.warpInstance(Listener.class, listener -> {
            if (!listener.getClass().isAnnotationPresent(RegisterAsListener.class)) {
                return;
            }
            Events.subscribe(listener);
        })).withRemoveHandler(ContainerObjCollector.warpInstance(Listener.class, HandlerList::unregisterAll)));
    }

    @Override
    public void onPostServicesInitial() {
        Events.call(new PostServicesInitialEvent());
    }

    protected void loadProtocol() {
        MCProtocol.loadProtocol(this.providePacketEventBuilder());
    }

    protected PacketEventsBuilder providePacketEventBuilder() {
        return new BukkitPacketEventsBuilder(this);
    }

    @Override
    public void saveResource(String name, boolean replace) {
        PLUGIN.saveResource(name, replace);
    }

    @Override
    public URLClassLoaderAccess getClassloader() {
        return this.classLoader;
    }

    @Override
    public File getDataFolder() {
        return this.dataFolder;
    }

    @Override
    public void shutdown() {
        Bukkit.shutdown();
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public PlatformType getPlatformType() {
        return PlatformType.BUKKIT;
    }
}

