/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.configuration;

import io.fairyproject.bukkit.FairyBukkitPlatform;
import io.fairyproject.bukkit.mc.BukkitMCServer;
import io.fairyproject.bukkit.mc.entity.BukkitDataWatcherConverter;
import io.fairyproject.bukkit.mc.entity.BukkitEntityIDCounter;
import io.fairyproject.bukkit.mc.operator.BukkitMCPlayerOperator;
import io.fairyproject.bukkit.mc.operator.BukkitMCPlayerOperatorImpl;
import io.fairyproject.bukkit.mc.operator.BukkitMCPlayerPlatformOperator;
import io.fairyproject.bukkit.mc.registry.BukkitMCEntityRegistry;
import io.fairyproject.bukkit.mc.registry.BukkitMCGameProfileRegistry;
import io.fairyproject.bukkit.mc.registry.BukkitMCWorldRegistry;
import io.fairyproject.bukkit.nms.BukkitNMSManager;
import io.fairyproject.bukkit.nms.BukkitNMSManagerImpl;
import io.fairyproject.container.InjectableComponent;
import io.fairyproject.container.configuration.Configuration;
import io.fairyproject.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import io.fairyproject.libs.kyori.adventure.text.serializer.gson.legacyimpl.NBTLegacyHoverEventSerializer;
import io.fairyproject.mc.MCAdventure;
import io.fairyproject.mc.MCServer;
import io.fairyproject.mc.entity.EntityIDCounter;
import io.fairyproject.mc.registry.MCEntityRegistry;
import io.fairyproject.mc.registry.MCGameProfileRegistry;
import io.fairyproject.mc.registry.MCWorldRegistry;
import io.fairyproject.mc.registry.player.MCPlayerPlatformOperator;
import io.fairyproject.mc.scheduler.MCSchedulerProvider;
import io.fairyproject.mc.version.MCVersionMappingRegistry;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

@Configuration
public class BukkitMCConfiguration {
    @InjectableComponent
    public Server provideBukkitServer() {
        return Bukkit.getServer();
    }

    @InjectableComponent
    public MCServer provideMCServer(Server server) {
        return new BukkitMCServer(server);
    }

    @InjectableComponent
    public BukkitNMSManager provideNMSManager(MCServer mcServer, MCVersionMappingRegistry registry, Server server) {
        return new BukkitNMSManagerImpl(mcServer, registry, server.getClass());
    }

    @InjectableComponent
    public BukkitMCPlayerOperator providePlayerOperator(BukkitNMSManager nmsManager) {
        return new BukkitMCPlayerOperatorImpl(nmsManager);
    }

    @InjectableComponent
    public BukkitDataWatcherConverter provideDataWatcherConverter(BukkitNMSManager nmsManager) {
        return new BukkitDataWatcherConverter(nmsManager);
    }

    @InjectableComponent
    public EntityIDCounter provideEntityIDCounter(BukkitNMSManager nmsManager) {
        return new BukkitEntityIDCounter(nmsManager);
    }

    @InjectableComponent
    public MCAdventure.AdventureHook provideAdventureHook() {
        return MCAdventure.AdventureHook.builder().serializer(NBTLegacyHoverEventSerializer.get()).build();
    }

    @InjectableComponent
    public MCEntityRegistry provideEntityRegistry(BukkitDataWatcherConverter dataWatcherConverter, MCSchedulerProvider mcSchedulerProvider) {
        return new BukkitMCEntityRegistry(dataWatcherConverter, mcSchedulerProvider);
    }

    @InjectableComponent
    public MCWorldRegistry provideWorldRegistry(BukkitAudiences bukkitAudiences) {
        return new BukkitMCWorldRegistry(bukkitAudiences);
    }

    @InjectableComponent
    public MCPlayerPlatformOperator provideMCPlayerPlatformOperator(MCServer mcServer, BukkitAudiences audiences, BukkitDataWatcherConverter dataWatcherConverter, BukkitMCPlayerOperator playerOperator, MCVersionMappingRegistry versionMappingRegistry, MCSchedulerProvider mcSchedulerProvider) {
        return new BukkitMCPlayerPlatformOperator(mcServer, audiences, dataWatcherConverter, playerOperator, mcSchedulerProvider, versionMappingRegistry);
    }

    @InjectableComponent
    public MCGameProfileRegistry provideGameProfileBridge() {
        return new BukkitMCGameProfileRegistry();
    }

    @InjectableComponent
    public BukkitAudiences provideBukkitAudiences() {
        return BukkitAudiences.create((Plugin)FairyBukkitPlatform.PLUGIN);
    }
}

