/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.events.handler;

import com.destroystokyo.paper.event.player.PlayerHandshakeEvent;
import io.fairyproject.bukkit.FairyBukkitPlatform;
import io.fairyproject.bukkit.events.GlobalEventListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.jetbrains.annotations.NotNull;

public class HandlerListCollection
extends ArrayList<HandlerList>
implements Listener,
EventExecutor {
    private static final boolean HAS_HANDSHAKE_EVENT;
    private final ArrayList<HandlerList> forward;
    private final GlobalEventListener globalEventListener;

    public HandlerListCollection(ArrayList<HandlerList> forward, GlobalEventListener globalEventListener) {
        this.forward = forward;
        this.globalEventListener = globalEventListener;
        for (HandlerList handlerList : this.forward) {
            this.registerHandlerList(handlerList);
        }
    }

    @Override
    public boolean add(HandlerList handlerList) {
        boolean result = this.forward.add(handlerList);
        if (result) {
            this.registerHandlerList(handlerList);
        }
        return result;
    }

    private void registerHandlerList(HandlerList handlerList) {
        handlerList.register(new RegisteredListener((Listener)this, (EventExecutor)this, EventPriority.NORMAL, (Plugin)FairyBukkitPlatform.PLUGIN, false));
    }

    @Override
    public boolean remove(Object o) {
        return this.forward.remove(o);
    }

    @Override
    public HandlerList remove(int index) {
        return this.forward.remove(index);
    }

    @Override
    @NotNull
    public Iterator<HandlerList> iterator() {
        return this.forward.iterator();
    }

    @Override
    @NotNull
    public ListIterator<HandlerList> listIterator() {
        return this.forward.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<HandlerList> listIterator(int index) {
        return this.forward.listIterator(index);
    }

    public void execute(@NotNull Listener listener, @NotNull Event event) {
        PlayerHandshakeEvent handshakeEvent;
        HandlerList handlers;
        if (HAS_HANDSHAKE_EVENT && event instanceof PlayerHandshakeEvent && (handlers = (handshakeEvent = (PlayerHandshakeEvent)event).getHandlers()).getRegisteredListeners().length == 1) {
            handshakeEvent.setCancelled(true);
            handlers.unregister((Listener)this);
            return;
        }
        this.globalEventListener.onEventFired(event);
    }

    static {
        boolean hasHandshakeEvent = false;
        try {
            Class.forName("com.destroystokyo.paper.event.player.PlayerHandshakeEvent");
            hasHandshakeEvent = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HAS_HANDSHAKE_EVENT = hasHandshakeEvent;
    }
}

