/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.gui.pane.mapping;

import io.fairyproject.bukkit.gui.pane.mapping.OutlinePaneMapping;
import io.fairyproject.bukkit.gui.pane.mapping.RectanglePaneMapping;
import io.fairyproject.bukkit.gui.pane.mapping.StaticPaneMapping;

public interface PaneMapping {
    public static PaneMapping rectangle(int x, int y, int width, int height) {
        return new RectanglePaneMapping(x, y, width, height);
    }

    public static PaneMapping rectangle(int width, int height) {
        return new RectanglePaneMapping(0, 0, width, height);
    }

    public static PaneMapping rectangle(int rows) {
        return new RectanglePaneMapping(0, 0, 9, rows);
    }

    public static PaneMapping staticMapping(int[] slots) {
        return new StaticPaneMapping(slots);
    }

    public static PaneMapping outline(int x, int y, int width, int height) {
        return new OutlinePaneMapping(x, y, width, height);
    }

    public static PaneMapping outline(int width, int height) {
        return new OutlinePaneMapping(0, 0, width, height);
    }

    public static PaneMapping outline(int rows) {
        return new OutlinePaneMapping(0, 0, 9, rows);
    }

    public int getSize();

    public int[] getSlots();

    public int getSlot(int var1);

    public int getIndex(int var1);

    public int getSlot(int var1, int var2);

    public boolean hasAxis();
}

