/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.listener;

import com.google.common.collect.Sets;
import io.fairyproject.bukkit.player.PlayerEventRecognizer;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class FilteredEventList {
    private static final Map<Class<?>, Function<Event, Player>> EVENT_PLAYER_METHODS = new ConcurrentHashMap();
    private static final Set<Class<?>> NO_METHODS = Sets.newConcurrentHashSet();
    private final BiPredicate<Event, Class<? extends PlayerEventRecognizer.Attribute<?>>[]>[] filters;

    public static void registerPlayerGetter(Class<?> eventClass, Function<Event, Player> method) {
        EVENT_PLAYER_METHODS.put(eventClass, method);
    }

    private FilteredEventList(Builder builder) {
        this.filters = builder.filters.toArray(new BiPredicate[0]);
    }

    public boolean check(Event event, Class<? extends PlayerEventRecognizer.Attribute<?>>[] attributes) {
        for (BiPredicate<Event, Class<? extends PlayerEventRecognizer.Attribute<?>>[]> filter : this.filters) {
            if (filter.test(event, attributes)) continue;
            return false;
        }
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public BiPredicate<Event, Class<? extends PlayerEventRecognizer.Attribute<?>>[]>[] getFilters() {
        return this.filters;
    }

    static {
        EVENT_PLAYER_METHODS.put(BlockBreakEvent.class, event -> ((BlockBreakEvent)event).getPlayer());
        EVENT_PLAYER_METHODS.put(BlockPlaceEvent.class, event -> ((BlockPlaceEvent)event).getPlayer());
        EVENT_PLAYER_METHODS.put(FoodLevelChangeEvent.class, event -> (Player)((FoodLevelChangeEvent)event).getEntity());
    }

    public static class Builder {
        private final List<BiPredicate<Event, Class<? extends PlayerEventRecognizer.Attribute<?>>[]>> filters = new ArrayList<BiPredicate<Event, Class<? extends PlayerEventRecognizer.Attribute<?>>[]>>(1);

        public Builder filter(Predicate<Event> filter) {
            this.filters.add((event, ignored) -> filter.test((Event)event));
            return this;
        }

        public Builder filter(BiPredicate<Player, Event> filter) {
            this.filters.add((event, attributes) -> {
                Player player = PlayerEventRecognizer.tryRecognize(event, attributes);
                if (player != null) {
                    return filter.test(player, (Event)event);
                }
                return true;
            });
            return this;
        }

        public FilteredEventList build() {
            return new FilteredEventList(this);
        }
    }

    private static class MethodHandleFunction
    implements Function<Event, Player> {
        private final MethodHandle methodHandle;

        @Override
        public Player apply(Event event) {
            try {
                Object entity = this.methodHandle.invoke(event);
                if (entity instanceof Player) {
                    return (Player)entity;
                }
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("Something wrong while looking for player", throwable);
            }
            return null;
        }

        public MethodHandleFunction(MethodHandle methodHandle) {
            this.methodHandle = methodHandle;
        }
    }
}

