/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.listener.timings;

import io.fairyproject.bukkit.timings.MCTiming;
import io.fairyproject.bukkit.timings.TimingService;
import io.fairyproject.container.Autowired;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class TimedEventExecutor
implements EventExecutor {
    @Autowired
    private static TimingService TIMING_SERVICE;
    private final EventExecutor executor;
    private final MCTiming timings;

    public TimedEventExecutor(EventExecutor eventExecutor, Plugin plugin, Method method, Class<? extends Event> eventClass) {
        this.executor = eventExecutor;
        if (method == null && eventExecutor.getClass().getEnclosingClass() != null) {
            method = eventExecutor.getClass().getEnclosingMethod();
        }
        String methodName = method != null ? method.getDeclaringClass().getName() : eventExecutor.getClass().getName();
        String eventName = eventClass.getSimpleName();
        boolean special = "BlockPhysicsEvent".equals(eventName) || "Drain".equals(eventName) || "Fill".equals(eventName);
        this.timings = TIMING_SERVICE.of(plugin, (special ? "## " : "") + "Event: " + methodName + " (" + eventName + ")");
    }

    public void execute(Listener listener, Event event) throws EventException {
        if (!event.isAsynchronous() && Bukkit.isPrimaryThread()) {
            try (MCTiming ignored = this.timings.startTiming();){
                this.executor.execute(listener, event);
            }
        } else {
            this.executor.execute(listener, event);
        }
    }
}

