/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.mc.registry;

import io.fairyproject.bukkit.listener.RegisterAsListener;
import io.fairyproject.bukkit.mc.BukkitMCWorld;
import io.fairyproject.data.MetaKey;
import io.fairyproject.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import io.fairyproject.mc.MCWorld;
import io.fairyproject.mc.data.MCMetadata;
import io.fairyproject.mc.registry.MCWorldRegistry;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldUnloadEvent;

@RegisterAsListener
public class BukkitMCWorldRegistry
implements MCWorldRegistry,
Listener {
    private final MetaKey<MCWorld> KEY = MetaKey.create("fairy:mc-world", MCWorld.class);
    private final BukkitAudiences bukkitAudiences;

    @Override
    public MCWorld convert(Object worldObj) {
        if (!(worldObj instanceof World)) {
            throw new UnsupportedOperationException();
        }
        World world = (World)worldObj;
        return MCMetadata.provide(world).computeIfAbsent(this.KEY, () -> new BukkitMCWorld(world.getName(), this.bukkitAudiences));
    }

    @Override
    public MCWorld getByName(String name) {
        World world = Bukkit.getWorld((String)name);
        if (world == null) {
            return null;
        }
        return this.convert(world);
    }

    @Override
    public List<MCWorld> all() {
        return Bukkit.getWorlds().stream().map(this::convert).collect(Collectors.toList());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldUnload(WorldUnloadEvent event) {
        MCMetadata.provide(event.getWorld().getName()).remove(this.KEY);
    }

    public BukkitMCWorldRegistry(BukkitAudiences bukkitAudiences) {
        this.bukkitAudiences = bukkitAudiences;
    }
}

