/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.player;

import io.fairyproject.Fairy;
import io.fairyproject.bukkit.events.player.PlayerPostJoinEvent;
import io.fairyproject.bukkit.listener.RegisterAsListener;
import io.fairyproject.bukkit.listener.events.Events;
import io.fairyproject.bukkit.metadata.Metadata;
import io.fairyproject.container.InjectableComponent;
import io.fairyproject.mc.scheduler.MCSchedulerProvider;
import io.fairyproject.metadata.MetadataMap;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

@InjectableComponent
@RegisterAsListener
public class PlayerListener
implements Listener {
    private final Server server;
    private final MCSchedulerProvider mcSchedulerProvider;

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        Events.unregisterAll(player);
        Metadata.get(player).ifPresent(MetadataMap::cleanup);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!Fairy.isRunning()) {
            return;
        }
        Player player = event.getPlayer();
        this.mcSchedulerProvider.getEntityScheduler(player).schedule(() -> this.server.getPluginManager().callEvent((Event)new PlayerPostJoinEvent(player)), 1L);
    }

    public PlayerListener(Server server, MCSchedulerProvider mcSchedulerProvider) {
        this.server = server;
        this.mcSchedulerProvider = mcSchedulerProvider;
    }
}

