/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.protocol;

import io.fairyproject.container.InjectableComponent;
import io.fairyproject.container.PostInitialize;
import io.fairyproject.libs.packetevents.injector.SpigotChannelInjector;
import io.fairyproject.libs.packetevents.protocol.player.User;
import io.fairyproject.log.Log;
import io.fairyproject.mc.protocol.MCProtocol;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

@InjectableComponent
public class BukkitPacketEventsPatcher {
    private final MCProtocol mcProtocol;

    @PostInitialize
    public void onPostInitialize() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            User user = this.mcProtocol.getPacketEvents().getPlayerManager().getUser(player);
            if (user == null || user.getChannel() == null) {
                Log.error("Failed to patch PacketEvents for player " + player.getName() + " (" + player.getUniqueId() + ") because the user or channel is null.", new Object[0]);
                return;
            }
            SpigotChannelInjector channelInjector = (SpigotChannelInjector)this.mcProtocol.getPacketEvents().getInjector();
            channelInjector.setPlayer(user.getChannel(), player);
        }
    }

    public BukkitPacketEventsPatcher(MCProtocol mcProtocol) {
        this.mcProtocol = mcProtocol;
    }
}

