/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.reflection.resolver;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.fairyproject.bukkit.reflection.resolver.ResolverAbstract;
import io.fairyproject.bukkit.reflection.resolver.ResolverQuery;
import io.fairyproject.util.exceptionally.ThrowingSupplier;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ClassResolver
extends ResolverAbstract<Class<?>> {
    private static final LoadingCache<String, Optional<Class<?>>> CLASS_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build(new CacheLoader<String, Optional<Class<?>>>(){

        @NotNull
        public Optional<Class<?>> load(@NotNull String s) {
            try {
                return Optional.of(Class.forName(s));
            }
            catch (ClassNotFoundException ex) {
                return Optional.empty();
            }
        }
    });

    public void cache(String name, Class<?> type) {
        CLASS_CACHE.put((Object)name, Optional.of(type));
    }

    public Class<?> resolveSilent(String ... names) {
        try {
            return this.resolve(names);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Class<?> resolve(String ... names) throws ClassNotFoundException {
        ResolverQuery.Builder builder = ResolverQuery.builder();
        for (String name : names) {
            builder.with(name);
        }
        try {
            return (Class)super.resolve(builder.build());
        }
        catch (ReflectiveOperationException e) {
            throw (ClassNotFoundException)e;
        }
    }

    public Class<?> resolveSubClass(Class<?> mainClass, String ... names) throws ClassNotFoundException {
        ResolverQuery.Builder builder = ResolverQuery.builder();
        String prefix = mainClass.getName() + "$";
        for (String name : names) {
            builder.with(prefix + name);
        }
        try {
            return (Class)super.resolve(builder.build());
        }
        catch (ReflectiveOperationException e) {
            throw (ClassNotFoundException)e;
        }
    }

    @Override
    protected Class<?> resolveObject(ResolverQuery query) throws ReflectiveOperationException {
        Class result = ThrowingSupplier.sneaky(() -> (Optional)CLASS_CACHE.get((Object)query.getName())).get().orElse(null);
        if (result == null) {
            throw new ClassNotFoundException(query.toString());
        }
        return result;
    }

    @Override
    protected ClassNotFoundException notFoundException(String joinedNames) {
        return new ClassNotFoundException("Could not resolve class for " + joinedNames);
    }
}

