/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.scheduler.bukkit;

import io.fairyproject.bukkit.scheduler.bukkit.BukkitScheduledTask;
import io.fairyproject.log.Log;
import io.fairyproject.mc.scheduler.MCTickBasedScheduler;
import io.fairyproject.scheduler.ScheduledTask;
import io.fairyproject.scheduler.repeat.RepeatPredicate;
import io.fairyproject.scheduler.response.TaskResponse;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.bukkit.scheduler.BukkitTask;

public abstract class BukkitAbstractScheduler
implements MCTickBasedScheduler {
    protected <R> ScheduledTask<R> doSchedule(Callable<R> callable, Function<Runnable, BukkitTask> schedule) {
        CompletableFuture future = new CompletableFuture();
        return new BukkitScheduledTask(schedule.apply(() -> {
            if (future.isDone()) {
                return;
            }
            try {
                future.complete(callable.call());
            }
            catch (Throwable throwable) {
                Log.error("An error occurred while executing a scheduled task", throwable, new Object[0]);
                future.completeExceptionally(throwable);
            }
        }), future);
    }

    @Override
    public ScheduledTask<?> schedule(Runnable runnable) {
        return this.schedule(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public ScheduledTask<?> schedule(Runnable runnable, long delayTicks) {
        return this.schedule(() -> {
            runnable.run();
            return null;
        }, delayTicks);
    }

    @Override
    public ScheduledTask<?> scheduleAtFixedRate(Runnable runnable, long delayTicks, long intervalTicks, RepeatPredicate<?> predicate) {
        return this.scheduleAtFixedRate(() -> {
            runnable.run();
            return TaskResponse.continueTask();
        }, delayTicks, intervalTicks, predicate);
    }
}

